/*******************************************************************************
 * Copyright (c) 2016 Obeo.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Obeo - initial API and implementation
 *******************************************************************************/
package fr.obeo.dsl.designer.internal;

import org.eclipse.jface.action.Action;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.NewWizardAction;
import org.eclipse.ui.intro.IIntroManager;
import org.eclipse.ui.intro.IIntroPart;

/**
 * An action, designed to be invoked from the welcome page, which directly opens the "New example" wizard on the Sirius
 * examples category.
 * 
 * @author pcdavid
 */
public class NewSampleWizard extends Action {
    private static final String SIRIUS_EXAMPLES_CATEGORY = "org.eclipse.ui.Examples/org.eclipse.sirius.samples.category";

    @Override
    public void run() {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window != null) {
            IIntroManager introManager = PlatformUI.getWorkbench().getIntroManager();
            IIntroPart intro = introManager.getIntro();

            if (intro != null) {
                introManager.closeIntro(intro);

                // Flush pending UI Events.
                while (PlatformUI.getWorkbench().getDisplay().readAndDispatch()) {
                    // Do nothing, just wait
                }
            }

            NewWizardAction nwa = new NewWizardAction(window);
            nwa.setCategoryId(NewSampleWizard.SIRIUS_EXAMPLES_CATEGORY);
            nwa.run();

        }
    }
}
