/*
 * Decompiled with CFR 0.152.
 */
package fr.obeo.dsl.traceability.capella.design.services;

import fr.obeo.dsl.traceability.ArtifactRepository;
import fr.obeo.dsl.traceability.ArtifactType;
import fr.obeo.dsl.traceability.IArtifact;
import fr.obeo.dsl.traceability.ILink;
import fr.obeo.dsl.traceability.LinkDirection;
import fr.obeo.dsl.traceability.LinkType;
import fr.obeo.dsl.traceability.Traceability;
import fr.obeo.dsl.traceability.TraceabilityPackage;
import fr.obeo.dsl.traceability.api.IArtifactRepositoryStrategy;
import fr.obeo.dsl.traceability.api.IArtifactRepositoryUpdater;
import fr.obeo.dsl.traceability.api.ITraceabilityStrategy;
import fr.obeo.dsl.traceability.capella.design.Messages;
import fr.obeo.dsl.traceability.sirius.TraceabilitySiriusPlugin;
import fr.obeo.dsl.traceability.sirius.util.TraceabilityUtil;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.polarsys.capella.common.helpers.EcoreUtil2;

public class TraceabilityLinkServices {
    public ILink create(EObject source, EObject target) {
        LinkDirection direction;
        EObject modelElement;
        IArtifact artifact;
        ILink link = null;
        if (!(source instanceof IArtifact && !(target instanceof IArtifact) || !(source instanceof IArtifact) && target instanceof IArtifact)) {
            throw new IllegalArgumentException(Messages.tracabilityLinkService_InvalidSourceTargetPair);
        }
        if (source instanceof IArtifact) {
            artifact = (IArtifact)source;
            modelElement = TraceabilitySiriusPlugin.getPlugin().adaptSelection(target);
            direction = LinkDirection.ARTIFACT_TO_MODEL;
        } else {
            artifact = (IArtifact)target;
            modelElement = TraceabilitySiriusPlugin.getPlugin().adaptSelection(source);
            direction = LinkDirection.MODEL_TO_ARTIFACT;
        }
        Optional optStrategy = TraceabilityUtil.getTraceabilityStrategy((EObject)artifact);
        if (optStrategy.isPresent()) {
            ITraceabilityStrategy traceabilityStrategy = (ITraceabilityStrategy)optStrategy.get();
            ArtifactRepository repository = (ArtifactRepository)EcoreUtil2.getFirstContainer((EObject)artifact, (EClass)TraceabilityPackage.eINSTANCE.getArtifactRepository());
            IArtifactRepositoryStrategy repositoryStrategy = traceabilityStrategy.getRepositoryStrategy(repository.getUrl());
            Set availableLinkTypes = repositoryStrategy.getSupportedLinkTypes(modelElement, artifact.getTypes().stream().map(ArtifactType::getUri).collect(Collectors.toSet()), direction);
            Shell shell = PlatformUI.getWorkbench().getDisplay().getActiveShell();
            Optional optLinkType = TraceabilityUtil.selectLinkType((Traceability)((Traceability)traceabilityStrategy.findTraceability().get()), (Set)availableLinkTypes, (EObject)modelElement, (Shell)shell);
            if (optLinkType.isPresent()) {
                LinkType linkType = (LinkType)optLinkType.get();
                if (repositoryStrategy.linkExists(modelElement, linkType, artifact, direction)) {
                    this.openAlreadyExistWarnDialog();
                } else {
                    link = this.createLink(modelElement, linkType, direction, artifact);
                }
            }
        }
        return link;
    }

    void openAlreadyExistWarnDialog() {
        Shell shell = PlatformUI.getWorkbench().getDisplay().getActiveShell();
        MessageDialog.openWarning((Shell)shell, (String)Messages.warning, (String)Messages.tracabilityLinkCreator_AlreadyExist);
    }

    private ILink createLink(EObject modelElement, LinkType linkType, LinkDirection direction, IArtifact artifact) {
        ArtifactRepository repo = (ArtifactRepository)EcoreUtil2.getFirstContainer((EObject)artifact, (EClass)TraceabilityPackage.eINSTANCE.getArtifactRepository());
        IArtifactRepositoryUpdater artifactRepositoryUpdater = ((ITraceabilityStrategy)TraceabilityUtil.getTraceabilityStrategy((EObject)repo).orElseThrow(IllegalStateException::new)).getRepositoryUpdater(repo);
        return artifactRepositoryUpdater.createLink(modelElement, linkType, direction, artifact);
    }
}

