/*
 * Decompiled with CFR 0.152.
 */
package fr.obeo.dsl.traceability.capella.design.services;

import fr.obeo.dsl.traceability.Artifact;
import fr.obeo.dsl.traceability.IArtifact;
import fr.obeo.dsl.traceability.ILink;
import fr.obeo.dsl.traceability.INamed;
import fr.obeo.dsl.traceability.LinkDirection;
import fr.obeo.dsl.traceability.api.ITraceabilityStrategy;
import fr.obeo.dsl.traceability.capella.design.Messages;
import fr.obeo.dsl.traceability.capella.design.services.TraceabilityLinkServices;
import fr.obeo.dsl.traceability.sirius.TraceabilitySiriusPlugin;
import fr.obeo.dsl.traceability.sirius.util.TraceabilityUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.sirius.business.api.query.DRepresentationQuery;
import org.eclipse.sirius.business.api.resource.ResourceDescriptor;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.DRepresentationDescriptor;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.data.cs.Part;
import org.polarsys.capella.core.sirius.analysis.DiagramServices;

public class TraceabilityServices {
    public String getArtifactTitle(Artifact self) {
        return Optional.ofNullable(self.getIdentifier()).orElse("");
    }

    public Collection<IArtifact> getAllAvailableArtifacts(EObject context) {
        Optional traceabilityStrategy = TraceabilityUtil.getTraceabilityStrategy((EObject)context);
        if (traceabilityStrategy.isPresent()) {
            return ((ITraceabilityStrategy)traceabilityStrategy.get()).getAllArtifacts();
        }
        return Collections.emptyList();
    }

    public static Set<Part> getVisiblePartsOnDiagram(DDiagram diagram) {
        return diagram.getDiagramElements().stream().map(DSemanticDecorator::getTarget).filter(Part.class::isInstance).map(obj -> (Part)obj).collect(Collectors.toSet());
    }

    public Collection<EObject> getVisibleArtifactsOnDiagram(EObject context) {
        DDiagram diagram = this.getDiagram(context);
        if (diagram != null) {
            return diagram.getDiagramElements().stream().map(DSemanticDecorator::getTarget).filter(Artifact.class::isInstance).collect(Collectors.toSet());
        }
        return Collections.emptySet();
    }

    public DDiagram getDiagram(EObject context) {
        DDiagram result = null;
        if (context instanceof DDiagram) {
            result = (DDiagram)context;
        } else if (context instanceof DDiagramElement) {
            result = ((DDiagramElement)context).getParentDiagram();
        }
        return result;
    }

    public EObject hideArtifacts(EObject diagram, Collection<EObject> selectedArtifacts, Collection<EObject> artifactsInDiagram) {
        if (diagram instanceof DDiagram) {
            DDiagram ddiagram = (DDiagram)diagram;
            Set artifactsToHide = artifactsInDiagram.stream().filter(req -> !selectedArtifacts.contains(req)).collect(Collectors.toSet());
            DiagramServices diagramService = DiagramServices.getDiagramServices();
            ddiagram.getDiagramElements().stream().filter(container -> artifactsToHide.contains(container.getTarget())).forEach(arg_0 -> ((DiagramServices)diagramService).removeContainerView(arg_0));
        }
        return diagram;
    }

    public List<EObject> getLinkSources(ILink self, DDiagram diagram) {
        if (LinkDirection.ARTIFACT_TO_MODEL.equals((Object)self.getDirection())) {
            return Arrays.asList(self.getArtifact());
        }
        return this.getModelElements(self, diagram);
    }

    public List<EObject> getLinkTargets(ILink self, DDiagram diagram) {
        if (LinkDirection.ARTIFACT_TO_MODEL.equals((Object)self.getDirection())) {
            return this.getModelElements(self, diagram);
        }
        return Arrays.asList(self.getArtifact());
    }

    public List<EObject> getModelElements(ILink self, DDiagram diagram) {
        ArrayList<EObject> result = new ArrayList<EObject>();
        Optional.ofNullable(self.getModelObject()).ifPresent(result::add);
        if (self.getModelObject() instanceof Component) {
            List parts = TraceabilityServices.getVisiblePartsOnDiagram(diagram).stream().filter(part -> part.getType() == self.getModelObject()).collect(Collectors.toList());
            result.addAll(parts);
        }
        return result;
    }

    public List<IArtifact> getAllLinkedArtifactsForElement(EObject semanticModelElement) {
        EObject input = TraceabilitySiriusPlugin.getPlugin().adaptSelection(semanticModelElement);
        return this.getAllAvailableArtifacts(input).stream().filter(artifact -> artifact.getOwnedLinks().stream().anyMatch(link -> input.equals(link.getModelObject()))).collect(Collectors.toList());
    }

    public List<IArtifact> getAllLinkedArtifactsForDiagram(DDiagram diagram) {
        DRepresentationDescriptor descriptor = new DRepresentationQuery((DRepresentation)diagram).getRepresentationDescriptor();
        return this.getAllAvailableArtifacts((EObject)descriptor).stream().filter(artifact -> artifact.getOwnedLinks().stream().anyMatch(link -> descriptor.equals(link.getModelObject()))).collect(Collectors.toList());
    }

    public ILink createTraceabilityLink(EObject source, EObject target) {
        return new TraceabilityLinkServices().create(source, target);
    }

    public boolean hasValidEnds(EObject source, EObject target) {
        boolean result = false;
        if (source instanceof Artifact && !(target instanceof Artifact)) {
            result = true;
        } else if (target instanceof Artifact && !(source instanceof Artifact)) {
            result = true;
        }
        return result;
    }

    public String getTruncatedTitle(IArtifact artifact) {
        String title = artifact.getTitle();
        if (title.length() > 40) {
            title = String.valueOf(title.substring(0, 40)) + "...";
        }
        return title;
    }

    public boolean isArtifactLinkedToDiagram(Artifact self, DDiagram diagram) {
        return this.getDiagramLinks(self, diagram).size() > 0;
    }

    public List<ILink> getDiagramLinks(Artifact self, DDiagram diagram) {
        List<ILink> result = self.getOwnedLinks().stream().filter(link -> this.isDiagramLink((ILink)link, diagram)).collect(Collectors.toList());
        return result;
    }

    private boolean isDiagramLink(ILink link, DDiagram diagram) {
        DRepresentationDescriptor diagramDescriptor = new DRepresentationQuery((DRepresentation)diagram).getRepresentationDescriptor();
        if (diagramDescriptor != null && link.getModelObject() instanceof DRepresentationDescriptor) {
            ResourceDescriptor linkRepresentationPath = ((DRepresentationDescriptor)link.getModelObject()).getRepPath();
            return linkRepresentationPath != null && linkRepresentationPath.equals((Object)diagramDescriptor.getRepPath());
        }
        return false;
    }

    public String getDiagramLinkLabel(ILink link) {
        String linkLabel = Optional.ofNullable(link.getType()).map(INamed::getName).orElse(Messages.traceabilityServices_DefaultDiagramLink);
        String artifactTypeName = Optional.ofNullable(link.getArtifact()).map(IArtifact::getTypes).map(Collection::stream).flatMap(Stream::findFirst).map(INamed::getName).orElse(Messages.traceabilityServices_DefaultArtifactType);
        return String.format(Messages.traceabilityServices_DiagramLink, linkLabel, artifactTypeName);
    }
}

