/*
 * Decompiled with CFR 0.152.
 */
package fr.obeo.dsl.traceability.capella.design.utils;

import java.util.Optional;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.business.api.componentization.DiagramComponentizationManager;
import org.eclipse.sirius.diagram.description.DiagramDescription;
import org.eclipse.sirius.diagram.description.Layer;
import org.eclipse.sirius.diagram.tools.api.command.ChangeLayerActivationCommand;

public final class TraceabilityUtils {
    private TraceabilityUtils() {
    }

    public static boolean isTraceabilityViewpointActive(EObject element) {
        Session session = SessionManager.INSTANCE.getSession(element);
        if (session != null) {
            return session.getSelectedViewpoints(true).stream().anyMatch(vp -> "fr.obeo.dsl.traceability.capella.vp".equals(vp.getName()));
        }
        return false;
    }

    public static Optional<ChangeLayerActivationCommand> getActivateTraceabilityLayerCommand(Session session, DDiagram diagram) {
        return TraceabilityUtils.getTraceabilityLayer(session, diagram).filter(layer -> !diagram.getActivatedLayers().contains(layer)).map(layer -> new ChangeLayerActivationCommand(session.getTransactionalEditingDomain(), diagram, layer, (IProgressMonitor)new NullProgressMonitor()));
    }

    public static Optional<Layer> getTraceabilityLayer(Session session, DDiagram diagram) {
        DiagramDescription diagramDesc = diagram.getDescription();
        return new DiagramComponentizationManager().getAllLayers(session.getSelectedViewpoints(false), diagramDesc).stream().filter(layer -> "fr.obeo.dsl.traceability.capella.layer".equals(layer.getName())).findFirst();
    }
}

