/*
 * Decompiled with CFR 0.152.
 */
package fr.obeo.dsl.traceability;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum ArtifactPropertyType implements Enumerator
{
    STRING(0, "String", "String"),
    INTEGER(1, "Integer", "Integer"),
    DECIMAL(2, "Decimal", "Decimal"),
    BOOLEAN(3, "Boolean", "Boolean"),
    DATE(4, "Date", "Date"),
    DATE_TIME(5, "DateTime", "DateTime"),
    XML_LITERAL(6, "XMLLiteral", "XMLLiteral");

    public static final int STRING_VALUE = 0;
    public static final int INTEGER_VALUE = 1;
    public static final int DECIMAL_VALUE = 2;
    public static final int BOOLEAN_VALUE = 3;
    public static final int DATE_VALUE = 4;
    public static final int DATE_TIME_VALUE = 5;
    public static final int XML_LITERAL_VALUE = 6;
    private static final ArtifactPropertyType[] VALUES_ARRAY;
    public static final List<ArtifactPropertyType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new ArtifactPropertyType[]{STRING, INTEGER, DECIMAL, BOOLEAN, DATE, DATE_TIME, XML_LITERAL};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static ArtifactPropertyType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ArtifactPropertyType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ArtifactPropertyType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ArtifactPropertyType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ArtifactPropertyType get(int value) {
        switch (value) {
            case 0: {
                return STRING;
            }
            case 1: {
                return INTEGER;
            }
            case 2: {
                return DECIMAL;
            }
            case 3: {
                return BOOLEAN;
            }
            case 4: {
                return DATE;
            }
            case 5: {
                return DATE_TIME;
            }
            case 6: {
                return XML_LITERAL;
            }
        }
        return null;
    }

    private ArtifactPropertyType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

