/*
 * Decompiled with CFR 0.152.
 */
package fr.obeo.dsl.traceability;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum ImpactType implements Enumerator
{
    FOLLOWS_LINK(0, "FOLLOWS_LINK", "FOLLOWS_LINK"),
    OPPOSITE_LINK(1, "OPPOSITE_LINK", "OPPOSITE_LINK"),
    SYMMETRIC_IMPACT(2, "SYMMETRIC_IMPACT", "SYMMETRIC_IMPACT"),
    NO_IMPACT(3, "NO_IMPACT", "NO_IMPACT");

    public static final int FOLLOWS_LINK_VALUE = 0;
    public static final int OPPOSITE_LINK_VALUE = 1;
    public static final int SYMMETRIC_IMPACT_VALUE = 2;
    public static final int NO_IMPACT_VALUE = 3;
    private static final ImpactType[] VALUES_ARRAY;
    public static final List<ImpactType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new ImpactType[]{FOLLOWS_LINK, OPPOSITE_LINK, SYMMETRIC_IMPACT, NO_IMPACT};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static ImpactType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ImpactType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ImpactType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ImpactType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ImpactType get(int value) {
        switch (value) {
            case 0: {
                return FOLLOWS_LINK;
            }
            case 1: {
                return OPPOSITE_LINK;
            }
            case 2: {
                return SYMMETRIC_IMPACT;
            }
            case 3: {
                return NO_IMPACT;
            }
        }
        return null;
    }

    private ImpactType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

