/*
 * Decompiled with CFR 0.152.
 */
package fr.obeo.dsl.traceability.api;

import fr.obeo.dsl.traceability.ArtifactRepository;
import fr.obeo.dsl.traceability.IArtifact;
import fr.obeo.dsl.traceability.ILink;
import fr.obeo.dsl.traceability.LinkDirection;
import fr.obeo.dsl.traceability.LinkType;
import fr.obeo.dsl.traceability.TraceabilitySnapshot;
import fr.obeo.dsl.traceability.api.IArtifactRepositoryUpdater;
import fr.obeo.dsl.traceability.api.ISnapshotComparison;
import fr.obeo.dsl.traceability.api.ITraceabilityStrategy;
import fr.obeo.dsl.traceability.api.UrlMatchingSettings;
import java.util.Optional;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.ecore.EObject;

public interface IArtifactRepositoryStrategy {
    public String getArtifactRepositoryURL();

    public Optional<IArtifactRepositoryUpdater> findArtifactRepositoryUpdater();

    public IArtifactRepositoryUpdater createArtifactRepositoryUpdater() throws IllegalStateException;

    public TraceabilitySnapshot computeSnapshot();

    public Optional<TraceabilitySnapshot> findLatestSnapshot();

    public ISnapshotComparison compareWithLatestSnapshot(TraceabilitySnapshot var1) throws CoreException;

    public Optional<IArtifact> findArtifact(String var1);

    public Optional<ILink> findLink(String var1, LinkType var2, IArtifact var3, LinkDirection var4);

    default public boolean linkExists(String modelObjectId, LinkType linkType, IArtifact artifact, LinkDirection direction) {
        return this.findLink(modelObjectId, linkType, artifact, direction).isPresent();
    }

    public Optional<ILink> findLink(EObject var1, LinkType var2, IArtifact var3, LinkDirection var4);

    default public boolean linkExists(EObject modelObject, LinkType linkType, IArtifact artifact, LinkDirection direction) {
        return this.findLink(modelObject, linkType, artifact, direction).isPresent();
    }

    public Set<LinkType> getSupportedLinkTypes(EObject var1, Set<String> var2, LinkDirection var3);

    public Optional<ArtifactRepository> findArtifactRepository();

    public ITraceabilityStrategy getTraceabilityStrategy();

    default public Optional<UrlMatchingSettings> findUrlMatchingSettings() {
        return this.findArtifactRepository().map(UrlMatchingSettings::new);
    }
}

