/*
 * Decompiled with CFR 0.152.
 */
package fr.obeo.dsl.traceability.api;

import fr.obeo.dsl.traceability.ArtifactRepository;
import fr.obeo.dsl.traceability.ArtifactType;
import fr.obeo.dsl.traceability.IArtifact;
import fr.obeo.dsl.traceability.ILink;
import fr.obeo.dsl.traceability.LinkDirection;
import fr.obeo.dsl.traceability.LinkType;
import fr.obeo.dsl.traceability.Traceability;
import fr.obeo.dsl.traceability.api.IArtifactRepositoryChangeSet;
import fr.obeo.dsl.traceability.api.IArtifactRepositoryStrategy;
import fr.obeo.dsl.traceability.api.IArtifactRepositoryUpdater;
import fr.obeo.dsl.traceability.api.UrlMatchingSettings;
import java.time.Instant;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;

public interface ITraceabilityStrategy {
    public IArtifactRepositoryStrategy getRepositoryStrategy(String var1);

    public Optional<Traceability> findTraceability();

    public Optional<LinkType> findLinkType(String var1);

    public Optional<ArtifactType> findArtifactType(String var1);

    public Collection<IArtifact> getAllArtifacts();

    public Collection<ILink> getLinks(EObject var1, LinkDirection var2);

    public Set<IArtifact> getArtifactsLinkedTo(EObject var1, LinkDirection var2);

    public IArtifactRepositoryUpdater getRepositoryUpdater(ArtifactRepository var1) throws IllegalArgumentException;

    public Traceability createTraceability(IProgressMonitor var1) throws CoreException;

    public void applyChanges(List<? extends IArtifactRepositoryChangeSet> var1, Instant var2);

    default public List<UrlMatchingSettings> findAllUrlMatchingSettings() {
        return this.findTraceability().map(trac -> trac.getRepositories().stream().map(this::getRepositoryUpdater).map(IArtifactRepositoryUpdater::getStrategy).map(IArtifactRepositoryStrategy::findUrlMatchingSettings).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList())).orElseGet(Collections::emptyList);
    }
}

