/*
 * Decompiled with CFR 0.152.
 */
package fr.obeo.dsl.traceability.api;

import com.fasterxml.jackson.annotation.JsonIgnore;
import fr.obeo.dsl.traceability.ArtifactRepository;
import fr.obeo.dsl.traceability.UrlPattern;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import java.util.stream.Collectors;
import org.eclipse.emf.common.util.EList;

public class UrlMatchingSettings
implements Predicate<String> {
    private final String label;
    private final String oslcURL;
    private final List<PatternAndReplacement> patterns;

    private UrlMatchingSettings(String label, String oslcURL, List<PatternAndReplacement> patterns) {
        this.label = label;
        this.oslcURL = oslcURL;
        this.patterns = patterns;
    }

    public UrlMatchingSettings(ArtifactRepository repo) {
        this.label = repo.getName();
        this.oslcURL = repo.getUrl();
        EList<UrlPattern> locPatterns = repo.getUrlPatterns();
        ArrayList<PatternAndReplacement> patAndReplace = new ArrayList<PatternAndReplacement>();
        for (UrlPattern patt : locPatterns) {
            patAndReplace.add(PatternAndReplacementBuilder.of(patt.getPattern(), patt.getReplacement()).build());
        }
        this.patterns = patAndReplace;
    }

    public String getLabel() {
        return this.label;
    }

    public String getOslcURL() {
        return this.oslcURL;
    }

    public List<PatternAndReplacement> getPatterns() {
        return this.patterns;
    }

    @Override
    public boolean test(String candidate) {
        if (this.patterns == null) {
            return false;
        }
        return this.patterns.stream().anyMatch(p -> p.test(candidate));
    }

    public Optional<String> getTargetURL(String droppedURL) {
        if (this.patterns == null) {
            return Optional.empty();
        }
        return this.patterns.stream().filter(p -> p.test(droppedURL)).map(p -> p.apply(droppedURL)).findFirst();
    }

    /* synthetic */ UrlMatchingSettings(String string, String string2, List list, UrlMatchingSettings urlMatchingSettings) {
        this(string, string2, list);
    }

    public static final class PatternAndReplacement
    implements Predicate<String>,
    Function<String, String> {
        private Pattern pattern;
        private String replacement;

        private PatternAndReplacement(Pattern pattern, String replacement) {
            this.pattern = Objects.requireNonNull(pattern);
            this.replacement = Objects.requireNonNull(replacement);
        }

        public Pattern getPattern() {
            return this.pattern;
        }

        public void setPattern(Pattern pattern) {
            this.pattern = Objects.requireNonNull(pattern);
        }

        public String getReplacement() {
            return this.replacement;
        }

        public void setReplacement(String replacement) {
            this.replacement = replacement;
        }

        @Override
        public boolean test(String candidate) {
            return this.pattern.matcher(candidate).matches();
        }

        @Override
        public String apply(String candidate) {
            Matcher matcher = this.pattern.matcher(candidate);
            if (matcher.matches()) {
                return matcher.replaceFirst(this.replacement);
            }
            return null;
        }
    }

    public static final class PatternAndReplacementBuilder {
        @JsonIgnore
        public static final String PROP_REGEX = "regex";
        @JsonIgnore
        public static final String PROP_REPLACEMENT = "replacement";
        private String regex;
        private String replacement;
        @JsonIgnore
        private PropertyChangeSupport pcs = new PropertyChangeSupport(this);

        public static PatternAndReplacementBuilder of(String regex, String replacement) throws PatternSyntaxException {
            PatternAndReplacementBuilder result = new PatternAndReplacementBuilder();
            result.setRegex(regex);
            result.setReplacement(replacement);
            return result;
        }

        public static PatternAndReplacementBuilder newSample() {
            return PatternAndReplacementBuilder.of("https://example.com/polarion/#/project/(?<prj>[a-zA-Z0-9]+)/workitem\\?id=(?<item>[a-zA-Z\\-0-9]+)", "https://example.com/polarion/oslc/services/projects/${prj}/workitems/${item}");
        }

        public PatternAndReplacement build() {
            return new PatternAndReplacement(Pattern.compile(this.regex), this.replacement);
        }

        public String getRegex() {
            return this.regex;
        }

        public void setRegex(String regex) {
            String old = this.regex;
            this.regex = regex;
            this.pcs.firePropertyChange(PROP_REGEX, old, regex);
        }

        public String getReplacement() {
            return this.replacement;
        }

        public void setReplacement(String replacement) {
            String old = this.replacement;
            this.replacement = replacement;
            this.pcs.firePropertyChange(PROP_REPLACEMENT, old, replacement);
        }

        public void addPropertyChangeListener(PropertyChangeListener listener) {
            this.pcs.addPropertyChangeListener(listener);
        }

        public void removePropertyChangeListener(PropertyChangeListener listener) {
            this.pcs.removePropertyChangeListener(listener);
        }
    }

    public static final class UrlMatchingSettingsBuilder {
        @JsonIgnore
        public static final String PROP_PATTERNS = "patterns";
        @JsonIgnore
        public static final String PROP_LABEL = "label";
        @JsonIgnore
        public static final String PROP_OSLC_URL = "oslcURL";
        private String label;
        private String oslcURL;
        private List<PatternAndReplacementBuilder> patterns = new ArrayList<PatternAndReplacementBuilder>();
        @JsonIgnore
        private PropertyChangeSupport pcs = new PropertyChangeSupport(this);

        public UrlMatchingSettings build() {
            UrlMatchingSettings result = new UrlMatchingSettings(this.label, this.oslcURL, this.patterns.stream().map(b -> b.build()).collect(Collectors.toList()), null);
            return result;
        }

        public String getLabel() {
            return this.label;
        }

        public void setLabel(String label) {
            String old = this.label;
            this.label = label;
            this.pcs.firePropertyChange(PROP_LABEL, old, label);
        }

        public String getOslcURL() {
            return this.oslcURL;
        }

        public void setOslcURL(String oslcURL) {
            String old = this.oslcURL;
            this.oslcURL = oslcURL;
            this.pcs.firePropertyChange(PROP_OSLC_URL, old, oslcURL);
        }

        public List<PatternAndReplacementBuilder> getPatterns() {
            return this.patterns;
        }

        public void setPatterns(List<PatternAndReplacementBuilder> patterns) {
            List<PatternAndReplacementBuilder> old = this.patterns;
            this.patterns = patterns;
            this.pcs.firePropertyChange(PROP_PATTERNS, old, patterns);
        }

        public void addPropertyChangeListener(PropertyChangeListener listener) {
            this.pcs.addPropertyChangeListener(listener);
        }

        public void removePropertyChangeListener(PropertyChangeListener listener) {
            this.pcs.removePropertyChangeListener(listener);
        }
    }
}

