/*
 * Decompiled with CFR 0.152.
 */
package fr.obeo.dsl.traceability.impl;

import fr.obeo.dsl.traceability.Artifact;
import fr.obeo.dsl.traceability.ArtifactPackage;
import fr.obeo.dsl.traceability.ArtifactProperty;
import fr.obeo.dsl.traceability.ArtifactPropertyDef;
import fr.obeo.dsl.traceability.ArtifactPropertyType;
import fr.obeo.dsl.traceability.ArtifactRepository;
import fr.obeo.dsl.traceability.ArtifactStore;
import fr.obeo.dsl.traceability.ArtifactType;
import fr.obeo.dsl.traceability.Domain;
import fr.obeo.dsl.traceability.ImpactType;
import fr.obeo.dsl.traceability.Link;
import fr.obeo.dsl.traceability.LinkDirection;
import fr.obeo.dsl.traceability.LinkDirectionConstraint;
import fr.obeo.dsl.traceability.LinkRange;
import fr.obeo.dsl.traceability.LinkSnapshot;
import fr.obeo.dsl.traceability.LinkType;
import fr.obeo.dsl.traceability.LinksByModelObjectId;
import fr.obeo.dsl.traceability.Publication;
import fr.obeo.dsl.traceability.PublicationSettings;
import fr.obeo.dsl.traceability.SynchronizationPoint;
import fr.obeo.dsl.traceability.Traceability;
import fr.obeo.dsl.traceability.TraceabilityFactory;
import fr.obeo.dsl.traceability.TraceabilityPackage;
import fr.obeo.dsl.traceability.TraceabilitySnapshot;
import fr.obeo.dsl.traceability.UriPrefix;
import fr.obeo.dsl.traceability.UrlPattern;
import fr.obeo.dsl.traceability.impl.ArtifactImpl;
import fr.obeo.dsl.traceability.impl.ArtifactPackageImpl;
import fr.obeo.dsl.traceability.impl.ArtifactPropertyDefImpl;
import fr.obeo.dsl.traceability.impl.ArtifactPropertyImpl;
import fr.obeo.dsl.traceability.impl.ArtifactRepositoryImpl;
import fr.obeo.dsl.traceability.impl.ArtifactStoreImpl;
import fr.obeo.dsl.traceability.impl.ArtifactTypeImpl;
import fr.obeo.dsl.traceability.impl.DomainImpl;
import fr.obeo.dsl.traceability.impl.LinkImpl;
import fr.obeo.dsl.traceability.impl.LinkRangeImpl;
import fr.obeo.dsl.traceability.impl.LinkSnapshotImpl;
import fr.obeo.dsl.traceability.impl.LinkTypeImpl;
import fr.obeo.dsl.traceability.impl.LinksByModelObjectIdImpl;
import fr.obeo.dsl.traceability.impl.PublicationImpl;
import fr.obeo.dsl.traceability.impl.PublicationSettingsImpl;
import fr.obeo.dsl.traceability.impl.SynchronizationPointImpl;
import fr.obeo.dsl.traceability.impl.TraceabilityImpl;
import fr.obeo.dsl.traceability.impl.TraceabilitySnapshotImpl;
import fr.obeo.dsl.traceability.impl.UriPrefixImpl;
import fr.obeo.dsl.traceability.impl.UrlPatternImpl;
import java.time.Instant;
import java.util.UUID;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.impl.EFactoryImpl;
import org.eclipse.emf.ecore.plugin.EcorePlugin;

public class TraceabilityFactoryImpl
extends EFactoryImpl
implements TraceabilityFactory {
    public static TraceabilityFactory init() {
        try {
            TraceabilityFactory theTraceabilityFactory = (TraceabilityFactory)EPackage.Registry.INSTANCE.getEFactory("http://www.obeo.fr/dsl/traceability");
            if (theTraceabilityFactory != null) {
                return theTraceabilityFactory;
            }
        }
        catch (Exception exception) {
            EcorePlugin.INSTANCE.log((Object)exception);
        }
        return new TraceabilityFactoryImpl();
    }

    public EObject create(EClass eClass) {
        switch (eClass.getClassifierID()) {
            case 2: {
                return this.createDomain();
            }
            case 3: {
                return this.createArtifactType();
            }
            case 4: {
                return this.createArtifactPropertyDef();
            }
            case 5: {
                return this.createLinkType();
            }
            case 6: {
                return this.createArtifactStore();
            }
            case 7: {
                return this.createArtifactRepository();
            }
            case 8: {
                return this.createLinkRange();
            }
            case 9: {
                return this.createArtifactPackage();
            }
            case 11: {
                return this.createArtifact();
            }
            case 12: {
                return this.createArtifactProperty();
            }
            case 14: {
                return this.createLink();
            }
            case 15: {
                return this.createTraceability();
            }
            case 16: {
                return this.createLinksByModelObjectId();
            }
            case 18: {
                return this.createTraceabilitySnapshot();
            }
            case 20: {
                return this.createLinkSnapshot();
            }
            case 21: {
                return this.createUriPrefix();
            }
            case 22: {
                return this.createSynchronizationPoint();
            }
            case 23: {
                return this.createPublication();
            }
            case 24: {
                return this.createPublicationSettings();
            }
            case 25: {
                return this.createUrlPattern();
            }
        }
        throw new IllegalArgumentException("The class '" + eClass.getName() + "' is not a valid classifier");
    }

    public Object createFromString(EDataType eDataType, String initialValue) {
        switch (eDataType.getClassifierID()) {
            case 26: {
                return this.createArtifactPropertyTypeFromString(eDataType, initialValue);
            }
            case 27: {
                return this.createLinkDirectionConstraintFromString(eDataType, initialValue);
            }
            case 28: {
                return this.createImpactTypeFromString(eDataType, initialValue);
            }
            case 29: {
                return this.createLinkDirectionFromString(eDataType, initialValue);
            }
            case 30: {
                return this.createInstantFromString(eDataType, initialValue);
            }
        }
        throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
    }

    public String convertToString(EDataType eDataType, Object instanceValue) {
        switch (eDataType.getClassifierID()) {
            case 26: {
                return this.convertArtifactPropertyTypeToString(eDataType, instanceValue);
            }
            case 27: {
                return this.convertLinkDirectionConstraintToString(eDataType, instanceValue);
            }
            case 28: {
                return this.convertImpactTypeToString(eDataType, instanceValue);
            }
            case 29: {
                return this.convertLinkDirectionToString(eDataType, instanceValue);
            }
            case 30: {
                return this.convertInstantToString(eDataType, instanceValue);
            }
        }
        throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
    }

    @Override
    public Domain createDomain() {
        DomainImpl domain = new DomainImpl();
        domain.setId(UUID.randomUUID().toString());
        return domain;
    }

    @Override
    public ArtifactType createArtifactType() {
        ArtifactTypeImpl artifactType = new ArtifactTypeImpl();
        artifactType.setId(UUID.randomUUID().toString());
        return artifactType;
    }

    @Override
    public ArtifactPropertyDef createArtifactPropertyDef() {
        ArtifactPropertyDefImpl artifactPropertyDef = new ArtifactPropertyDefImpl();
        artifactPropertyDef.setId(UUID.randomUUID().toString());
        return artifactPropertyDef;
    }

    @Override
    public LinkType createLinkType() {
        LinkTypeImpl linkType = new LinkTypeImpl();
        linkType.setId(UUID.randomUUID().toString());
        return linkType;
    }

    @Override
    public ArtifactStore createArtifactStore() {
        ArtifactStoreImpl artifactStore = new ArtifactStoreImpl();
        artifactStore.setId(UUID.randomUUID().toString());
        return artifactStore;
    }

    @Override
    public ArtifactRepository createArtifactRepository() {
        ArtifactRepositoryImpl artifactRepository = new ArtifactRepositoryImpl();
        artifactRepository.setId(UUID.randomUUID().toString());
        return artifactRepository;
    }

    @Override
    public LinkRange createLinkRange() {
        LinkRangeImpl linkRange = new LinkRangeImpl();
        linkRange.setId(UUID.randomUUID().toString());
        linkRange.setDirectionConstraint(LinkDirectionConstraint.MODEL_TO_ARTIFACT);
        return linkRange;
    }

    @Override
    public ArtifactPackage createArtifactPackage() {
        ArtifactPackageImpl artifactPackage = new ArtifactPackageImpl();
        artifactPackage.setId(UUID.randomUUID().toString());
        return artifactPackage;
    }

    @Override
    public Artifact createArtifact() {
        ArtifactImpl artifact = new ArtifactImpl();
        artifact.setId(UUID.randomUUID().toString());
        return artifact;
    }

    @Override
    public ArtifactProperty createArtifactProperty() {
        ArtifactPropertyImpl artifactProperty = new ArtifactPropertyImpl();
        artifactProperty.setId(UUID.randomUUID().toString());
        return artifactProperty;
    }

    @Override
    public Link createLink() {
        LinkImpl link = new LinkImpl();
        link.setId(UUID.randomUUID().toString());
        return link;
    }

    @Override
    public Traceability createTraceability() {
        TraceabilityImpl traceability = new TraceabilityImpl();
        traceability.setId(UUID.randomUUID().toString());
        return traceability;
    }

    @Override
    public LinksByModelObjectId createLinksByModelObjectId() {
        LinksByModelObjectIdImpl linksByModelObjectId = new LinksByModelObjectIdImpl();
        return linksByModelObjectId;
    }

    @Override
    public TraceabilitySnapshot createTraceabilitySnapshot() {
        TraceabilitySnapshotImpl traceabilitySnapshot = new TraceabilitySnapshotImpl();
        return traceabilitySnapshot;
    }

    @Override
    public LinkSnapshot createLinkSnapshot() {
        LinkSnapshotImpl linkSnapshot = new LinkSnapshotImpl();
        return linkSnapshot;
    }

    @Override
    public UriPrefix createUriPrefix() {
        UriPrefixImpl uriPrefix = new UriPrefixImpl();
        return uriPrefix;
    }

    @Override
    public SynchronizationPoint createSynchronizationPoint() {
        SynchronizationPointImpl synchronizationPoint = new SynchronizationPointImpl();
        synchronizationPoint.setId(UUID.randomUUID().toString());
        return synchronizationPoint;
    }

    @Override
    public Publication createPublication() {
        PublicationImpl publication = new PublicationImpl();
        publication.setId(UUID.randomUUID().toString());
        return publication;
    }

    @Override
    public PublicationSettings createPublicationSettings() {
        PublicationSettingsImpl publicationSettings = new PublicationSettingsImpl();
        publicationSettings.setId(UUID.randomUUID().toString());
        return publicationSettings;
    }

    @Override
    public UrlPattern createUrlPattern() {
        UrlPatternImpl urlPattern = new UrlPatternImpl();
        urlPattern.setId(UUID.randomUUID().toString());
        return urlPattern;
    }

    public ArtifactPropertyType createArtifactPropertyTypeFromString(EDataType eDataType, String initialValue) {
        ArtifactPropertyType result = ArtifactPropertyType.get(initialValue);
        if (result == null) {
            throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
        }
        return result;
    }

    public String convertArtifactPropertyTypeToString(EDataType eDataType, Object instanceValue) {
        return instanceValue == null ? null : instanceValue.toString();
    }

    public LinkDirectionConstraint createLinkDirectionConstraintFromString(EDataType eDataType, String initialValue) {
        LinkDirectionConstraint result = LinkDirectionConstraint.get(initialValue);
        if (result == null) {
            throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
        }
        return result;
    }

    public String convertLinkDirectionConstraintToString(EDataType eDataType, Object instanceValue) {
        return instanceValue == null ? null : instanceValue.toString();
    }

    public LinkDirection createLinkDirectionFromString(EDataType eDataType, String initialValue) {
        LinkDirection result = LinkDirection.get(initialValue);
        if (result == null) {
            throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
        }
        return result;
    }

    public String convertLinkDirectionToString(EDataType eDataType, Object instanceValue) {
        return instanceValue == null ? null : instanceValue.toString();
    }

    public ImpactType createImpactTypeFromString(EDataType eDataType, String initialValue) {
        ImpactType result = ImpactType.get(initialValue);
        if (result == null) {
            throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
        }
        return result;
    }

    public String convertImpactTypeToString(EDataType eDataType, Object instanceValue) {
        return instanceValue == null ? null : instanceValue.toString();
    }

    public Instant createInstantFromString(EDataType eDataType, String initialValue) {
        return Instant.parse(initialValue);
    }

    public String convertInstantToString(EDataType eDataType, Object instanceValue) {
        return super.convertToString(eDataType, instanceValue);
    }

    @Override
    public TraceabilityPackage getTraceabilityPackage() {
        return (TraceabilityPackage)this.getEPackage();
    }

    @Deprecated
    public static TraceabilityPackage getPackage() {
        return TraceabilityPackage.eINSTANCE;
    }
}

