/*
 * Decompiled with CFR 0.152.
 */
package fr.obeo.dsl.traceability.sirius;

import fr.obeo.dsl.traceability.sirius.api.IDropArtifactCommandContributor;
import fr.obeo.dsl.traceability.sirius.api.IModelObjectActionTarget;
import fr.obeo.dsl.traceability.sirius.api.ISelectionAdapter;
import fr.obeo.dsl.traceability.sirius.cnf.TraceabilityDropPartListener;
import fr.obeo.dsl.traceability.sirius.cnf.TraceabilityDropTargetListener;
import fr.obeo.dsl.traceability.sirius.util.Messages;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.EMFPlugin;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.ui.EclipseUIPlugin;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWindowListener;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.navigator.CommonNavigator;
import org.osgi.framework.BundleContext;

public class TraceabilitySiriusPlugin
extends EMFPlugin {
    public static final String PLUGIN_ID = "fr.obeo.dsl.traceability.sirius.util";
    public static final TraceabilitySiriusPlugin INSTANCE = new TraceabilitySiriusPlugin();
    private static Implementation plugin;

    public TraceabilitySiriusPlugin() {
        super(new ResourceLocator[0]);
    }

    public ResourceLocator getPluginResourceLocator() {
        return plugin;
    }

    public static Implementation getPlugin() {
        return plugin;
    }

    static /* synthetic */ Implementation access$0() {
        return plugin;
    }

    public static class Implementation
    extends EclipseUIPlugin {
        private IWindowListener windowListener;
        private TraceabilityDropPartListener traceabilityDropPartListener;
        private TraceabilityDropTargetListener traceabilityDropTargetListener;
        private List<ISelectionAdapter> selectionAdapters;
        private List<IDropArtifactCommandContributor> dropCommandContributors;

        public Implementation() {
            plugin = this;
        }

        public void start(BundleContext context) throws Exception {
            super.start(context);
            plugin = this;
            this.loadSelectionAdapters();
            this.loadDropCommandContributors();
            this.registerWindowListeners();
        }

        public void stop(BundleContext context) throws Exception {
            IWorkbench workbench;
            plugin = null;
            if (this.windowListener != null) {
                PlatformUI.getWorkbench().removeWindowListener(this.windowListener);
            }
            if ((workbench = PlatformUI.getWorkbench()) != null && this.windowListener != null) {
                workbench.removeWindowListener(this.windowListener);
            }
            if (workbench != null && this.traceabilityDropPartListener != null) {
                IWorkbenchWindow[] windows;
                IWorkbenchWindow[] iWorkbenchWindowArray = windows = PlatformUI.getWorkbench().getWorkbenchWindows();
                int n = windows.length;
                int n2 = 0;
                while (n2 < n) {
                    IWorkbenchWindow window = iWorkbenchWindowArray[n2];
                    window.getPartService().removePartListener((IPartListener2)this.traceabilityDropPartListener);
                    ++n2;
                }
            }
            if (this.selectionAdapters != null) {
                this.selectionAdapters = null;
            }
            if (this.dropCommandContributors != null) {
                this.dropCommandContributors = null;
            }
            super.stop(context);
        }

        private void registerWindowListeners() {
            new Thread(() -> {
                while (!PlatformUI.isWorkbenchRunning() || PlatformUI.getWorkbench().isStarting()) {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException e) {
                        this.logError(Messages.plugin_InitInterrupted, e);
                    }
                }
                this.addListeners();
            }).start();
        }

        protected void addListeners() {
            IWorkbenchWindow[] windows;
            this.traceabilityDropTargetListener = new TraceabilityDropTargetListener();
            this.traceabilityDropPartListener = new TraceabilityDropPartListener(this.traceabilityDropTargetListener);
            this.windowListener = new IWindowListener(){

                public void windowOpened(IWorkbenchWindow window) {
                    window.getPartService().addPartListener((IPartListener2)traceabilityDropPartListener);
                }

                public void windowDeactivated(IWorkbenchWindow window) {
                }

                public void windowClosed(IWorkbenchWindow window) {
                    window.getPartService().removePartListener((IPartListener2)traceabilityDropPartListener);
                }

                public void windowActivated(IWorkbenchWindow window) {
                }
            };
            IWorkbench workbench = PlatformUI.getWorkbench();
            workbench.addWindowListener(this.windowListener);
            IWorkbenchWindow[] iWorkbenchWindowArray = windows = workbench.getWorkbenchWindows();
            int n = windows.length;
            int n2 = 0;
            while (n2 < n) {
                IWorkbenchWindow window = iWorkbenchWindowArray[n2];
                window.getPartService().addPartListener((IPartListener2)this.traceabilityDropPartListener);
                this.installDropTargetListenerOnOpenViews(window);
                ++n2;
            }
        }

        private void installDropTargetListenerOnOpenViews(IWorkbenchWindow window) {
            IWorkbenchPage[] iWorkbenchPageArray = window.getPages();
            int n = iWorkbenchPageArray.length;
            int n2 = 0;
            while (n2 < n) {
                IWorkbenchPage page = iWorkbenchPageArray[n2];
                IViewReference[] iViewReferenceArray = page.getViewReferences();
                int n3 = iViewReferenceArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    IViewReference viewReference = iViewReferenceArray[n4];
                    final IViewPart view = viewReference.getView(false);
                    if (view instanceof CommonNavigator) {
                        Display.getDefault().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                TraceabilityDropPartListener.registerDropListener((CommonNavigator)view, (DropTargetListener)traceabilityDropTargetListener);
                            }
                        });
                    }
                    ++n4;
                }
                ++n2;
            }
        }

        protected void loadSelectionAdapters() {
            this.selectionAdapters = new ArrayList<ISelectionAdapter>();
            IExtension[] iExtensionArray = Platform.getExtensionRegistry().getExtensionPoint("fr.obeo.dsl.traceability.sirius.selection.adapter").getExtensions();
            int n = iExtensionArray.length;
            int n2 = 0;
            while (n2 < n) {
                IExtension extension = iExtensionArray[n2];
                IConfigurationElement[] iConfigurationElementArray = extension.getConfigurationElements();
                int n3 = iConfigurationElementArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement configurationElement = iConfigurationElementArray[n4];
                    if ("selectionAdapter".equals(configurationElement.getName())) {
                        try {
                            ISelectionAdapter participant = (ISelectionAdapter)configurationElement.createExecutableExtension("class");
                            this.selectionAdapters.add(participant);
                        }
                        catch (CoreException e) {
                            this.getLog().log((IStatus)new Status(4, TraceabilitySiriusPlugin.PLUGIN_ID, "Wrong extension declared on 'fr.obeo.dsl.traceability.sirius.selection.adapter', could not instantiate target class.", (Throwable)e));
                        }
                    }
                    ++n4;
                }
                ++n2;
            }
        }

        protected void loadDropCommandContributors() {
            this.dropCommandContributors = new ArrayList<IDropArtifactCommandContributor>();
            IExtension[] iExtensionArray = Platform.getExtensionRegistry().getExtensionPoint("fr.obeo.dsl.traceability.sirius.drop.command.contributor").getExtensions();
            int n = iExtensionArray.length;
            int n2 = 0;
            while (n2 < n) {
                IExtension extension = iExtensionArray[n2];
                IConfigurationElement[] iConfigurationElementArray = extension.getConfigurationElements();
                int n3 = iConfigurationElementArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement configurationElement = iConfigurationElementArray[n4];
                    if ("dropCommandContributor".equals(configurationElement.getName())) {
                        try {
                            IDropArtifactCommandContributor contributor = (IDropArtifactCommandContributor)configurationElement.createExecutableExtension("class");
                            this.dropCommandContributors.add(contributor);
                        }
                        catch (CoreException e) {
                            this.getLog().log((IStatus)new Status(4, TraceabilitySiriusPlugin.PLUGIN_ID, "Wrong extension declared on 'fr.obeo.dsl.traceability.sirius.drop.command.contributor', could not instantiate target class.", (Throwable)e));
                        }
                    }
                    ++n4;
                }
                ++n2;
            }
        }

        public EObject adaptSelection(EObject source) {
            if (source == null) {
                return null;
            }
            return this.selectionAdapters.stream().filter(ad -> ad.test(source)).map(ad -> ad.adapt(source)).findFirst().orElse(source);
        }

        public Optional<Command> getDropArtifactCommandContribution(IModelObjectActionTarget target, Session session, Supplier<EObject> supplier) {
            return this.dropCommandContributors.stream().filter(contrib -> contrib.test(target, session)).map(contrib -> contrib.getCommandContribution(target, session, supplier).orElse(null)).filter(Objects::nonNull).reduce((cmd1, cmd2) -> cmd1.chain(cmd2));
        }

        public void logError(String message, Throwable cause) {
            this.getLog().log((IStatus)new Status(4, TraceabilitySiriusPlugin.PLUGIN_ID, message, cause));
        }

        public void logError(String message) {
            this.getLog().log((IStatus)new Status(4, TraceabilitySiriusPlugin.PLUGIN_ID, message));
        }
    }
}

