/*
 * Decompiled with CFR 0.152.
 */
package fr.obeo.dsl.traceability.sirius.cnf;

import fr.obeo.dsl.traceability.ArtifactPackage;
import fr.obeo.dsl.traceability.ArtifactRepository;
import fr.obeo.dsl.traceability.ArtifactStore;
import fr.obeo.dsl.traceability.IArtifact;
import fr.obeo.dsl.traceability.IArtifactContainer;
import fr.obeo.dsl.traceability.TraceabilityPackage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.IElementComparer;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.widgets.TreeItem;

public class TraceabilityDropTargetListener
extends DropTargetAdapter {
    public void dragOver(DropTargetEvent event) {
        if (LocalSelectionTransfer.getTransfer().isSupportedType(event.currentDataType) && event.item instanceof TreeItem && ((TreeItem)event.item).getData() instanceof IArtifactContainer) {
            event.detail = 2;
        }
    }

    public void drop(DropTargetEvent event) {
        if (event.item instanceof TreeItem && ((TreeItem)event.item).getData() instanceof IArtifactContainer && event.data instanceof TreeSelection && Arrays.stream(((TreeSelection)event.data).toArray()).anyMatch(o -> o instanceof IArtifactContainer && !(o instanceof ArtifactStore))) {
            final IArtifactContainer container = (IArtifactContainer)((TreeItem)event.item).getData();
            ArtifactRepository targetRepo = (ArtifactRepository)this.getFirstAncestor((EObject)container, TraceabilityPackage.eINSTANCE.getArtifactRepository()).orElseThrow(() -> new IllegalStateException("The drop should have occurred within an Artifact Repository"));
            TreeSelection sel = (TreeSelection)event.data;
            ArrayList<TreePath> treePaths = new ArrayList<TreePath>();
            final ArrayList<IArtifact> artifactsToMove = new ArrayList<IArtifact>();
            final ArrayList<ArtifactPackage> packagesToMove = new ArrayList<ArtifactPackage>();
            TreePath[] treePathArray = sel.getPaths();
            int n = treePathArray.length;
            int n2 = 0;
            while (n2 < n) {
                TreePath treePath = treePathArray[n2];
                if (treePath.getLastSegment() instanceof IArtifactContainer && !(treePath.getLastSegment() instanceof ArtifactStore) && !treePaths.stream().anyMatch(tp -> treePath.startsWith(tp, sel.getElementComparer())) && this.isChildOf(treePath, targetRepo, sel.getElementComparer())) {
                    Iterator it = treePaths.iterator();
                    while (it.hasNext()) {
                        TreePath next = (TreePath)it.next();
                        if (!next.startsWith(treePath, sel.getElementComparer())) continue;
                        it.remove();
                    }
                    treePaths.add(treePath);
                }
                ++n2;
            }
            for (TreePath treePath : treePaths) {
                ArtifactPackage pack;
                Object next = treePath.getLastSegment();
                if (next instanceof IArtifact) {
                    ArtifactRepository sourceRepo;
                    IArtifact artifact = (IArtifact)next;
                    if (artifact.eContainer() == container || !Objects.equals(sourceRepo = (ArtifactRepository)this.getFirstAncestor((EObject)artifact, TraceabilityPackage.eINSTANCE.getArtifactRepository()).orElseThrow(() -> new IllegalStateException("The drop should have occurred within an Artifact Repository")), targetRepo)) continue;
                    artifactsToMove.add(artifact);
                    continue;
                }
                if (!(next instanceof ArtifactPackage) || next instanceof ArtifactStore || (pack = (ArtifactPackage)next).eContainer() == container) continue;
                packagesToMove.add(pack);
            }
            Session.of((EObject)container).ifPresent(session -> {
                RecordingCommand cmd = null;
                if (!artifactsToMove.isEmpty()) {
                    cmd = new RecordingCommand(session.getTransactionalEditingDomain(), "Move artifact(s) to " + container.eClass().getName()){

                        protected void doExecute() {
                            container.getOwnedArtifacts().addAll((Collection)artifactsToMove);
                        }
                    };
                }
                if (container instanceof ArtifactPackage && !packagesToMove.isEmpty()) {
                    RecordingCommand packCmd = new RecordingCommand(session.getTransactionalEditingDomain(), "Move package(s) to " + container.eClass().getName()){

                        protected void doExecute() {
                            ((ArtifactPackage)container).getSubPackages().addAll((Collection)packagesToMove);
                        }
                    };
                    cmd = Optional.ofNullable(cmd).map(arg_0 -> TraceabilityDropTargetListener.lambda$5((Command)packCmd, arg_0)).orElse((Command)packCmd);
                }
                if (cmd != null && cmd.canExecute()) {
                    session.getTransactionalEditingDomain().getCommandStack().execute(cmd);
                }
            });
        }
    }

    private boolean isChildOf(TreePath treePath, Object target, IElementComparer elementComparer) {
        boolean result = false;
        int i = 0;
        while (!result && i < treePath.getSegmentCount()) {
            Object candidate = treePath.getSegment(i);
            result = elementComparer == null ? Objects.equals(candidate, target) : elementComparer.equals(candidate, target);
            ++i;
        }
        return result;
    }

    private Optional<EObject> getFirstAncestor(EObject from, EClass eClass) {
        EObject result = from.eContainer();
        while (result != null && !eClass.isInstance((Object)result)) {
            result = result.eContainer();
        }
        return Optional.ofNullable(result);
    }

    public void dropAccept(DropTargetEvent event) {
        if (LocalSelectionTransfer.getTransfer().isSupportedType(event.currentDataType) && event.item instanceof TreeItem && ((TreeItem)event.item).getData() instanceof IArtifactContainer) {
            event.detail = 2;
        }
    }

    public void dragEnter(DropTargetEvent event) {
        int i = 0;
        while (i < event.dataTypes.length) {
            if (LocalSelectionTransfer.getTransfer().isSupportedType(event.dataTypes[i])) {
                event.currentDataType = event.dataTypes[i];
                return;
            }
            ++i;
        }
    }

    private static /* synthetic */ Command lambda$5(Command command, Command c) {
        return c.chain(command);
    }
}

