/*
 * Decompiled with CFR 0.152.
 */
package fr.obeo.dsl.traceability.sirius.util;

import fr.obeo.dsl.traceability.Domain;
import fr.obeo.dsl.traceability.LinkType;
import fr.obeo.dsl.traceability.Traceability;
import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.ITreeContentProvider;

public class LinkSelectionContentProvider
implements ITreeContentProvider {
    private final Set<LinkType> availableLinkTypes;

    public LinkSelectionContentProvider(Set<LinkType> availableLinkTypes) {
        this.availableLinkTypes = Objects.requireNonNull(availableLinkTypes);
    }

    public Object[] getElements(Object inputElement) {
        Object[] result = inputElement instanceof Object[] ? (Object[])inputElement : (inputElement instanceof Collection ? ((Collection)inputElement).toArray() : (inputElement instanceof Traceability ? ((Traceability)inputElement).getDomains().toArray() : new Object[]{}));
        return result;
    }

    public Object[] getChildren(Object parentElement) {
        Object[] children = new Object[]{};
        if (parentElement instanceof Traceability) {
            children = ((Traceability)parentElement).getDomains().toArray();
        } else if (parentElement instanceof Domain) {
            children = ((Domain)parentElement).getOwnedLinkTypes().stream().filter(type -> this.availableLinkTypes.contains(type)).collect(Collectors.toList()).toArray();
        }
        return children;
    }

    public Object getParent(Object element) {
        if (element instanceof EObject) {
            return ((EObject)element).eContainer();
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        boolean hasChildren = false;
        if (element instanceof Traceability) {
            hasChildren = !((Traceability)element).getDomains().isEmpty();
        } else if (element instanceof Domain) {
            hasChildren = !((Domain)element).getOwnedLinkTypes().isEmpty();
        }
        return hasChildren;
    }
}

