/*
 * Decompiled with CFR 0.152.
 */
package fr.obeo.dsl.traceability.sirius.util;

import fr.obeo.dsl.traceability.LinkType;
import fr.obeo.dsl.traceability.Traceability;
import fr.obeo.dsl.traceability.api.ITraceabilityStrategy;
import fr.obeo.dsl.traceability.provider.TraceabilityItemProviderAdapterFactory;
import fr.obeo.dsl.traceability.sirius.util.LinkSelectionContentProvider;
import fr.obeo.dsl.traceability.sirius.util.Messages;
import java.util.Optional;
import java.util.Set;
import org.eclipse.core.runtime.Adapters;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;

public final class TraceabilityUtil {
    private TraceabilityUtil() {
    }

    public static Optional<ITraceabilityStrategy> getTraceabilityStrategy(EObject context) {
        return Session.of((EObject)context).map(session -> (ITraceabilityStrategy)Adapters.adapt((Object)session, ITraceabilityStrategy.class, (boolean)true));
    }

    public static Optional<LinkType> selectLinkType(Traceability traceability, final Set<LinkType> availableLinkTypes, final EObject target, Shell shell) {
        LinkType result = null;
        if (availableLinkTypes.size() == 1) {
            result = availableLinkTypes.iterator().next();
        } else {
            Object[] results;
            AdapterFactoryLabelProvider labelProvider = new AdapterFactoryLabelProvider((AdapterFactory)new TraceabilityItemProviderAdapterFactory());
            LinkSelectionContentProvider contentProvider = new LinkSelectionContentProvider(availableLinkTypes);
            ElementTreeSelectionDialog dlg = new ElementTreeSelectionDialog(shell, (ILabelProvider)labelProvider, contentProvider){

                protected TreeViewer doCreateTreeViewer(Composite parent, int style) {
                    TreeViewer treeviewer = new TreeViewer(new Tree(parent, style));
                    treeviewer.setAutoExpandLevel(-1);
                    return treeviewer;
                }
            };
            dlg.setTitle(Messages.TraceabilityUtil_DialogTitle);
            dlg.setHelpAvailable(false);
            dlg.setAllowMultiple(false);
            dlg.setValidator(new ISelectionStatusValidator(){

                public IStatus validate(Object[] selection) {
                    if (selection.length == 1 && selection[0] instanceof LinkType) {
                        return Status.OK_STATUS;
                    }
                    String msg = availableLinkTypes.size() == 0 ? String.format(Messages.TraceabilityUtil_NoLinkAvailable, Optional.ofNullable(target).map(EObject::eClass).map(ENamedElement::getName).orElse("null")) : Messages.TraceabilityUtil_InvalidSelection;
                    return new Status(4, "fr.obeo.dsl.traceability.sirius.util", msg);
                }
            });
            dlg.setInput((Object)traceability);
            if (dlg.open() == 0 && (results = dlg.getResult()) != null && results.length > 0) {
                result = (LinkType)results[0];
            }
        }
        return Optional.ofNullable(result);
    }
}

