/*
 * Decompiled with CFR 0.152.
 */
package fr.obeo.dsl.traceability.sirius.util;

import fr.obeo.dsl.traceability.sirius.TraceabilitySiriusPlugin;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.sirius.business.api.dialect.DialectManager;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.common.tools.api.interpreter.IInterpreter;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DSemanticDiagram;
import org.eclipse.sirius.diagram.business.api.helper.graphicalfilters.HideFilterHelper;
import org.eclipse.sirius.diagram.business.api.query.DDiagramElementQuery;
import org.eclipse.sirius.diagram.business.internal.helper.task.operations.CreateViewTask;
import org.eclipse.sirius.diagram.description.AbstractNodeMapping;
import org.eclipse.sirius.diagram.description.DiagramElementMapping;
import org.eclipse.sirius.diagram.description.EdgeMapping;
import org.eclipse.sirius.diagram.description.Layer;
import org.eclipse.sirius.diagram.description.tool.CreateView;
import org.eclipse.sirius.diagram.description.tool.ToolFactory;
import org.eclipse.sirius.ecore.extender.business.api.accessor.ModelAccessor;
import org.eclipse.sirius.ecore.extender.business.api.accessor.exception.FeatureNotFoundException;
import org.eclipse.sirius.ecore.extender.business.api.accessor.exception.MetaClassNotFoundException;
import org.eclipse.sirius.tools.api.command.CommandContext;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;

public final class TraceabilityViewsUtil {
    private TraceabilityViewsUtil() {
    }

    public static void showView(EObject semanticElement, DSemanticDecorator containerView, Session session) {
        TraceabilityViewsUtil.findRepresentation(containerView).ifPresent(representation -> {
            List<DDiagramElement> hiddenDiagramElements = TraceabilityViewsUtil.getHiddenExistingDiagramElements(semanticElement, containerView);
            List<DDiagramElement> presentDiagramElements = TraceabilityViewsUtil.getExistingDiagramElements(semanticElement, containerView);
            if (!hiddenDiagramElements.isEmpty()) {
                for (DDiagramElement existingDiagramElement : hiddenDiagramElements) {
                    HideFilterHelper.INSTANCE.reveal(existingDiagramElement);
                }
            } else if (presentDiagramElements.isEmpty()) {
                TraceabilityViewsUtil.createView(semanticElement, containerView, representation, session);
            }
            DialectManager.INSTANCE.refresh(representation, (IProgressMonitor)new NullProgressMonitor());
        });
    }

    private static List<DDiagramElement> getExistingDiagramElements(EObject semanticElement, DSemanticDecorator containerView) {
        ArrayList<DDiagramElement> existingDiagramElements = new ArrayList<DDiagramElement>();
        if (containerView instanceof DSemanticDiagram) {
            for (DDiagramElement element : ((DSemanticDiagram)containerView).getDiagramElements()) {
                if (!semanticElement.equals(element.getTarget())) continue;
                existingDiagramElements.add(element);
            }
        }
        return existingDiagramElements;
    }

    private static List<DDiagramElement> getHiddenExistingDiagramElements(EObject semanticElement, DSemanticDecorator containerView) {
        ArrayList<DDiagramElement> existingDiagramElements = new ArrayList<DDiagramElement>();
        if (containerView instanceof DSemanticDiagram) {
            for (DDiagramElement element : ((DSemanticDiagram)containerView).getDiagramElements()) {
                if (!semanticElement.equals(element.getTarget())) continue;
                DDiagramElementQuery query = new DDiagramElementQuery(element);
                if (query.isHidden()) {
                    existingDiagramElements.add(element);
                }
                existingDiagramElements.addAll(TraceabilityViewsUtil.getHiddenParentContainerViews(element));
            }
        }
        return existingDiagramElements;
    }

    private static List<DDiagramElement> getHiddenParentContainerViews(DDiagramElement diagramElement) {
        ArrayList<DDiagramElement> containerViews = new ArrayList<DDiagramElement>();
        EObject containerView = diagramElement.eContainer();
        while (!(containerView instanceof DDiagram) && containerView instanceof DDiagramElement) {
            DDiagramElementQuery query = new DDiagramElementQuery((DDiagramElement)containerView);
            if (query.isHidden()) {
                containerViews.add((DDiagramElement)containerView);
            }
            containerView = containerView.eContainer();
        }
        return containerViews;
    }

    private static void createView(EObject semanticElement, DSemanticDecorator containerView, DRepresentation representation, Session session) {
        List<DiagramElementMapping> semanticElementMappings = TraceabilityViewsUtil.getMappings(semanticElement, containerView, session);
        IInterpreter interpreter = session.getInterpreter();
        interpreter.setVariable("containerView", (Object)containerView);
        CreateView createViewOp = ToolFactory.eINSTANCE.createCreateView();
        Iterator<DiagramElementMapping> iterator = semanticElementMappings.iterator();
        while (iterator.hasNext()) {
            DiagramElementMapping semanticElementMapping;
            DiagramElementMapping tmpSemanticElementMapping = semanticElementMapping = iterator.next();
            createViewOp.setMapping(tmpSemanticElementMapping);
            createViewOp.setContainerViewExpression("var:containerView");
            try {
                CommandContext context = new CommandContext(semanticElement, representation);
                CreateViewTask task = new CreateViewTask(context, session.getModelAccessor(), createViewOp, session.getInterpreter());
                task.execute();
                Object createdView = session.getInterpreter().getVariable(createViewOp.getVariableName());
                if (!(createdView instanceof DDiagramElement)) continue;
                DDiagramElement element = (DDiagramElement)createdView;
                HideFilterHelper.INSTANCE.reveal(element);
            }
            catch (FeatureNotFoundException | MetaClassNotFoundException e) {
                TraceabilitySiriusPlugin.getPlugin().logError(e.getMessage(), e);
            }
        }
    }

    private static Optional<DRepresentation> findRepresentation(DSemanticDecorator containerView) {
        DRepresentation representation = null;
        if (containerView instanceof DRepresentation) {
            representation = (DRepresentation)containerView;
        } else if (containerView instanceof DDiagramElement) {
            representation = ((DDiagramElement)containerView).getParentDiagram();
        }
        return Optional.ofNullable(representation);
    }

    private static List<DiagramElementMapping> getMappings(EObject semanticElement, DSemanticDecorator containerView, Session session) {
        if (containerView instanceof DSemanticDiagram) {
            return TraceabilityViewsUtil.getTraceabilityMappingsForDiagram(semanticElement, (DSemanticDiagram)containerView, session);
        }
        return Collections.emptyList();
    }

    public static List<DiagramElementMapping> getTraceabilityMappingsForDiagram(EObject semanticElement, DSemanticDiagram diagram, Session session) {
        ArrayList<DiagramElementMapping> mappings = new ArrayList<DiagramElementMapping>();
        Optional<Object> traceabilityLayer = Optional.empty();
        if (TraceabilityViewsUtil.isTraceabilityLayerActive((DDiagram)diagram)) {
            traceabilityLayer = TraceabilityViewsUtil.getTraceabilityLayer((DDiagram)diagram);
        }
        if (traceabilityLayer.isPresent()) {
            ModelAccessor modelAccessor = session.getModelAccessor();
            Layer layer = (Layer)traceabilityLayer.get();
            EList reusedMappings = layer.getReusedMappings();
            for (DiagramElementMapping mapping : reusedMappings) {
                Object domainClass;
                if (mapping instanceof AbstractNodeMapping) {
                    domainClass = ((AbstractNodeMapping)mapping).getDomainClass();
                    if (!modelAccessor.eInstanceOf(semanticElement, (String)domainClass) || mapping.isCreateElements()) continue;
                    mappings.add(mapping);
                    continue;
                }
                if (!(mapping instanceof EdgeMapping) || !modelAccessor.eInstanceOf(semanticElement, (String)(domainClass = ((EdgeMapping)mapping).getDomainClass())) || mapping.isCreateElements()) continue;
                mappings.add(mapping);
            }
            EList nodeMappings = layer.getNodeMappings();
            for (DiagramElementMapping mapping : nodeMappings) {
                String domainClass = ((AbstractNodeMapping)mapping).getDomainClass();
                if (!modelAccessor.eInstanceOf(semanticElement, domainClass) || mapping.isCreateElements()) continue;
                mappings.add(mapping);
            }
            EList containerMappings = layer.getContainerMappings();
            for (DiagramElementMapping mapping : containerMappings) {
                String domainClass = ((AbstractNodeMapping)mapping).getDomainClass();
                if (!modelAccessor.eInstanceOf(semanticElement, domainClass) || mapping.isCreateElements()) continue;
                mappings.add(mapping);
            }
        }
        return mappings;
    }

    public static boolean isTraceabilityLayerActive(DDiagram diagram) {
        EList activatedLayers = diagram.getActivatedLayers();
        return activatedLayers.stream().anyMatch(TraceabilityViewsUtil::isTraceabilityLayer);
    }

    public static boolean isTraceabilityLayer(Layer layer) {
        if (layer != null) {
            return "fr.obeo.dsl.traceability.capella.layer".equals(layer.getName());
        }
        return false;
    }

    public static Optional<Layer> getTraceabilityLayer(DDiagram diagram) {
        EList activatedLayers = diagram.getActivatedLayers();
        Optional<Layer> layer = activatedLayers.stream().filter(TraceabilityViewsUtil::isTraceabilityLayer).findFirst();
        return layer;
    }
}

