/*
 * Decompiled with CFR 0.152.
 */
package fr.obeo.perseus.client.ui;

import fr.obeo.perseus.client.PerseusClientPlugin;
import fr.obeo.perseus.client.api.IPerseusServerCredentialProvider;
import fr.obeo.perseus.client.ui.oauth.LoginAuthServlet;
import fr.obeo.perseus.client.ui.oauth.OAuthLoopbackServerDefaultHandler;
import fr.obeo.perseus.client.ui.oauth.PerseusServerCredentialProvider;
import fr.obeo.perseus.client.util.PerseusProperties;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.EMFPlugin;
import org.eclipse.emf.common.ui.EclipseUIPlugin;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.handler.ContextHandlerCollection;
import org.eclipse.jetty.server.handler.HandlerList;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.eclipse.jetty.util.thread.ThreadPool;
import org.osgi.framework.BundleContext;

public class PerseusClientUIPlugin
extends EMFPlugin {
    public static final String PLUGIN_ID = "fr.obeo.perseus.client.ui";
    public static final PerseusClientUIPlugin INSTANCE = new PerseusClientUIPlugin();
    private static Implementation plugin;

    public PerseusClientUIPlugin() {
        super(new ResourceLocator[0]);
    }

    public ResourceLocator getPluginResourceLocator() {
        return plugin;
    }

    public static Implementation getPlugin() {
        return plugin;
    }

    static /* synthetic */ Implementation access$0() {
        return plugin;
    }

    public static class Implementation
    extends EclipseUIPlugin {
        private Server oauthLoginLoopbackServer;

        public Implementation() {
            plugin = this;
            PerseusServerCredentialProvider perseusServerCredentialProvider = new PerseusServerCredentialProvider(PerseusClientPlugin.getPlugin().getHttpSupportFactory());
            PerseusClientPlugin.getPlugin().register((IPerseusServerCredentialProvider)perseusServerCredentialProvider);
        }

        public void start(BundleContext context) throws Exception {
            super.start(context);
            plugin = this;
        }

        public void stop(BundleContext context) throws Exception {
            plugin = null;
            if (this.oauthLoginLoopbackServer != null) {
                try {
                    this.oauthLoginLoopbackServer.stop();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.oauthLoginLoopbackServer = null;
            }
            super.stop(context);
        }

        public Server getOAuth2LoginLoopbackServer() {
            if (this.oauthLoginLoopbackServer == null) {
                this.oauthLoginLoopbackServer = this.createLoopbackServer();
                try {
                    this.oauthLoginLoopbackServer.start();
                }
                catch (Exception e) {
                    this.oauthLoginLoopbackServer = null;
                    this.logError("Could not start loopback server for OIDC. This will prevent use of Perseus features.", e);
                }
            }
            return this.oauthLoginLoopbackServer;
        }

        private Server createLoopbackServer() {
            QueuedThreadPool threadPool = new QueuedThreadPool();
            threadPool.setName("Perseus loopback server for OAuth-2.0");
            Server server = new Server((ThreadPool)threadPool);
            ServerConnector connector = new ServerConnector(server);
            connector.setHost(PerseusProperties.getOAuth2LoopbackAddress());
            int port = PerseusProperties.getOAuth2LocalServerPort();
            if (port > 0) {
                connector.setPort(PerseusProperties.getOAuth2LocalServerPort());
            }
            server.addConnector((Connector)connector);
            HandlerList handlerList = new HandlerList();
            ContextHandlerCollection contexts = new ContextHandlerCollection();
            handlerList.addHandler((Handler)contexts);
            ServletContextHandler context = new ServletContextHandler();
            context.setContextPath("/login");
            context.addServlet(LoginAuthServlet.class, "/auth");
            contexts.addHandler((Handler)context);
            OAuthLoopbackServerDefaultHandler defaultHandler = new OAuthLoopbackServerDefaultHandler();
            handlerList.addHandler((Handler)defaultHandler);
            server.setHandler((Handler)handlerList);
            return server;
        }

        public void logError(String message, Throwable cause) {
            this.getLog().log((IStatus)new Status(4, PerseusClientUIPlugin.PLUGIN_ID, message, cause));
        }

        public void logError(String message) {
            this.getLog().log((IStatus)new Status(4, PerseusClientUIPlugin.PLUGIN_ID, message));
        }
    }
}

