/*
 * Decompiled with CFR 0.152.
 */
package fr.obeo.perseus.client.ui.dialogs;

import fr.obeo.perseus.client.ui.Messages;
import fr.obeo.perseus.client.ui.preferences.PerseusPreferences;
import fr.obeo.perseus.client.ui.preferences.PerseusServerConfig;
import java.util.ArrayList;
import java.util.Objects;
import java.util.stream.Collectors;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class PerseusServerCredentialsDialog
extends Dialog
implements ModifyListener {
    private Text usernameField;
    private Text passwordField;
    private final PerseusServerConfig config;
    private final PerseusPreferences prefs;

    public PerseusServerCredentialsDialog(Shell parentShell, PerseusServerConfig config) {
        super(parentShell);
        this.config = Objects.requireNonNull(config);
        this.prefs = new PerseusPreferences();
    }

    protected Control createContents(Composite parent) {
        Control contents = super.createContents(parent);
        if (this.config.getUsername() != null) {
            this.usernameField.setText(this.config.getUsername());
        }
        return contents;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setImage(newShell.getDisplay().getSystemImage(4));
        newShell.setText(Messages.PerseusServerCredentialsDialog_Title);
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogComp = (Composite)super.createDialogArea(parent);
        Label messageLabel = new Label(dialogComp, 4);
        messageLabel.setText(String.format(Messages.PerseusServerCredentialsDialog_Message, this.config.getUri().toString()));
        Composite formComp = new Composite(dialogComp, 0);
        formComp.setLayout((Layout)new GridLayout(2, false));
        formComp.setLayoutData((Object)new GridData(4, 4, true, true));
        Label usernameLabel = new Label(formComp, 131072);
        usernameLabel.setText(Messages.LblUserName);
        this.usernameField = new Text(formComp, 2052);
        this.usernameField.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.usernameField.addModifyListener((ModifyListener)this);
        Label passwordLabel = new Label(formComp, 131072);
        passwordLabel.setText(Messages.LblPassword);
        this.passwordField = new Text(formComp, 0x400804);
        this.passwordField.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.passwordField.addModifyListener((ModifyListener)this);
        return dialogComp;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        this.getButton(0).setEnabled(false);
    }

    public void modifyText(ModifyEvent e) {
        this.getButton(0).setEnabled(this.usernameField.getText() != null && !this.usernameField.getText().trim().isEmpty() && this.passwordField.getText() != null && !this.passwordField.getText().trim().isEmpty());
    }

    protected void okPressed() {
        this.config.setUsername(this.usernameField.getText());
        this.config.setPassword(this.passwordField.getText());
        ArrayList<PerseusServerConfig> updatedServers = new ArrayList<PerseusServerConfig>(this.prefs.getServerConfigs().stream().filter(conf -> !conf.getUri().equals(this.config.getUri())).collect(Collectors.toList()));
        updatedServers.add(this.config);
        this.prefs.setPerseusServers(updatedServers);
        super.okPressed();
    }

    public static int open(Shell shell, PerseusServerConfig config) {
        return new PerseusServerCredentialsDialog(shell, config).open();
    }
}

