/*
 * Decompiled with CFR 0.152.
 */
package fr.obeo.perseus.client.ui.drop;

import fr.obeo.dsl.traceability.IArtifact;
import fr.obeo.dsl.traceability.LinkDirection;
import fr.obeo.dsl.traceability.LinkType;
import fr.obeo.dsl.traceability.Traceability;
import fr.obeo.dsl.traceability.api.IArtifactDescriptor;
import fr.obeo.dsl.traceability.api.IArtifactRepositoryStrategy;
import fr.obeo.dsl.traceability.api.ITraceabilityStrategy;
import fr.obeo.dsl.traceability.api.UrlMatchingSettings;
import fr.obeo.dsl.traceability.sirius.TraceabilitySiriusPlugin;
import fr.obeo.dsl.traceability.sirius.api.IModelObjectActionTarget;
import fr.obeo.dsl.traceability.sirius.util.TraceabilityUtil;
import fr.obeo.perseus.client.PerseusClientPlugin;
import fr.obeo.perseus.client.api.IModelTranslationScope;
import fr.obeo.perseus.client.api.IPerseusServerConfig;
import fr.obeo.perseus.client.api.PerseusAuthException;
import fr.obeo.perseus.client.api.PerseusServerException;
import fr.obeo.perseus.client.impl.SessionModelDataProvider;
import fr.obeo.perseus.client.impl.SessionModelTranslationScope;
import fr.obeo.perseus.client.impl.commands.CreateArtifactCommand;
import fr.obeo.perseus.client.impl.commands.CreateLinkCommand;
import fr.obeo.perseus.client.impl.graphql.GQLOslcArtifactDescriptor;
import fr.obeo.perseus.client.impl.runnables.QueryOslcArtifactDescriptorsRunnable;
import fr.obeo.perseus.client.ui.Messages;
import fr.obeo.perseus.client.ui.PerseusClientUIPlugin;
import fr.obeo.perseus.client.ui.preferences.PerseusServerConfig;
import fr.obeo.perseus.client.ui.runnables.RetryCredentialsRunnable;
import fr.obeo.perseus.client.ui.util.AuthenticationUtil;
import fr.obeo.perseus.client.ui.util.PerseusConfigSupport;
import fr.obeo.perseus.client.util.ArtifactID;
import fr.obeo.perseus.client.util.ModelURI;
import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.Adapters;
import org.eclipse.emf.common.command.AbstractCommand;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.sirius.business.api.query.DRepresentationQuery;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.DRepresentationDescriptor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class CreateTraceabilityLinkCommandProvider {
    private static final Command NON_EXECUTABLE_CMD = new AbstractCommand(){

        public void redo() {
        }

        public void execute() {
        }
    };
    private final String droppedURL;
    private final IModelObjectActionTarget target;
    private final List<UrlMatchingSettings> urlMatchingSettingsList;
    private final Shell shell;

    public CreateTraceabilityLinkCommandProvider(String droppedURL, IModelObjectActionTarget target, List<UrlMatchingSettings> urlMatchingSettingsList, Shell shell) {
        this.droppedURL = Objects.requireNonNull(droppedURL);
        this.target = Objects.requireNonNull(target);
        this.urlMatchingSettingsList = Objects.requireNonNull(urlMatchingSettingsList);
        this.shell = Objects.requireNonNull(shell);
    }

    public Optional<Command> getCommand() {
        Optional<UrlMatchingSettings> urlMatchingSettings = this.urlMatchingSettingsList.stream().filter(cfg -> cfg.test(this.droppedURL)).findFirst();
        EObject semanticTarget = this.target.getSemanticTarget();
        Optional optSession = this.target.getGraphicalTarget().map(Session::of).orElseGet(() -> Session.of((EObject)this.target.getSemanticTarget()));
        return optSession.flatMap(session -> this.getCommand(urlMatchingSettings, semanticTarget, (Session)session));
    }

    private Optional<Command> getCommand(Optional<UrlMatchingSettings> urlMatchingSettings, EObject semanticTarget, Session session) {
        Command result = null;
        try {
            String oslcRepoURL = urlMatchingSettings.map(cfg -> cfg.getOslcURL()).orElseThrow(() -> new IllegalArgumentException(String.format(Messages.PerseusDropSupport_UnrecognizedRepoURL, this.droppedURL)));
            String artifactURL = (String)urlMatchingSettings.get().getTargetURL(this.droppedURL).orElseThrow(() -> new IllegalArgumentException(String.format(Messages.PerseusDropSupport_UnrecognizedArtifactURL, this.droppedURL)));
            ArtifactID artifactID = ArtifactID.forRepository((String)oslcRepoURL).build(artifactURL);
            SessionModelTranslationScope scope = new SessionModelTranslationScope(session);
            SessionModelDataProvider dataProvider = new SessionModelDataProvider(session, (IModelTranslationScope)scope);
            Optional perseusModelURI = dataProvider.getPerseusModelURI();
            if (perseusModelURI.isPresent()) {
                ModelURI modelURI = (ModelURI)perseusModelURI.get();
                ITraceabilityStrategy traceabilityStrategy = (ITraceabilityStrategy)Adapters.adapt((Object)session, ITraceabilityStrategy.class);
                Optional optTraceability = traceabilityStrategy.findTraceability();
                if (!optTraceability.isPresent()) {
                    MessageDialog.openWarning((Shell)this.shell, (String)Messages.PerseusDropSupport_MissingTraceabilityTitle, (String)Messages.PerseusDropSupport_MissingTraceabilityText);
                    return Optional.empty();
                }
                Traceability traceability = (Traceability)optTraceability.get();
                IArtifactRepositoryStrategy repositoryStrategy = traceabilityStrategy.getRepositoryStrategy(oslcRepoURL);
                if (!repositoryStrategy.findArtifactRepository().isPresent()) {
                    MessageDialog.openWarning((Shell)this.shell, (String)"Missing Artifact Repository?", (String)String.format("There is not Artifact Repository for '%s' in the traceability model.\nPlease use the 'Initialize Traceability' action to add this repository.", oslcRepoURL));
                } else {
                    Optional optArtifact = repositoryStrategy.findArtifact(artifactURL);
                    if (optArtifact.isPresent()) {
                        IArtifact artifact = (IArtifact)optArtifact.get();
                        result = this.getCommandForExistingArtifact(semanticTarget, session, scope, traceability, repositoryStrategy, artifact);
                    } else {
                        result = this.getCommandForNewArtifact(semanticTarget, session, artifactURL, artifactID, modelURI, traceability, repositoryStrategy);
                    }
                }
            }
        }
        catch (IllegalArgumentException e) {
            PerseusClientUIPlugin.getPlugin().logError(String.format(Messages.PerseusDropSupport_DropException, this.droppedURL), e);
        }
        catch (IllegalStateException e) {
            MessageDialog.openError((Shell)this.shell, (String)Messages.PerseusDropSupport_AuthenticationRequiredTitle, (String)Messages.PerseusDropSupport_AuthenticationRequiredMessage);
            PerseusClientUIPlugin.getPlugin().logError(Messages.PerseusDropSupport_AuthenticationRequiredMessage, e);
        }
        return Optional.ofNullable(result);
    }

    private Command getCommandForNewArtifact(EObject semanticTarget, Session session, String artifactURL, ArtifactID artifactID, ModelURI modelURI, Traceability traceability, IArtifactRepositoryStrategy repositoryStrategy) {
        CreateArtifactCommand result = null;
        PerseusConfigSupport configSupport = new PerseusConfigSupport();
        PerseusServerConfig serverConfig = configSupport.getConfigFromModelURI(modelURI);
        Optional<GQLOslcArtifactDescriptor> optOslcArtifactDescriptor = this.fetchArtifactDescriptor(artifactID, modelURI.getProjectId(), Optional.ofNullable(traceability.getConfiguration()).map(IArtifact::getUrl), serverConfig);
        if (optOslcArtifactDescriptor.isPresent()) {
            GQLOslcArtifactDescriptor artifact = optOslcArtifactDescriptor.get();
            result = new CreateArtifactCommand(session.getTransactionalEditingDomain(), repositoryStrategy, (IArtifactDescriptor)artifact);
            Command cmd2 = this.getCreateLinkToNewArtifactIfNeeded(semanticTarget, session, artifactURL, traceability, repositoryStrategy, artifact);
            result = result.chain(cmd2);
            Supplier<EObject> supplier = () -> (EObject)repositoryStrategy.findArtifact(artifact.getArtifactUrl()).get();
            result = this.chainGraphicalCommands((Command)result, session, supplier);
        }
        return result;
    }

    private Command getCommandForExistingArtifact(EObject semanticTarget, Session session, SessionModelTranslationScope scope, Traceability traceability, IArtifactRepositoryStrategy repositoryStrategy, IArtifact artifact) {
        Command result = null;
        if (this.isDRepresentationTarget()) {
            DRepresentationQuery q = new DRepresentationQuery((DRepresentation)this.target.getGraphicalTarget().get(), session);
            DRepresentationDescriptor representationDescriptor = q.getRepresentationDescriptor();
            if (representationDescriptor != null && this.supportsLink((EObject)representationDescriptor)) {
                Set supportedLinkTypes = repositoryStrategy.getSupportedLinkTypes((EObject)representationDescriptor, artifact.getTypes().stream().map(t -> t.getUri()).collect(Collectors.toSet()), LinkDirection.MODEL_TO_ARTIFACT);
                if (supportedLinkTypes.size() != 0) {
                    result = this.buildCreateLinkCommand((EObject)representationDescriptor, session, scope, traceability, repositoryStrategy, artifact, supportedLinkTypes);
                }
            } else {
                Set supportedLinkTypes = repositoryStrategy.getSupportedLinkTypes(semanticTarget, artifact.getTypes().stream().map(t -> t.getUri()).collect(Collectors.toSet()), LinkDirection.MODEL_TO_ARTIFACT);
                result = this.buildCreateLinkCommand(semanticTarget, session, scope, traceability, repositoryStrategy, artifact, supportedLinkTypes);
            }
        } else if (this.supportsLink(semanticTarget)) {
            Set supportedLinkTypes = repositoryStrategy.getSupportedLinkTypes(semanticTarget, artifact.getTypes().stream().map(t -> t.getUri()).collect(Collectors.toSet()), LinkDirection.MODEL_TO_ARTIFACT);
            result = this.buildCreateLinkCommand(semanticTarget, session, scope, traceability, repositoryStrategy, artifact, supportedLinkTypes);
        }
        Supplier<EObject> supplier = () -> artifact;
        result = this.chainGraphicalCommands(result, session, supplier);
        return result;
    }

    private Command getCreateLinkToNewArtifactIfNeeded(EObject semanticTarget, Session session, String artifactURL, Traceability traceability, IArtifactRepositoryStrategy repositoryStrategy, GQLOslcArtifactDescriptor artifact) {
        Command cmd2 = null;
        if (this.isDRepresentationTarget()) {
            Set supportedLinkTypes;
            DRepresentationQuery q = new DRepresentationQuery((DRepresentation)this.target.getGraphicalTarget().get(), session);
            DRepresentationDescriptor representationDescriptor = q.getRepresentationDescriptor();
            if (representationDescriptor != null && (supportedLinkTypes = repositoryStrategy.getSupportedLinkTypes((EObject)representationDescriptor, artifact.getTypeDescriptors().stream().map(td -> td.getURI()).collect(Collectors.toSet()), LinkDirection.MODEL_TO_ARTIFACT)).size() != 0) {
                cmd2 = this.supportsLink((EObject)representationDescriptor) ? this.getCreateLinkToNewArtifactCommand((EObject)representationDescriptor, session, artifactURL, traceability, repositoryStrategy, artifact) : this.getCreateLinkToNewArtifactCommand(semanticTarget, session, artifactURL, traceability, repositoryStrategy, artifact);
            }
        } else if (this.supportsLink(semanticTarget)) {
            cmd2 = this.getCreateLinkToNewArtifactCommand(semanticTarget, session, artifactURL, traceability, repositoryStrategy, artifact);
        }
        return cmd2;
    }

    protected Command getCreateLinkToNewArtifactCommand(EObject semanticTarget, Session session, String artifactURL, Traceability traceability, IArtifactRepositoryStrategy repositoryStrategy, GQLOslcArtifactDescriptor artifact) {
        Set supportedLinkTypes = repositoryStrategy.getSupportedLinkTypes(semanticTarget, artifact.getTypeDescriptors().stream().map(td -> td.getURI()).collect(Collectors.toSet()), LinkDirection.MODEL_TO_ARTIFACT);
        Command cmd2 = TraceabilityUtil.selectLinkType((Traceability)traceability, (Set)supportedLinkTypes, (EObject)semanticTarget, (Shell)this.shell).map(linkType -> new CreateLinkCommand(session.getTransactionalEditingDomain(), repositoryStrategy, artifactURL, linkType, semanticTarget)).orElse(NON_EXECUTABLE_CMD);
        return cmd2;
    }

    protected Command buildCreateLinkCommand(EObject semanticTarget, Session session, SessionModelTranslationScope scope, Traceability traceability, IArtifactRepositoryStrategy repositoryStrategy, IArtifact artifact, Set<LinkType> supportedLinkTypes) {
        return TraceabilityUtil.selectLinkType((Traceability)traceability, supportedLinkTypes, (EObject)semanticTarget, (Shell)this.shell).map(linkType -> this.getCreateLinkCommand(semanticTarget, session, scope, repositoryStrategy, artifact, (LinkType)linkType)).orElse(null);
    }

    protected Command getCreateLinkCommand(EObject semanticTarget, Session session, SessionModelTranslationScope scope, IArtifactRepositoryStrategy repositoryStrategy, IArtifact artifact, LinkType linkType) {
        String objectId = scope.getId(semanticTarget);
        Command result = null;
        if (objectId == null) {
            MessageDialog.openWarning((Shell)PlatformUI.getWorkbench().getDisplay().getActiveShell(), (String)Messages.PerseusDropSupport_UnsupportedTargetTitle, (String)String.format(Messages.PerseusDropSupport_UnsupportedTargetText, semanticTarget.eClass().getName()));
            result = NON_EXECUTABLE_CMD;
        } else if (!repositoryStrategy.findLink(objectId, linkType, artifact, LinkDirection.MODEL_TO_ARTIFACT).isPresent()) {
            result = new CreateLinkCommand(session.getTransactionalEditingDomain(), repositoryStrategy, artifact.getUrl(), linkType, semanticTarget);
        } else {
            String targetLabel = this.getTargetLabel(semanticTarget, objectId);
            String artifactLabel = this.getArtifactLabel(artifact);
            MessageDialog.openWarning((Shell)PlatformUI.getWorkbench().getDisplay().getActiveShell(), (String)Messages.PerseusDropSupport_LinkAlreadyExistsTitle, (String)String.format(Messages.PerseusDropSupport_LinkAlreadyExistsText, linkType.getName(), semanticTarget.eClass().getName(), targetLabel, artifactLabel));
        }
        return result;
    }

    protected String getArtifactLabel(IArtifact artifact) {
        return Optional.ofNullable((AdapterFactoryEditingDomain)AdapterFactoryEditingDomain.getEditingDomainFor((EObject)artifact)).map(editingDomain -> (IItemLabelProvider)editingDomain.getAdapterFactory().adapt((Notifier)artifact, IItemLabelProvider.class)).map(labelProvider -> labelProvider.getText((Object)artifact)).orElse(String.format("%s - %s", artifact.getIdentifier(), artifact.getTitle()));
    }

    protected String getTargetLabel(EObject semanticTarget, String objectId) {
        return Optional.ofNullable((AdapterFactoryEditingDomain)AdapterFactoryEditingDomain.getEditingDomainFor((EObject)semanticTarget)).map(editingDomain -> (IItemLabelProvider)editingDomain.getAdapterFactory().adapt((Notifier)semanticTarget, IItemLabelProvider.class)).map(labelProvider -> labelProvider.getText((Object)semanticTarget)).orElse(objectId);
    }

    protected boolean isDRepresentationTarget() {
        return this.target.getGraphicalTarget().map(DRepresentation.class::isInstance).orElse(false);
    }

    private Command chainGraphicalCommands(Command cmd, Session session, Supplier<EObject> supplier) {
        return TraceabilitySiriusPlugin.getPlugin().getDropArtifactCommandContribution(this.target, session, supplier).map(contribution -> Optional.ofNullable(cmd).map(c -> c.chain(contribution)).orElse((Command)contribution)).orElse(cmd);
    }

    protected Optional<GQLOslcArtifactDescriptor> fetchArtifactDescriptor(ArtifactID artifactID, String projectId, Optional<String> optConfigUri, PerseusServerConfig serverConfig) {
        if (serverConfig.getAuthMode() == IPerseusServerConfig.AuthMode.OAUTH2 && !PerseusClientPlugin.getPlugin().getPerseusServerCredentialProvider().hasValidCredentials((IPerseusServerConfig)serverConfig)) {
            throw new IllegalStateException();
        }
        QueryOslcArtifactDescriptorsRunnable queryArtifacts = new QueryOslcArtifactDescriptorsRunnable((IPerseusServerConfig)serverConfig, projectId, optConfigUri, Collections.singletonList(artifactID));
        RetryCredentialsRunnable runnable = new RetryCredentialsRunnable((IRunnableWithProgress)queryArtifacts, this.shell);
        try {
            new ProgressMonitorDialog(this.shell).run(true, true, (IRunnableWithProgress)runnable);
        }
        catch (InvocationTargetException e) {
            Throwable t = Optional.ofNullable(e.getCause()).orElse(e);
            PerseusClientUIPlugin.getPlugin().logError(String.format(Messages.PerseusDropSupport_FetchFailed, artifactID, t.getMessage()), t);
            if (t instanceof PerseusAuthException) {
                PerseusAuthException tokExc = (PerseusAuthException)t;
                AuthenticationUtil.takeUserToAuthenticationPage(tokExc, String.format(Messages.PerseusDropSupport_OAuthRequiredOpName, artifactID), this.shell);
            } else if (t instanceof PerseusServerException) {
                MessageDialog.openError((Shell)this.shell, (String)Messages.PerseusDropSupport_FetchFailedTitle, (String)t.getMessage());
            } else {
                MessageDialog.openError((Shell)this.shell, (String)Messages.PerseusDropSupport_FetchFailedTitle, (String)String.format(Messages.PerseusDropSupport_FetchFailedText, artifactID));
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return queryArtifacts.getArtifactDescriptors().stream().findFirst();
    }

    private boolean supportsLink(EObject o) {
        Optional optSession;
        if (!"http://www.obeo.fr/dsl/traceability".equals(o.eClass().getEPackage().getNsURI()) && (optSession = Session.of((EObject)o)).isPresent()) {
            Session session = (Session)optSession.get();
            SessionModelTranslationScope scope = new SessionModelTranslationScope(session);
            return scope.getId(o) != null;
        }
        return false;
    }
}

