/*
 * Decompiled with CFR 0.152.
 */
package fr.obeo.perseus.client.ui.drop;

import fr.obeo.dsl.traceability.api.ITraceabilityStrategy;
import fr.obeo.dsl.traceability.api.UrlMatchingSettings;
import fr.obeo.dsl.traceability.sirius.TraceabilitySiriusPlugin;
import fr.obeo.dsl.traceability.sirius.api.IModelObjectActionTarget;
import fr.obeo.dsl.traceability.sirius.api.ModelObjectActionTarget;
import fr.obeo.perseus.client.ui.Messages;
import fr.obeo.perseus.client.ui.drop.CreateTraceabilityLinkCommandProvider;
import fr.obeo.sirius.texttransfer.drop.support.drop.AbstractTextTransferDropSupport;
import fr.obeo.sirius.texttransfer.drop.support.drop.EMFCommandProvider;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.Adapters;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.ui.tools.api.views.common.item.ItemWrapper;
import org.eclipse.sirius.viewpoint.DRepresentationDescriptor;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.HTMLTransfer;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.Widget;

public class PerseusDropSupport
extends AbstractTextTransferDropSupport
implements EMFCommandProvider {
    List<UrlMatchingSettings> urlMatchingSettingsList;

    public boolean canHandle(DropTargetEvent event) {
        this.urlMatchingSettingsList = this.getAllUrlMatchingSettings(event);
        return this.urlMatchingSettingsList.stream().anyMatch(cfg -> cfg.test(this.getUrl(event)));
    }

    private List<UrlMatchingSettings> getAllUrlMatchingSettings(DropTargetEvent event) {
        return this.getResolvedDropTarget(event).flatMap(target -> Session.of((EObject)target.getSemanticTarget())).flatMap(this::getTraceabilityStrategy).map(ITraceabilityStrategy::findAllUrlMatchingSettings).orElseGet(Collections::emptyList);
    }

    private Optional<ITraceabilityStrategy> getTraceabilityStrategy(Session session) {
        return Optional.ofNullable((ITraceabilityStrategy)Adapters.adapt((Object)session, ITraceabilityStrategy.class, (boolean)true));
    }

    private String getUrl(DropTargetEvent event) {
        String droppedData = (String)event.data;
        if (!TextTransfer.getInstance().isSupportedType(event.currentDataType) && HTMLTransfer.getInstance().isSupportedType(event.currentDataType)) {
            droppedData = this.extractUrl((String)event.data);
        }
        return droppedData;
    }

    private String extractUrl(String htmlData) {
        List<UrlMatchingSettings> urlConfigs = this.urlMatchingSettingsList;
        for (UrlMatchingSettings config : urlConfigs) {
            for (UrlMatchingSettings.PatternAndReplacement pattern : config.getPatterns()) {
                Pattern pat = pattern.getPattern();
                Matcher matcher = pat.matcher(htmlData);
                if (!matcher.find()) continue;
                return matcher.group();
            }
        }
        return htmlData;
    }

    public void execute(DropTargetEvent event) {
        EObject target = this.getTargetEObject(event).get();
        Session session = (Session)Session.of((EObject)target).get();
        this.getCommand(event).filter(Command::canExecute).ifPresent(cmd -> {
            session.getTransactionalEditingDomain().getCommandStack().execute(cmd);
            if (event.getSource() instanceof DropTarget && ((DropTarget)event.getSource()).getControl() instanceof Tree) {
                MessageDialog.openInformation((Shell)Display.getCurrent().getActiveShell(), (String)Messages.PerseusDropSupport_SuccessTitle, (String)Messages.PerseusDropSupport_SuccessText);
            }
        });
    }

    protected boolean isSupportedSemanticElement(EObject target) {
        return true;
    }

    public Optional<Command> getCommand(DropTargetEvent event) {
        String droppedURL = this.getUrl(event);
        IModelObjectActionTarget target = this.getResolvedDropTarget(event).orElse(null);
        if (target == null) {
            return Optional.empty();
        }
        Shell shell = this.getShell(event);
        return new CreateTraceabilityLinkCommandProvider(droppedURL, target, this.urlMatchingSettingsList, shell).getCommand();
    }

    protected Shell getShell(DropTargetEvent event) {
        Shell shell = null;
        Widget w = event.widget;
        if (w instanceof DropTarget) {
            shell = ((DropTarget)w).getControl().getShell();
        } else if (w instanceof Shell) {
            shell = (Shell)w;
        } else if (w instanceof Control) {
            shell = ((Control)w).getShell();
        } else {
            Shell[] shellArray = event.display.getShells();
            int n = shellArray.length;
            int n2 = 0;
            while (n2 < n) {
                Shell s = shellArray[n2];
                if (s.getBounds().contains(event.x, event.y)) {
                    shell = s;
                    break;
                }
                ++n2;
            }
        }
        shell = Optional.ofNullable(shell).orElseGet(() -> Optional.ofNullable(dropTargetEvent.display.getActiveShell()).orElseGet(() -> Optional.of(Display.getCurrent()).orElse(Display.getDefault()).getActiveShell()));
        return shell;
    }

    protected Optional<EObject> resolveSemanticTarget(Object o) {
        return super.resolveSemanticTarget(o).map(arg_0 -> ((TraceabilitySiriusPlugin.Implementation)TraceabilitySiriusPlugin.getPlugin()).adaptSelection(arg_0));
    }

    public Optional<EObject> getTargetEObject(DropTargetEvent event) {
        Optional<DRepresentationDescriptor> target = super.getTargetEObject(event);
        if (!target.isPresent() && event.item != null && event.item.getData() instanceof ItemWrapper && ((ItemWrapper)event.item.getData()).getWrappedObject() instanceof DRepresentationDescriptor) {
            target = Optional.of((DRepresentationDescriptor)((ItemWrapper)event.item.getData()).getWrappedObject());
        }
        return target;
    }

    private Optional<IModelObjectActionTarget> getResolvedDropTarget(DropTargetEvent event) {
        EObject target = this.getTargetEObject(event).get();
        DSemanticDecorator graphicalTarget = null;
        if (target instanceof DSemanticDecorator) {
            graphicalTarget = (DSemanticDecorator)target;
            target = this.resolveSemanticTarget(graphicalTarget).orElse(target);
        }
        if (target != null) {
            return Optional.of(new ModelObjectActionTarget(target, graphicalTarget));
        }
        return Optional.empty();
    }
}

