/*
 * Decompiled with CFR 0.152.
 */
package fr.obeo.perseus.client.ui.handlers;

import fr.obeo.perseus.client.PerseusClientPlugin;
import fr.obeo.perseus.client.api.ISessionSupport;
import fr.obeo.perseus.client.util.PerseusEObjectUtil;
import java.util.Optional;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.Adapters;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.sirius.business.api.session.Session;

public abstract class AbstractPerseusHandler
extends AbstractHandler {
    private final ISessionSupport sessionSupport;

    public AbstractPerseusHandler() {
        this(PerseusClientPlugin.getPlugin().getSessionSupport());
    }

    public AbstractPerseusHandler(ISessionSupport sessionSupport) {
        this.sessionSupport = sessionSupport;
    }

    public Optional<Session> findSession(ISelection selection) {
        Optional<Object> result = Optional.empty();
        if (selection instanceof StructuredSelection && !selection.isEmpty()) {
            Object element = ((StructuredSelection)selection).getFirstElement();
            Session adapter = (Session)Adapters.adapt((Object)element, Session.class);
            if (adapter != null) {
                result = Optional.of(adapter);
            } else {
                IFile iFile = (IFile)Adapters.adapt((Object)element, IFile.class);
                result = Optional.ofNullable(iFile).flatMap(arg_0 -> ((ISessionSupport)this.sessionSupport).findOpenSession(arg_0));
                if (!result.isPresent()) {
                    result = PerseusEObjectUtil.getTargetEObject((Object)element).flatMap(o -> Session.of((EObject)o));
                }
            }
        }
        return result;
    }
}

