/*
 * Decompiled with CFR 0.152.
 */
package fr.obeo.perseus.client.ui.handlers;

import fr.obeo.dsl.traceability.ArtifactRepository;
import fr.obeo.perseus.client.PerseusClientPlugin;
import fr.obeo.perseus.client.api.IModelTranslationScope;
import fr.obeo.perseus.client.api.ISessionSupport;
import fr.obeo.perseus.client.api.PerseusCredentialsException;
import fr.obeo.perseus.client.impl.SessionModelDataProvider;
import fr.obeo.perseus.client.impl.SessionModelTranslationScope;
import fr.obeo.perseus.client.impl.graphql.GQLOAuthFriend;
import fr.obeo.perseus.client.ui.Messages;
import fr.obeo.perseus.client.ui.PerseusClientUIPlugin;
import fr.obeo.perseus.client.ui.dialogs.PerseusServerCredentialsDialog;
import fr.obeo.perseus.client.ui.handlers.AbstractPerseusHandler;
import fr.obeo.perseus.client.ui.initializer.ArtifactRepositoryInitializer;
import fr.obeo.perseus.client.ui.preferences.PerseusServerConfig;
import fr.obeo.perseus.client.ui.runnables.QueryOAuthFriendRunnable;
import fr.obeo.perseus.client.ui.util.PerseusConfigSupport;
import fr.obeo.perseus.client.util.ModelURI;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.handlers.HandlerUtil;

public class AddDefaultUrlPatternsHandler
extends AbstractPerseusHandler {
    public AddDefaultUrlPatternsHandler() {
    }

    public AddDefaultUrlPatternsHandler(ISessionSupport sessionSupport) {
        super(sessionSupport);
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        Shell shell = HandlerUtil.getActiveShell((ExecutionEvent)event);
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        this.findSession(selection).ifPresent(session -> {
            block7: {
                IStructuredSelection sel = (IStructuredSelection)selection;
                final ArtifactRepository repo = (ArtifactRepository)sel.getFirstElement();
                SessionModelTranslationScope scope = new SessionModelTranslationScope(session);
                SessionModelDataProvider modelDataProvider = new SessionModelDataProvider(session, (IModelTranslationScope)scope);
                int nbRetry = 0;
                boolean retry = true;
                try {
                    Optional<GQLOAuthFriend> optFriend = Optional.ofNullable(this.fetchFriend(shell, (ModelURI)modelDataProvider.getPerseusModelURI().get(), repo));
                    if (optFriend.isPresent()) {
                        final ArrayList urlPatterns = new ArrayList();
                        ArtifactRepositoryInitializer.URL_PATTERN_INITIALIZERS.forEach(provider -> {
                            boolean bl = urlPatterns.addAll(provider.getDefaultUrlPatterns((GQLOAuthFriend)optFriend.get()));
                        });
                        if (!urlPatterns.isEmpty()) {
                            TransactionalEditingDomain ted = session.getTransactionalEditingDomain();
                            ted.getCommandStack().execute((Command)new RecordingCommand(ted){

                                protected void doExecute() {
                                    repo.getUrlPatterns().addAll((Collection)urlPatterns);
                                }
                            });
                        } else {
                            MessageDialog.openInformation((Shell)shell, (String)Messages.AddDefaultUrlPatterns_FailedTitle, (String)Messages.AddDefaultUrlPatterns_NoProviders);
                        }
                    } else {
                        PerseusClientUIPlugin.getPlugin().logError(Messages.AddDefaultUrlPatterns_NoFriend);
                        MessageDialog.openError((Shell)shell, (String)Messages.AddDefaultUrlPatterns_FailedTitle, (String)Messages.AddDefaultUrlPatterns_NoFriend);
                    }
                }
                catch (PerseusCredentialsException e) {
                    if (!(e.getPerseusServerConfig() instanceof PerseusServerConfig)) break block7;
                    boolean bl = retry = nbRetry++ < 2;
                    if (retry) {
                        boolean bl2 = retry = PerseusServerCredentialsDialog.open(shell, (PerseusServerConfig)e.getPerseusServerConfig()) == 0;
                    }
                    if (retry) break block7;
                    PerseusClientUIPlugin.getPlugin().logError(String.format(Messages.AddDefaultUrlPatterns_FailedTitle, e.getMessage()), e);
                    MessageDialog.openError((Shell)shell, (String)Messages.AddDefaultUrlPatterns_Credentials, (String)e.getMessage());
                }
            }
        });
        return null;
    }

    private GQLOAuthFriend fetchFriend(Shell shell, ModelURI modelURI, ArtifactRepository repo) throws PerseusCredentialsException {
        PerseusConfigSupport configSupport = new PerseusConfigSupport();
        QueryOAuthFriendRunnable queryOAuthFriend = new QueryOAuthFriendRunnable(modelURI, PerseusClientPlugin.getPlugin().getOslcDataFetcher(), configSupport, repo.getUrl());
        GQLOAuthFriend result = null;
        try {
            new ProgressMonitorDialog(shell).run(true, true, (IRunnableWithProgress)queryOAuthFriend);
            result = queryOAuthFriend.getOAuthFriend();
        }
        catch (InterruptedException interruptedException) {
        }
        catch (RuntimeException | InvocationTargetException e) {
            Throwable t = Optional.ofNullable(e.getCause()).orElse(e);
            if (t instanceof PerseusCredentialsException) {
                throw (PerseusCredentialsException)t;
            }
            PerseusClientUIPlugin.getPlugin().logError("Fetch friends failed: " + t.getMessage(), t);
        }
        return result;
    }
}

