/*
 * Decompiled with CFR 0.152.
 */
package fr.obeo.perseus.client.ui.handlers;

import fr.obeo.dsl.traceability.Traceability;
import fr.obeo.dsl.traceability.initializer.TraceabilityConfigurationCopier;
import fr.obeo.perseus.client.ui.PerseusClientUIPlugin;
import fr.obeo.perseus.client.ui.handlers.AbstractPerseusHandler;
import java.io.IOException;
import java.util.Collections;
import java.util.Optional;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.SaveAsDialog;
import org.eclipse.ui.handlers.HandlerUtil;

public class ExportTraceabilitySettingsHandler
extends AbstractPerseusHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        Shell shell = HandlerUtil.getActiveShell((ExecutionEvent)event);
        StructuredSelection currentSelection = StructuredSelection.EMPTY;
        if (HandlerUtil.getCurrentSelection((ExecutionEvent)event) instanceof IStructuredSelection && (currentSelection = (IStructuredSelection)HandlerUtil.getCurrentSelection((ExecutionEvent)event)).size() == 1 && currentSelection.getFirstElement() instanceof IFile) {
            IFile fileToExport = (IFile)currentSelection.getFirstElement();
            SaveAsDialog dlg = new SaveAsDialog(shell);
            dlg.setBlockOnOpen(true);
            dlg.setOriginalName("sharedConfig.traceability");
            dlg.setTitle("Export Traceability Settings as...");
            if (dlg.open() == 0) {
                Optional.ofNullable(dlg.getResult()).ifPresent(targetPath -> this.exportTraceability(fileToExport, (IPath)targetPath, shell));
            }
        }
        return null;
    }

    private void exportTraceability(IFile fileToExport, IPath targetPath, Shell shell) {
        Resource targetRes;
        Traceability sourceTraceability = this.loadConfigurationFile(fileToExport);
        IFile targetFile = ResourcesPlugin.getWorkspace().getRoot().getFile(targetPath);
        TraceabilityConfigurationCopier copier = new TraceabilityConfigurationCopier();
        copier.copy((EObject)sourceTraceability);
        copier.copyReferences();
        ResourceSetImpl targetResourceSet = new ResourceSetImpl();
        if (targetFile.exists()) {
            targetRes = targetResourceSet.getResource(URI.createPlatformResourceURI((String)targetPath.toString(), (boolean)true), true);
            targetRes.getContents().clear();
        } else {
            targetRes = targetResourceSet.createResource(URI.createPlatformResourceURI((String)targetPath.toString(), (boolean)true));
        }
        targetRes.getContents().add((Object)((EObject)copier.get((Object)sourceTraceability)));
        try {
            targetRes.save(Collections.emptyMap());
        }
        catch (IOException e) {
            PerseusClientUIPlugin.getPlugin().logError("Failed to Export Traceability Settings", e);
            MessageDialog.openError((Shell)shell, (String)"Export Traceability Settings Failed", (String)("An exception occurred, see the logs for more details: " + e.getMessage()));
        }
    }

    private Traceability loadConfigurationFile(IFile cfgFile) {
        ResourceSetImpl rs = new ResourceSetImpl();
        Resource resource = rs.getResource(URI.createPlatformResourceURI((String)cfgFile.getFullPath().toString(), (boolean)false), true);
        return (Traceability)resource.getContents().get(0);
    }
}

