/*
 * Decompiled with CFR 0.152.
 */
package fr.obeo.perseus.client.ui.handlers;

import fr.obeo.dsl.traceability.api.IArtifactRepositoryChangeSet;
import fr.obeo.dsl.traceability.api.ITraceabilityStrategy;
import fr.obeo.perseus.client.PerseusClientPlugin;
import fr.obeo.perseus.client.api.IModelDataProvider;
import fr.obeo.perseus.client.api.IModelTranslationScope;
import fr.obeo.perseus.client.api.IPerseusConfigSupport;
import fr.obeo.perseus.client.api.ISessionSupport;
import fr.obeo.perseus.client.api.PerseusCredentialsException;
import fr.obeo.perseus.client.impl.SessionModelDataProvider;
import fr.obeo.perseus.client.impl.SessionModelTranslationScope;
import fr.obeo.perseus.client.impl.commands.FixRepresentationLinksCommand;
import fr.obeo.perseus.client.ui.Messages;
import fr.obeo.perseus.client.ui.PerseusClientUIPlugin;
import fr.obeo.perseus.client.ui.dialogs.PerseusServerCredentialsDialog;
import fr.obeo.perseus.client.ui.handlers.AbstractPerseusHandler;
import fr.obeo.perseus.client.ui.preferences.PerseusServerConfig;
import fr.obeo.perseus.client.ui.runnables.EnsureModelConfigurationUriRunnable;
import fr.obeo.perseus.client.ui.runnables.QueryOslcLinksRunnable;
import fr.obeo.perseus.client.ui.util.PerseusConfigSupport;
import fr.obeo.perseus.client.ui.wizards.FetchWizard;
import fr.obeo.perseus.client.util.ModelURI;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.Optional;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.Adapters;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.handlers.HandlerUtil;

public class FetchHandler
extends AbstractPerseusHandler {
    private static final int LINK_DESCRIPTION_MESSAGE_LIMIT = 5;

    public FetchHandler() {
    }

    public FetchHandler(ISessionSupport sessionSupport) {
        super(sessionSupport);
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        SessionModelTranslationScope scope;
        Session session;
        SessionModelDataProvider modelDataProvider;
        Optional perseusModelURI;
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        Shell shell = HandlerUtil.getActiveShellChecked((ExecutionEvent)event);
        Optional<Session> optSession = this.findSession(selection);
        if (optSession.isPresent() && (perseusModelURI = (modelDataProvider = new SessionModelDataProvider(session = optSession.get(), (IModelTranslationScope)(scope = new SessionModelTranslationScope(session)))).getPerseusModelURI()).isPresent()) {
            ModelURI modelURI = (ModelURI)perseusModelURI.get();
            ITraceabilityStrategy traceabilityStrategy = (ITraceabilityStrategy)Adapters.adapt((Object)session, ITraceabilityStrategy.class);
            PerseusConfigSupport configSupport = new PerseusConfigSupport();
            int nbRetry = 0;
            boolean retry = true;
            while (retry) {
                try {
                    retry = false;
                    this.doFetch(shell, session, (IModelDataProvider)modelDataProvider, modelURI, traceabilityStrategy, configSupport);
                }
                catch (PerseusCredentialsException e) {
                    if (!(e.getPerseusServerConfig() instanceof PerseusServerConfig)) continue;
                    boolean bl = retry = nbRetry++ < 2;
                    if (retry) {
                        boolean bl2 = retry = PerseusServerCredentialsDialog.open(shell, (PerseusServerConfig)e.getPerseusServerConfig()) == 0;
                    }
                    if (retry) continue;
                    PerseusClientUIPlugin.getPlugin().logError(String.format(Messages.PerseusServerCredentialsInvalid_Msg, e.getMessage()), e);
                    MessageDialog.openError((Shell)shell, (String)Messages.FetchHandler_FetchFailedTitle, (String)e.getMessage());
                }
                catch (InterruptedException e) {
                }
                catch (Exception e) {
                    Throwable t = Optional.ofNullable(e.getCause()).orElse(e);
                    PerseusClientUIPlugin.getPlugin().logError(String.format(Messages.FetchHandler_FetchFailedText, t.getMessage()), t);
                    MessageDialog.openError((Shell)shell, (String)Messages.FetchHandler_FetchFailedTitle, (String)t.getMessage());
                }
            }
        }
        return null;
    }

    private void doFetch(Shell shell, Session session, IModelDataProvider modelDataProvider, ModelURI modelURI, ITraceabilityStrategy traceabilityStrategy, IPerseusConfigSupport configSupport) throws PerseusCredentialsException, InvocationTargetException, InterruptedException {
        List<? extends IArtifactRepositoryChangeSet> artifactRepositoryChangeSets;
        final EnsureModelConfigurationUriRunnable ensureModelConfig = new EnsureModelConfigurationUriRunnable(modelURI, traceabilityStrategy, modelDataProvider, configSupport, session);
        final QueryOslcLinksRunnable queryOslcLinks = new QueryOslcLinksRunnable(modelURI, traceabilityStrategy, arg_0 -> ((IModelDataProvider)modelDataProvider).findSemanticObjectById(arg_0), PerseusClientPlugin.getPlugin().getOslcDataFetcher(), configSupport);
        try {
            new ProgressMonitorDialog(shell).run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
                    ensureModelConfig.run((IProgressMonitor)progress.split(20));
                    queryOslcLinks.run((IProgressMonitor)progress.split(80));
                }
            });
        }
        catch (InvocationTargetException e) {
            if (e.getCause() instanceof PerseusCredentialsException) {
                throw (PerseusCredentialsException)e.getCause();
            }
            throw e;
        }
        List repositories = traceabilityStrategy.findTraceability().map(t -> t.getRepositories()).orElse(null);
        if (repositories != null && !repositories.isEmpty() && !queryOslcLinks.getUnavailableFriendURLs().isEmpty()) {
            StringBuffer message = new StringBuffer();
            message.append(Messages.FetchHandler_MissingFriendsMsg1);
            repositories.stream().filter(r -> queryOslcLinks.getUnavailableFriendURLs().contains(r.getUrl())).forEach(r -> message.append(String.format(Messages.FetchHandler_MissingFriendsMsg2, r.getName(), r.getUrl())));
            MessageDialog.openWarning((Shell)shell, (String)Messages.FetchHandler_MissingFriendsTitle, (String)message.toString());
        }
        if ((artifactRepositoryChangeSets = queryOslcLinks.getArtifactLinkChangesModels()).stream().anyMatch(changeSet -> !changeSet.getDiffActions().isEmpty())) {
            ComposedAdapterFactory adapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
            FetchWizard wizard = new FetchWizard(traceabilityStrategy, artifactRepositoryChangeSets, modelDataProvider, (AdapterFactory)adapterFactory);
            WizardDialog dlg = new WizardDialog(shell, (IWizard)wizard);
            dlg.open();
        } else {
            MessageDialog.openInformation((Shell)shell, (String)Messages.FetchHandler_NothingToSyncTitle, (String)Messages.FetchHandler_NothingToSyncText);
        }
        FixRepresentationLinksCommand fixCommand = new FixRepresentationLinksCommand(session.getTransactionalEditingDomain(), repositories);
        session.getTransactionalEditingDomain().getCommandStack().execute((Command)fixCommand);
        List fixedLinkDescriptions = fixCommand.getFixedLinkDescriptions();
        if (!fixedLinkDescriptions.isEmpty()) {
            StringBuffer buffer = new StringBuffer();
            fixedLinkDescriptions.stream().limit(5L).forEach(link -> {
                StringBuffer stringBuffer2 = buffer.append(" - " + link + '\n');
            });
            String linkSummary = buffer.toString();
            if (fixedLinkDescriptions.size() > 5) {
                linkSummary = String.valueOf(linkSummary) + String.format(Messages.FetchHandler_FixedRepresentationLinksMore, fixedLinkDescriptions.size() - 5);
            }
            MessageDialog.openInformation((Shell)shell, (String)Messages.FetchHandler_FixedRepresentationLinksTitle, (String)String.format(Messages.FetchHandler_FixedRepresentationLinksText, linkSummary));
        }
    }
}

