/*
 * Decompiled with CFR 0.152.
 */
package fr.obeo.perseus.client.ui.handlers;

import fr.obeo.dsl.traceability.api.ITraceabilityStrategy;
import fr.obeo.perseus.client.PerseusClientPlugin;
import fr.obeo.perseus.client.api.IModelTranslationScope;
import fr.obeo.perseus.client.api.IPerseusServerConfig;
import fr.obeo.perseus.client.api.ISessionSupport;
import fr.obeo.perseus.client.api.PerseusCredentialsException;
import fr.obeo.perseus.client.api.PerseusServerException;
import fr.obeo.perseus.client.impl.SessionModelDataProvider;
import fr.obeo.perseus.client.impl.SessionModelTranslationScope;
import fr.obeo.perseus.client.ui.Messages;
import fr.obeo.perseus.client.ui.PerseusClientUIPlugin;
import fr.obeo.perseus.client.ui.dialogs.PerseusServerCredentialsDialog;
import fr.obeo.perseus.client.ui.handlers.AbstractPerseusHandler;
import fr.obeo.perseus.client.ui.preferences.PerseusServerConfig;
import fr.obeo.perseus.client.ui.util.PerseusConfigSupport;
import fr.obeo.perseus.client.util.ModelURI;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.Optional;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.Adapters;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.handlers.HandlerUtil;

public class FetchPublishResultHandler
extends AbstractPerseusHandler {
    public FetchPublishResultHandler() {
    }

    public FetchPublishResultHandler(ISessionSupport sessionSupport) {
        super(sessionSupport);
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        SessionModelTranslationScope scope;
        Session session;
        SessionModelDataProvider modelDataProvider;
        Optional perseusModelURI;
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        Shell shell = HandlerUtil.getActiveShellChecked((ExecutionEvent)event);
        Optional<Session> optSession = this.findSession(selection);
        if (optSession.isPresent() && (perseusModelURI = (modelDataProvider = new SessionModelDataProvider(session = optSession.get(), (IModelTranslationScope)(scope = new SessionModelTranslationScope(session)))).getPerseusModelURI()).isPresent()) {
            ModelURI modelURI = (ModelURI)perseusModelURI.get();
            ITraceabilityStrategy traceabilityStrategy = (ITraceabilityStrategy)Adapters.adapt((Object)session, ITraceabilityStrategy.class);
            PerseusConfigSupport configSupport = new PerseusConfigSupport();
            int nbRetry = 0;
            boolean retry = true;
            while (retry) {
                try {
                    retry = false;
                    IPerseusServerConfig serverConfig = configSupport.getConfigFromModelURI(modelURI);
                    this.doFetch(shell, session, modelDataProvider.getModelName(), serverConfig, traceabilityStrategy);
                }
                catch (PerseusCredentialsException e) {
                    if (!(e.getPerseusServerConfig() instanceof PerseusServerConfig)) continue;
                    boolean bl = retry = nbRetry++ < 2;
                    if (retry) {
                        boolean bl2 = retry = PerseusServerCredentialsDialog.open(shell, (PerseusServerConfig)e.getPerseusServerConfig()) == 0;
                    }
                    if (retry) continue;
                    PerseusClientUIPlugin.getPlugin().logError(String.format(Messages.PerseusServerCredentialsInvalid_Msg, e.getMessage()), e);
                    MessageDialog.openError((Shell)shell, (String)Messages.FetchHandler_FetchFailedTitle, (String)e.getMessage());
                }
                catch (InterruptedException e) {
                }
                catch (Exception e) {
                    Throwable t = Optional.ofNullable(e.getCause()).orElse(e);
                    PerseusClientUIPlugin.getPlugin().logError(String.format(Messages.FetchHandler_FetchFailedText, t.getMessage()), t);
                    MessageDialog.openError((Shell)shell, (String)Messages.FetchHandler_FetchFailedTitle, (String)t.getMessage());
                }
            }
        }
        return null;
    }

    private void doFetch(Shell shell, Session session, String modelName, IPerseusServerConfig serverConfig, ITraceabilityStrategy traceabilityStrategy) throws IOException, PerseusServerException, InvocationTargetException, InterruptedException {
        String publicationJobId = traceabilityStrategy.findTraceability().map(t -> t.getPendingPublication().getJobId()).orElseThrow(IllegalStateException::new);
        PerseusClientPlugin.getPlugin().getPublicationJobRegistry().trySchedulingPublicationResultJob(session, serverConfig, modelName, publicationJobId, shell);
    }
}

