/*
 * Decompiled with CFR 0.152.
 */
package fr.obeo.perseus.client.ui.handlers;

import fr.obeo.dsl.traceability.Traceability;
import fr.obeo.dsl.traceability.api.ITraceabilityStrategy;
import fr.obeo.dsl.traceability.initializer.InitializerSelector;
import fr.obeo.dsl.traceability.initializer.TraceabilityInitializerContext;
import fr.obeo.dsl.traceability.initializer.TraceabilityInitializerExtensionDescriptor;
import fr.obeo.dsl.traceability.initializer.TraceabilityModelInitializer;
import fr.obeo.dsl.traceability.initializer.api.ITraceabilityInitializer;
import fr.obeo.dsl.traceability.initializer.api.ITraceabilityInitializerContext;
import fr.obeo.perseus.client.PerseusClientPlugin;
import fr.obeo.perseus.client.api.IModelTranslationScope;
import fr.obeo.perseus.client.api.ISessionSupport;
import fr.obeo.perseus.client.api.PerseusCredentialsException;
import fr.obeo.perseus.client.impl.SessionModelDataProvider;
import fr.obeo.perseus.client.impl.SessionModelTranslationScope;
import fr.obeo.perseus.client.impl.graphql.GQLOAuthFriend;
import fr.obeo.perseus.client.ui.Messages;
import fr.obeo.perseus.client.ui.PerseusClientUIPlugin;
import fr.obeo.perseus.client.ui.dialogs.PerseusServerCredentialsDialog;
import fr.obeo.perseus.client.ui.handlers.AbstractPerseusHandler;
import fr.obeo.perseus.client.ui.initializer.ArtifactRepositoryInitializer;
import fr.obeo.perseus.client.ui.preferences.PerseusServerConfig;
import fr.obeo.perseus.client.ui.runnables.QueryOAuthFriendsRunnable;
import fr.obeo.perseus.client.ui.util.PerseusConfigSupport;
import fr.obeo.perseus.client.util.ModelURI;
import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.Adapters;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class InitializeTraceabilityHandler
extends AbstractPerseusHandler {
    private Image artifactRepositoryIcon;

    public InitializeTraceabilityHandler() {
        this(PerseusClientPlugin.getPlugin().getSessionSupport());
    }

    public InitializeTraceabilityHandler(ISessionSupport sessionSupport) {
        super(sessionSupport);
        ImageDescriptor desc = AbstractUIPlugin.imageDescriptorFromPlugin((String)"fr.obeo.perseus.client.ui", (String)"icons/ArtifactRepository.png");
        if (desc != null) {
            this.artifactRepositoryIcon = desc.createImage();
        }
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        Shell shell = HandlerUtil.getActiveShell((ExecutionEvent)event);
        int nbRetry = 0;
        boolean retry = true;
        while (retry) {
            try {
                retry = false;
                this.doInitialize(event, shell);
            }
            catch (CoreException e) {
                MessageDialog.openError((Shell)shell, (String)Messages.InitializeDomainHandler_initializationTaskName, (String)String.format(Messages.InitializeDomainHandler_initializationFailed, e.getMessage()));
            }
            catch (PerseusCredentialsException e) {
                if (!(e.getPerseusServerConfig() instanceof PerseusServerConfig)) continue;
                boolean bl = retry = nbRetry++ < 2;
                if (retry) {
                    boolean bl2 = retry = PerseusServerCredentialsDialog.open(shell, (PerseusServerConfig)e.getPerseusServerConfig()) == 0;
                }
                if (retry) continue;
                PerseusClientUIPlugin.getPlugin().logError(String.format(Messages.InitializeDomainHandler_initializationFailed, e.getMessage()), e);
                MessageDialog.openError((Shell)shell, (String)Messages.InitializeTraceabilityHandler_InitFailedTitle, (String)e.getMessage());
            }
        }
        return null;
    }

    private void doInitialize(ExecutionEvent event, Shell shell) throws CoreException, PerseusCredentialsException {
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        Optional<Session> optSession = this.findSession(selection);
        if (optSession.isPresent()) {
            TraceabilityInitializerContext ctx;
            List initializerSelection;
            Session session = optSession.get();
            Traceability traceability = this.getTraceabilityStrategy(session).flatMap(ITraceabilityStrategy::findTraceability).orElse(null);
            SessionModelTranslationScope scope = new SessionModelTranslationScope(session);
            SessionModelDataProvider modelDataProvider = new SessionModelDataProvider(session, (IModelTranslationScope)scope);
            InitializerSelector initializerSelector = new InitializerSelector();
            if (modelDataProvider.getPerseusModelURI().isPresent()) {
                this.fetchFriends(shell, (ModelURI)modelDataProvider.getPerseusModelURI().get(), traceability).stream().forEach(f -> this.registerInitializerFromFriend((GQLOAuthFriend)f, initializerSelector));
            }
            if (!(initializerSelection = initializerSelector.getInitializerSelection((ITraceabilityInitializerContext)(ctx = new TraceabilityInitializerContext(session, traceability)), shell)).isEmpty()) {
                this.initialize(session, ctx, initializerSelection);
            }
        } else {
            MessageDialog.openError((Shell)shell, (String)Messages.InitializeDomainHandler_initializationTaskName, (String)Messages.InitializeDomainHandler_closedSessionError);
        }
    }

    private List<GQLOAuthFriend> fetchFriends(Shell shell, ModelURI modelURI, Traceability traceability) throws PerseusCredentialsException {
        PerseusConfigSupport configSupport = new PerseusConfigSupport();
        QueryOAuthFriendsRunnable queryOAuthFriends = new QueryOAuthFriendsRunnable(modelURI, PerseusClientPlugin.getPlugin().getOslcDataFetcher(), configSupport);
        List<GQLOAuthFriend> result = Collections.emptyList();
        try {
            new ProgressMonitorDialog(shell).run(true, true, (IRunnableWithProgress)queryOAuthFriends);
            result = queryOAuthFriends.getOAuthFriends();
        }
        catch (InterruptedException interruptedException) {
        }
        catch (RuntimeException | InvocationTargetException e) {
            Throwable t = Optional.ofNullable(e.getCause()).orElse(e);
            if (t instanceof PerseusCredentialsException) {
                throw (PerseusCredentialsException)t;
            }
            PerseusClientUIPlugin.getPlugin().logError("Fetch friends failed: " + t.getMessage(), t);
        }
        return result;
    }

    private void initialize(Session session, TraceabilityInitializerContext ctx, List<TraceabilityInitializerExtensionDescriptor> initializers) {
        this.getTraceabilityStrategy(session).map(strategy -> this.getOrCreateTraceability((ITraceabilityStrategy)strategy, ctx)).ifPresent(traceability -> {
            final TraceabilityModelInitializer traceabilityModelInitializer = new TraceabilityModelInitializer((ITraceabilityInitializerContext)ctx, initializers);
            TransactionalEditingDomain editingDomain = session.getTransactionalEditingDomain();
            editingDomain.getCommandStack().execute((Command)new RecordingCommand(editingDomain){

                protected void doExecute() {
                    traceabilityModelInitializer.run();
                }
            });
        });
    }

    private void registerInitializerFromFriend(GQLOAuthFriend friend, InitializerSelector initializerSelector) {
        initializerSelector.registerInitializer(new TraceabilityInitializerExtensionDescriptor(String.format("Add Repository: '%s'", friend.getName()), String.format("'%s' is a known friend of the Perseus server, but there is no Artifact Repository for it yet.", friend.getName(), friend.getRootServicesURI()), this.artifactRepositoryIcon, (ITraceabilityInitializer)new ArtifactRepositoryInitializer(friend)));
    }

    private Traceability getOrCreateTraceability(ITraceabilityStrategy traceabilityStrategy, TraceabilityInitializerContext ctx) {
        return traceabilityStrategy.findTraceability().orElseGet(() -> this.createTraceability(traceabilityStrategy, ctx));
    }

    private Traceability createTraceability(ITraceabilityStrategy traceabilityStrategy, TraceabilityInitializerContext ctx) {
        InitializeTraceabilityModelJob initializeModelJob = new InitializeTraceabilityModelJob(traceabilityStrategy);
        initializeModelJob.schedule();
        try {
            initializeModelJob.join();
            Traceability result = initializeModelJob.getTraceability();
            ctx.setTraceability(result);
            return result;
        }
        catch (InterruptedException e) {
            throw new OperationCanceledException();
        }
    }

    public Optional<ITraceabilityStrategy> getTraceabilityStrategy(Session session) {
        return Optional.ofNullable((ITraceabilityStrategy)Adapters.adapt((Object)session, ITraceabilityStrategy.class, (boolean)true));
    }

    private static final class InitializeTraceabilityModelJob
    extends WorkspaceJob {
        private final ITraceabilityStrategy traceabilityStrategy;
        private Traceability traceability;

        InitializeTraceabilityModelJob(ITraceabilityStrategy traceabilityStrategy) {
            super(Messages.InitializeDomainHandler_initializeTraceabilityModel);
            this.traceabilityStrategy = Objects.requireNonNull(traceabilityStrategy);
        }

        public Traceability getTraceability() {
            return this.traceability;
        }

        public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
            this.traceability = this.traceabilityStrategy.createTraceability(monitor);
            return Status.OK_STATUS;
        }
    }
}

