/*
 * Decompiled with CFR 0.152.
 */
package fr.obeo.perseus.client.ui.handlers;

import fr.obeo.perseus.client.PerseusClientPlugin;
import fr.obeo.perseus.client.api.ISessionSupport;
import fr.obeo.perseus.client.ui.PerseusClientUIPlugin;
import fr.obeo.perseus.client.ui.handlers.AbstractPerseusHandler;
import fr.obeo.perseus.client.ui.wizards.PublishToPerseusWizard;
import java.lang.reflect.InvocationTargetException;
import java.util.Optional;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionStatus;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.handlers.HandlerUtil;

public class PublishToPerseusServerHandler
extends AbstractPerseusHandler {
    public PublishToPerseusServerHandler() {
    }

    public PublishToPerseusServerHandler(ISessionSupport sessionSupport) {
        super(sessionSupport);
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        Optional<Session> optSession = this.findSession(HandlerUtil.getCurrentSelection((ExecutionEvent)event));
        Shell shell = HandlerUtil.getActiveShell((ExecutionEvent)event);
        if (optSession.isPresent()) {
            Session session = optSession.get();
            if (!session.isOpen()) {
                MessageDialog.openError((Shell)shell, (String)"Invalid session", (String)"The selected session must be open to publish.");
            }
            if (PublishToPerseusServerHandler.saveSessionIfUserAgrees(session, shell)) {
                WizardDialog dlg = new WizardDialog(HandlerUtil.getActiveShell((ExecutionEvent)event), (IWizard)new PublishToPerseusWizard(session, PerseusClientPlugin.getPlugin().getPerseusDataFetcher(), PerseusClientPlugin.getPlugin().getPublicationJobRegistry()));
                dlg.open();
            }
        }
        return null;
    }

    public static boolean saveSessionIfUserAgrees(final Session session, Shell shell) {
        boolean result = false;
        if (session.getStatus() == SessionStatus.SYNC) {
            result = true;
        } else if (MessageDialog.openConfirm((Shell)shell, (String)"Session is dirty", (String)"The session must be saved before publishing. Click on OK to save the session and proceed.")) {
            try {
                new ProgressMonitorDialog(shell).run(true, true, new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        session.save(monitor);
                    }
                });
                result = true;
            }
            catch (InterruptedException interruptedException) {
            }
            catch (InvocationTargetException e) {
                Throwable t = e.getCause();
                PerseusClientUIPlugin.getPlugin().logError("Save session failed: " + t.getMessage(), t);
                MessageDialog.openError((Shell)shell, (String)"Save session failed", (String)t.getMessage());
            }
        }
        return result;
    }
}

