/*
 * Decompiled with CFR 0.152.
 */
package fr.obeo.perseus.client.ui.handlers;

import fr.obeo.dsl.traceability.IArtifact;
import fr.obeo.dsl.traceability.sirius.api.IModelObjectActionTarget;
import fr.obeo.perseus.client.api.IModelTranslationScope;
import fr.obeo.perseus.client.api.ISessionSupport;
import fr.obeo.perseus.client.impl.SessionModelDataProvider;
import fr.obeo.perseus.client.impl.SessionModelTranslationScope;
import fr.obeo.perseus.client.ui.handlers.AbstractPerseusHandler;
import fr.obeo.perseus.client.util.ModelURI;
import fr.obeo.perseus.client.util.PerseusEObjectUtil;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Optional;
import org.apache.http.client.utils.URIBuilder;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;

public class ShowOnlineHandler
extends AbstractPerseusHandler {
    private static final String SHOW_ONLINE = "Show Online";
    private static final String OPEN_FAILED = "Could not open browser on %s";

    public ShowOnlineHandler() {
    }

    public ShowOnlineHandler(ISessionSupport sessionSupport) {
        super(sessionSupport);
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        Optional<Session> optSession = this.findSession(selection);
        if (optSession.isPresent()) {
            Session session = optSession.get();
            SessionModelTranslationScope scope = new SessionModelTranslationScope(session);
            SessionModelDataProvider dataProvider = new SessionModelDataProvider(session, (IModelTranslationScope)scope);
            Optional perseusModelURI = dataProvider.getPerseusModelURI();
            Object element = ((StructuredSelection)selection).getFirstElement();
            Optional optTarget = PerseusEObjectUtil.getTarget((Object)element);
            if (!optTarget.isPresent()) {
                MessageDialog.openWarning((Shell)HandlerUtil.getActiveShell((ExecutionEvent)event), (String)SHOW_ONLINE, (String)"This element cannot be shown online.");
            } else {
                IModelObjectActionTarget target = (IModelObjectActionTarget)optTarget.get();
                EObject eObject = target.getSemanticTarget();
                if (scope.isInModel(eObject)) {
                    if (perseusModelURI.isPresent()) {
                        ModelURI modelURI = (ModelURI)perseusModelURI.get();
                        try {
                            String objectID = scope.getId(eObject);
                            URL url = modelURI.getObjectSourceURL(objectID);
                            PlatformUI.getWorkbench().getBrowserSupport().getExternalBrowser().openURL(url);
                        }
                        catch (MalformedURLException | PartInitException e) {
                            throw new ExecutionException(String.format(OPEN_FAILED, modelURI), e);
                        }
                    } else {
                        MessageDialog.openWarning((Shell)HandlerUtil.getActiveShell((ExecutionEvent)event), (String)SHOW_ONLINE, (String)"This model is not connected to any Publication server.");
                    }
                } else if (eObject instanceof IArtifact) {
                    IArtifact artifact = (IArtifact)eObject;
                    String artifactUrl = Optional.ofNullable(artifact.getSourceURL()).orElseGet(() -> artifact.getUrl());
                    try {
                        URL url = new URL(artifactUrl);
                        Optional<String> optConfigUri = dataProvider.getPerseusModelConfiguration().map(IArtifact::getUrl);
                        if (optConfigUri.isPresent()) {
                            url = new URIBuilder(url.toURI()).addParameter("oslc_config.context", optConfigUri.get()).build().toURL();
                        }
                        PlatformUI.getWorkbench().getBrowserSupport().getExternalBrowser().openURL(url);
                    }
                    catch (MalformedURLException | URISyntaxException | PartInitException e) {
                        throw new ExecutionException(String.format(OPEN_FAILED, artifactUrl), e);
                    }
                } else if (perseusModelURI.isPresent()) {
                    ModelURI modelURI = (ModelURI)perseusModelURI.get();
                    try {
                        URL url = modelURI.toURL();
                        PlatformUI.getWorkbench().getBrowserSupport().getExternalBrowser().openURL(url);
                    }
                    catch (MalformedURLException | PartInitException e) {
                        throw new ExecutionException(String.format(OPEN_FAILED, modelURI), e);
                    }
                } else {
                    MessageDialog.openWarning((Shell)HandlerUtil.getActiveShell((ExecutionEvent)event), (String)SHOW_ONLINE, (String)"This element cannot be shown online.");
                }
            }
        }
        return null;
    }
}

