/*
 * Decompiled with CFR 0.152.
 */
package fr.obeo.perseus.client.ui.handlers;

import fr.obeo.dsl.traceability.IArtifact;
import fr.obeo.dsl.traceability.Traceability;
import fr.obeo.dsl.traceability.api.ITraceabilityStrategy;
import fr.obeo.dsl.traceability.sirius.util.TraceabilityUtil;
import fr.obeo.perseus.client.api.IModelTranslationScope;
import fr.obeo.perseus.client.api.ISessionSupport;
import fr.obeo.perseus.client.api.PerseusAuthException;
import fr.obeo.perseus.client.impl.SessionModelDataProvider;
import fr.obeo.perseus.client.impl.SessionModelTranslationScope;
import fr.obeo.perseus.client.impl.graphql.GQLOslcArtifactDescriptor;
import fr.obeo.perseus.client.impl.runnables.MutationRefreshOslcArtifactsRunnable;
import fr.obeo.perseus.client.ui.PerseusClientUIPlugin;
import fr.obeo.perseus.client.ui.handlers.AbstractPerseusHandler;
import fr.obeo.perseus.client.ui.runnables.RetryCredentialsRunnable;
import fr.obeo.perseus.client.ui.util.AuthenticationUtil;
import fr.obeo.perseus.client.ui.util.PerseusConfigSupport;
import fr.obeo.perseus.client.util.ModelURI;
import fr.obeo.perseus.client.util.PerseusEObjectUtil;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.handlers.HandlerUtil;

public class UpdateArtifactsHandler
extends AbstractPerseusHandler {
    public UpdateArtifactsHandler() {
    }

    public UpdateArtifactsHandler(ISessionSupport sessionSupport) {
        super(sessionSupport);
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        Shell shell = HandlerUtil.getActiveShellChecked((ExecutionEvent)event);
        this.findSession(selection).ifPresent(session -> {
            SessionModelTranslationScope scope = new SessionModelTranslationScope(session);
            SessionModelDataProvider dataProvider = new SessionModelDataProvider(session, (IModelTranslationScope)scope);
            dataProvider.getPerseusModelURI().ifPresent(perseusModelURI -> {
                HashSet<IArtifact> artifacts = new HashSet<IArtifact>();
                for (Object selected : ((IStructuredSelection)selection).toList()) {
                    PerseusEObjectUtil.getTargetEObject(selected).ifPresent(t -> {
                        if (t instanceof IArtifact) {
                            artifacts.add((IArtifact)t);
                        }
                        TreeIterator it = t.eAllContents();
                        while (it.hasNext()) {
                            EObject next = (EObject)it.next();
                            if (!(next instanceof IArtifact)) continue;
                            artifacts.add((IArtifact)next);
                        }
                    });
                }
                this.updateArtifacts((Session)session, (ModelURI)perseusModelURI, (Set<IArtifact>)artifacts, shell);
            });
        });
        return null;
    }

    private void updateArtifacts(Session session, ModelURI perseusModelURI, Set<IArtifact> artifacts, Shell shell) {
        if (artifacts.isEmpty()) {
            return;
        }
        ArrayList<IArtifact> validArtifacts = new ArrayList<IArtifact>();
        ArrayList<IArtifact> invalidArtifacts = new ArrayList<IArtifact>();
        for (IArtifact artifact2 : artifacts) {
            if (artifact2.getUrl() == null) {
                invalidArtifacts.add(artifact2);
                continue;
            }
            validArtifacts.add(artifact2);
        }
        if (validArtifacts.isEmpty()) {
            return;
        }
        Optional<String> optConfigurationUri = TraceabilityUtil.getTraceabilityStrategy((EObject)((EObject)validArtifacts.get(0))).flatMap(ITraceabilityStrategy::findTraceability).map(Traceability::getConfiguration).map(IArtifact::getUrl);
        PerseusConfigSupport configSupport = new PerseusConfigSupport();
        MutationRefreshOslcArtifactsRunnable refreshMutation = new MutationRefreshOslcArtifactsRunnable(configSupport.getConfigFromModelURI(perseusModelURI), (Collection)validArtifacts.stream().map(a -> a.getUrl()).collect(Collectors.toList()), perseusModelURI.getProjectId(), optConfigurationUri);
        RetryCredentialsRunnable runnable = new RetryCredentialsRunnable((IRunnableWithProgress)refreshMutation, shell);
        try {
            new ProgressMonitorDialog(shell).run(true, true, (IRunnableWithProgress)runnable);
            List artifactDescriptors = Optional.ofNullable(refreshMutation.getArtifactDescriptors()).orElseGet(Collections::emptyList);
            this.updateLocalModel(session, validArtifacts, artifactDescriptors, shell);
            List<IArtifact> missingArtifacts = validArtifacts.stream().filter(artifact -> artifactDescriptors.stream().noneMatch(artifactDescriptor -> artifact.getUrl().equals(artifactDescriptor.getArtifactUrl()))).collect(Collectors.toList());
            if (!invalidArtifacts.isEmpty() || !missingArtifacts.isEmpty()) {
                StringBuffer sb = new StringBuffer();
                if (!invalidArtifacts.isEmpty()) {
                    sb.append("Some artifacts have no URL and cannot be refreshed:\n");
                    invalidArtifacts.forEach(a -> {
                        StringBuffer stringBuffer2 = sb.append("  artifact title: \"" + a.getTitle() + "\"\n");
                    });
                }
                if (!missingArtifacts.isEmpty()) {
                    sb.append("The server did not retrieve the following artifacts:\n");
                    missingArtifacts.forEach(a -> {
                        StringBuffer stringBuffer2 = sb.append("  " + a.getUrl() + "\n");
                    });
                }
                String message = sb.toString();
                PerseusClientUIPlugin.getPlugin().logError(sb.toString());
                MessageDialog.openError((Shell)shell, (String)"Synchronization incomplete", (String)message);
            }
        }
        catch (InterruptedException artifactDescriptors) {
        }
        catch (RuntimeException | InvocationTargetException e) {
            Throwable t = Optional.ofNullable(e.getCause()).orElse(e);
            PerseusClientUIPlugin.getPlugin().logError("Synchronization failed: " + t.getMessage(), t);
            if (t instanceof PerseusAuthException) {
                AuthenticationUtil.takeUserToAuthenticationPage((PerseusAuthException)t, "Refresh of artifacts", shell);
            }
            MessageDialog.openError((Shell)shell, (String)"Synchronization failed", (String)t.getMessage());
        }
    }

    private void updateLocalModel(Session session, Collection<IArtifact> artifacts, final List<GQLOslcArtifactDescriptor> artifactDescriptors, Shell shell) {
        final Map artifactsPerUrl = artifacts.stream().collect(Collectors.toMap(IArtifact::getUrl, Function.identity()));
        TransactionalEditingDomain ted = session.getTransactionalEditingDomain();
        ted.getCommandStack().execute((Command)new RecordingCommand(ted){

            protected void doExecute() {
                for (GQLOslcArtifactDescriptor artifactDescriptor : artifactDescriptors) {
                    IArtifact artifact = (IArtifact)artifactsPerUrl.get(artifactDescriptor.getArtifactURL());
                    if (artifact == null) continue;
                    artifact.setIdentifier(artifactDescriptor.getId());
                    artifactDescriptor.getSourceURL().ifPresent(url -> artifact.setSourceURL(url));
                    artifact.setTitle(artifactDescriptor.getTitle());
                }
            }
        });
    }
}

