/*
 * Decompiled with CFR 0.152.
 */
package fr.obeo.perseus.client.ui.initializer;

import fr.obeo.dsl.traceability.Domain;
import fr.obeo.dsl.traceability.IIdentified;
import fr.obeo.dsl.traceability.Traceability;
import fr.obeo.dsl.traceability.initializer.api.ITraceabilityInitializer;
import fr.obeo.dsl.traceability.initializer.api.ITraceabilityInitializerContext;
import fr.obeo.perseus.client.impl.traceability.SessionTraceabilityStrategy;
import fr.obeo.perseus.client.ui.PerseusClientUIPlugin;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;

public abstract class AbstractDomainInitializer
implements ITraceabilityInitializer {
    private final String domainNsURI;

    protected AbstractDomainInitializer(String domainNsURI) {
        this.domainNsURI = Objects.requireNonNull(domainNsURI);
    }

    public void accept(ITraceabilityInitializerContext context) {
        if (!context.getTraceability().isPresent()) {
            return;
        }
        Traceability traceability = (Traceability)context.getTraceability().get();
        Optional<Domain> existingDomain = traceability.getDomains().stream().filter(SessionTraceabilityStrategy::isValid).filter(d -> this.domainNsURI.equals(d.getUri())).findFirst();
        if (existingDomain.isPresent()) {
            PerseusClientUIPlugin.getPlugin().getLog().log((IStatus)new Status(2, "fr.obeo.perseus.client.ui", String.format("Ignored domain '%s' because it is already defined.", this.domainNsURI)));
        } else {
            Traceability ref = this.loadDomainsFile();
            ref.getDomains().stream().filter(SessionTraceabilityStrategy::isValid).filter(d -> this.domainNsURI.equals(d.getUri())).findFirst().ifPresent(refDomain -> {
                Domain copy = (Domain)EcoreUtil.copy((EObject)refDomain);
                copy.setId(UUID.randomUUID().toString());
                TreeIterator iterator = copy.eAllContents();
                while (iterator.hasNext()) {
                    EObject o = (EObject)iterator.next();
                    if (!(o instanceof IIdentified)) continue;
                    ((IIdentified)o).setId(UUID.randomUUID().toString());
                }
                traceability.getDomains().add((Object)copy);
            });
        }
    }

    private Traceability loadDomainsFile() {
        ResourceSetImpl rs = new ResourceSetImpl();
        Resource resource = rs.getResource(URI.createPlatformPluginURI((String)"fr.obeo.perseus.client.ui/resources/OSLC_Domains.traceability", (boolean)false), true);
        return (Traceability)resource.getContents().get(0);
    }

    public boolean test(ITraceabilityInitializerContext context) {
        Optional traceability = context.getTraceability();
        return !traceability.isPresent() || ((Traceability)traceability.get()).getDomains().stream().noneMatch(domain -> this.domainNsURI.equals(domain.getUri()));
    }
}

