/*
 * Decompiled with CFR 0.152.
 */
package fr.obeo.perseus.client.ui.initializer;

import fr.obeo.dsl.traceability.ArtifactRepository;
import fr.obeo.dsl.traceability.Traceability;
import fr.obeo.dsl.traceability.TraceabilityFactory;
import fr.obeo.dsl.traceability.initializer.api.ITraceabilityInitializer;
import fr.obeo.dsl.traceability.initializer.api.ITraceabilityInitializerContext;
import fr.obeo.perseus.client.impl.graphql.GQLOAuthFriend;
import fr.obeo.perseus.client.impl.traceability.IUrlPatternProvider;
import fr.obeo.perseus.client.impl.traceability.SessionTraceabilityStrategy;
import fr.obeo.perseus.client.impl.traceability.atlassian.JiraUrlPatternProvider;
import fr.obeo.perseus.client.impl.traceability.jama.JamaUrlPatternProvider;
import fr.obeo.perseus.client.impl.traceability.jazz.DoorsNextUrlPatternProvider;
import fr.obeo.perseus.client.impl.traceability.jazz.EwmUrlPatternProvider;
import fr.obeo.perseus.client.impl.traceability.polarion.PolarionUrlPatternProvider;
import fr.obeo.perseus.client.ui.PerseusClientUIPlugin;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class ArtifactRepositoryInitializer
implements ITraceabilityInitializer {
    public static final List<IUrlPatternProvider> URL_PATTERN_INITIALIZERS = Arrays.asList(new PolarionUrlPatternProvider(), new DoorsNextUrlPatternProvider(), new EwmUrlPatternProvider(), new JiraUrlPatternProvider(), new JamaUrlPatternProvider());
    private final GQLOAuthFriend friend;

    public ArtifactRepositoryInitializer(GQLOAuthFriend friend) {
        this.friend = Objects.requireNonNull(friend);
    }

    public void accept(ITraceabilityInitializerContext context) {
        if (!context.getTraceability().isPresent()) {
            return;
        }
        Traceability traceability = (Traceability)context.getTraceability().get();
        Optional<ArtifactRepository> existingRepository = traceability.getRepositories().stream().filter(SessionTraceabilityStrategy::isValid).filter(r -> this.friend.getRootServicesURI().equals(r.getUrl())).findFirst();
        if (existingRepository.isPresent()) {
            PerseusClientUIPlugin.getPlugin().getLog().log((IStatus)new Status(2, "fr.obeo.perseus.client.ui", String.format("Ignored repository '%s' because it is already defined.", this.friend.getRootServicesURI())));
        } else {
            List defaultUrlPatterns = URL_PATTERN_INITIALIZERS.stream().map(initializer -> initializer.getDefaultUrlPatterns(this.friend)).flatMap(Collection::stream).collect(Collectors.toList());
            ArtifactRepository r2 = TraceabilityFactory.eINSTANCE.createArtifactRepository();
            r2.getUrlPatterns().addAll(defaultUrlPatterns);
            r2.setId(UUID.randomUUID().toString());
            r2.setName(this.friend.getName());
            r2.setUrl(this.friend.getRootServicesURI());
            traceability.getRepositories().add((Object)r2);
        }
    }

    public boolean test(ITraceabilityInitializerContext context) {
        Optional traceability = context.getTraceability();
        return !traceability.isPresent() || ((Traceability)traceability.get()).getRepositories().stream().filter(SessionTraceabilityStrategy::isValid).noneMatch(r -> this.friend.getRootServicesURI().equals(r.getUrl()));
    }
}

