/*
 * Decompiled with CFR 0.152.
 */
package fr.obeo.perseus.client.ui.initializer;

import com.fasterxml.jackson.databind.MappingIterator;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import fr.obeo.dsl.traceability.Traceability;
import fr.obeo.dsl.traceability.TraceabilityFactory;
import fr.obeo.dsl.traceability.UrlPattern;
import fr.obeo.dsl.traceability.api.UrlMatchingSettings;
import fr.obeo.dsl.traceability.initializer.api.ITraceabilityInitializer;
import fr.obeo.dsl.traceability.initializer.api.ITraceabilityInitializerContext;
import fr.obeo.perseus.client.PerseusClientPlugin;
import fr.obeo.perseus.client.impl.traceability.SessionTraceabilityStrategy;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.ConfigurationScope;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.osgi.service.prefs.Preferences;

public class ArtifactRepositoryUrlMatchingSettingsInitializer
implements ITraceabilityInitializer {
    private static final String PREF_KEY_PERSEUS_DROP_MAPPINGS = "perseus.drop.mappings";

    public void accept(ITraceabilityInitializerContext context) {
        if (!context.getTraceability().isPresent()) {
            return;
        }
        List<UrlMatchingSettings> dropUrlMatchingConfigs = this.getDropUrlMatchingConfigs();
        context.getTraceability().map(Traceability::getRepositories).ifPresent(repos -> repos.stream().filter(SessionTraceabilityStrategy::isValid).forEach(repo -> dropUrlMatchingConfigs.stream().filter(settings -> repo.getUrl().equals(settings.getOslcURL())).findFirst().ifPresent(settings -> repo.getUrlPatterns().addAll((Collection)settings.getPatterns().stream().map(this::convert).collect(Collectors.toList())))));
    }

    private UrlPattern convert(UrlMatchingSettings.PatternAndReplacement par) {
        UrlPattern urlPattern = TraceabilityFactory.eINSTANCE.createUrlPattern();
        urlPattern.setPattern(par.getPattern().toString());
        urlPattern.setReplacement(par.getReplacement());
        return urlPattern;
    }

    public boolean test(ITraceabilityInitializerContext context) {
        Optional optTraceability = context.getTraceability();
        if (optTraceability.isPresent() && !((Traceability)optTraceability.get()).getRepositories().isEmpty()) {
            Traceability traceability = (Traceability)optTraceability.get();
            List<UrlMatchingSettings> dropUrlMatchingConfigs = this.getDropUrlMatchingConfigs();
            if (!dropUrlMatchingConfigs.isEmpty()) {
                return traceability.getRepositories().stream().filter(SessionTraceabilityStrategy::isValid).anyMatch(r -> this.getDropUrlMatchingConfigs().stream().anyMatch(settings -> r.getUrl().equals(settings.getOslcURL())));
            }
        }
        return false;
    }

    private List<UrlMatchingSettings> getDropUrlMatchingConfigs() {
        String json = Platform.getPreferencesService().get(PREF_KEY_PERSEUS_DROP_MAPPINGS, null, this.getPreferenceNodes());
        ArrayList<UrlMatchingSettings> result = new ArrayList<UrlMatchingSettings>();
        if (json == null || json.isEmpty()) {
            return result;
        }
        ObjectMapper om = new ObjectMapper();
        ObjectReader reader = om.readerFor(UrlMatchingSettings.UrlMatchingSettingsBuilder.class);
        try {
            Throwable throwable = null;
            Object var6_8 = null;
            try (MappingIterator values = reader.readValues(json);){
                while (values.hasNext()) {
                    UrlMatchingSettings.UrlMatchingSettingsBuilder next = (UrlMatchingSettings.UrlMatchingSettingsBuilder)values.next();
                    result.add(next.build());
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            PerseusClientPlugin.getPlugin().getLog().log((IStatus)new Status(2, "fr.obeo.perseus.client", "Unable to retrieve old preference for URL Matching Settings.", (Throwable)e));
        }
        return result;
    }

    private Preferences[] getPreferenceNodes() {
        return new Preferences[]{InstanceScope.INSTANCE.getNode("fr.obeo.perseus.client"), ConfigurationScope.INSTANCE.getNode("fr.obeo.perseus.client"), DefaultScope.INSTANCE.getNode("fr.obeo.perseus.client")};
    }
}

