/*
 * Decompiled with CFR 0.152.
 */
package fr.obeo.perseus.client.ui.initializer;

import fr.obeo.dsl.traceability.Traceability;
import fr.obeo.dsl.traceability.initializer.TraceabilityConfigurationCopier;
import fr.obeo.dsl.traceability.initializer.api.ITraceabilityInitializer;
import fr.obeo.dsl.traceability.initializer.api.ITraceabilityInitializerContext;
import fr.obeo.perseus.client.ui.PerseusClientUIPlugin;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.FilteredResourcesSelectionDialog;

public class TraceabilitySettingsInitializer
implements ITraceabilityInitializer {
    private final Supplier<Optional<IFile>> configFileProvider;
    private final BiConsumer<String, String> reportWarningToUser;

    public TraceabilitySettingsInitializer() {
        this.configFileProvider = this::askUserToSelectConfigFile;
        this.reportWarningToUser = this::reportWarning;
    }

    public TraceabilitySettingsInitializer(Supplier<Optional<IFile>> configFileProvider, BiConsumer<String, String> reportWarningToUser) {
        this.configFileProvider = Objects.requireNonNull(configFileProvider);
        this.reportWarningToUser = Objects.requireNonNull(reportWarningToUser);
    }

    public boolean test(ITraceabilityInitializerContext context) {
        return context.getTraceability().map(this::canInitializeFromFile).orElse(true);
    }

    public void accept(ITraceabilityInitializerContext context) {
        Traceability traceability = (Traceability)context.getTraceability().get();
        if (this.canInitializeFromFile(traceability)) {
            Optional<IFile> optConfigFile = this.configFileProvider.get();
            optConfigFile.ifPresent(configFile -> this.importUnlessInCurrentProject(context, this.getShell(), (IFile)configFile));
        } else {
            this.reportWarningToUser.accept("Import Traceability Settings Ignored", "Import of Traceability Settings file ignored because the current model already contains traceability data.");
            PerseusClientUIPlugin.getPlugin().getLog().log((IStatus)new Status(2, "fr.obeo.dsl.traceability.initializer", String.format("Import of Traceability Settings file ignored because the current model already contains traceability data.", new Object[0])));
        }
    }

    private void reportWarning(String s1, String s2) {
        MessageDialog.openWarning((Shell)this.getShell(), (String)s1, (String)s2);
    }

    private Optional<IFile> askUserToSelectConfigFile() {
        FilteredResourcesSelectionDialog dlg = new FilteredResourcesSelectionDialog(this.getShell(), false, (IContainer)ResourcesPlugin.getWorkspace().getRoot(), 1);
        dlg.setInitialPattern("*.traceability");
        dlg.setTitle("Select Traceability File to Import");
        dlg.setBlockOnOpen(true);
        Optional<IFile> optConfigFile = dlg.open() == 0 ? Optional.ofNullable(dlg.getResult()).filter(r -> ((Object[])r).length > 0).map(r -> r[0]).filter(IFile.class::isInstance).map(IFile.class::cast) : Optional.empty();
        return optConfigFile;
    }

    private Shell getShell() {
        return Optional.ofNullable(Display.getCurrent()).orElseGet(Display::getDefault).getActiveShell();
    }

    private void importUnlessInCurrentProject(ITraceabilityInitializerContext context, Shell shell, IFile configFile) {
        if (this.findProject(context.getSession()).map(prj -> prj.equals((Object)configFile.getProject())).orElse(false).booleanValue()) {
            this.reportWarningToUser.accept("Import Traceability Settings Ignored", "Import of Traceability Settings file ignored because it is in the same Project.");
        } else {
            this.importTraceabilityFile(configFile, context);
        }
    }

    private boolean canInitializeFromFile(Traceability traceability) {
        return traceability.getRepositories().isEmpty() && traceability.getDomains().isEmpty();
    }

    private void importTraceabilityFile(IFile configFile, ITraceabilityInitializerContext context) {
        final Traceability cfgTraceability = this.loadConfigurationFile(configFile);
        TransactionalEditingDomain editingDomain = context.getSession().getTransactionalEditingDomain();
        final Traceability traceability = (Traceability)context.getTraceability().get();
        RecordingCommand command = new RecordingCommand(editingDomain){

            protected void doExecute() {
                TraceabilityConfigurationCopier copier = new TraceabilityConfigurationCopier();
                Traceability copy = (Traceability)copier.copy((EObject)cfgTraceability);
                copier.copyReferences();
                traceability.getDomains().addAll((Collection)copy.getDomains());
                traceability.getRepositories().addAll((Collection)copy.getRepositories());
                if (copy.getPublicationSettings() != null) {
                    traceability.setPublicationSettings(copy.getPublicationSettings());
                }
            }
        };
        editingDomain.getCommandStack().execute((Command)command);
    }

    private Traceability loadConfigurationFile(IFile cfgFile) {
        ResourceSetImpl rs = new ResourceSetImpl();
        Resource resource = rs.getResource(URI.createPlatformResourceURI((String)cfgFile.getFullPath().toString(), (boolean)false), true);
        return (Traceability)resource.getContents().get(0);
    }

    private Optional<IProject> findProject(Session session) {
        Optional<IProject> result = Optional.empty();
        if (session != null && session.getSessionResource() != null) {
            Resource sessionResource = session.getSessionResource();
            IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
            if (sessionResource.getURI().isPlatform()) {
                IFile airdResource = root.getFile((IPath)new Path(sessionResource.getURI().toPlatformString(true)));
                result = Optional.ofNullable(airdResource.getProject());
            }
        }
        return result;
    }
}

