/*
 * Decompiled with CFR 0.152.
 */
package fr.obeo.perseus.client.ui.labels;

import fr.obeo.dsl.traceability.api.IArtifactDescriptor;
import fr.obeo.dsl.traceability.api.IArtifactRepositoryChangeSet;
import fr.obeo.dsl.traceability.api.ISnapshotDiffAction;
import fr.obeo.dsl.traceability.api.ISnapshotDifference;
import fr.obeo.dsl.traceability.api.ITraceabilityStrategy;
import fr.obeo.perseus.client.api.IModelDataProvider;
import fr.obeo.perseus.client.ui.PerseusClientUIPlugin;
import java.util.Objects;
import org.eclipse.emf.edit.ui.provider.ExtendedImageRegistry;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.graphics.Image;

public class LinkDiffLabelProvider
extends ColumnLabelProvider {
    private final LinkDiffField field;
    private final IModelDataProvider modelDataProvider;
    private final ITraceabilityStrategy traceabilityStrategy;
    private final ILabelProvider delegate;

    public LinkDiffLabelProvider(LinkDiffField field, ITraceabilityStrategy traceabilityStrategy, IModelDataProvider modelDataProvider, ILabelProvider delegate) {
        this.field = Objects.requireNonNull(field);
        this.traceabilityStrategy = Objects.requireNonNull(traceabilityStrategy);
        this.modelDataProvider = Objects.requireNonNull(modelDataProvider);
        this.delegate = Objects.requireNonNull(delegate);
    }

    public String getText(Object element) {
        String result = "";
        if (element instanceof IArtifactRepositoryChangeSet) {
            switch (this.field) {
                case MODEL_OBJECT: {
                    String url = ((IArtifactRepositoryChangeSet)element).getRepositoryUrl();
                    result = this.traceabilityStrategy.getRepositoryStrategy(url).findArtifactRepository().map(repo -> this.delegate.getText(repo)).orElse(url);
                }
            }
        } else if (element instanceof ISnapshotDiffAction) {
            ISnapshotDiffAction action = (ISnapshotDiffAction)element;
            ISnapshotDifference diff = action.getDifference();
            switch (this.field) {
                case MODEL_OBJECT: {
                    String objectId = diff.getLinkDescriptor().getModelObjectId();
                    result = this.modelDataProvider.findSemanticObjectById(objectId).map(o -> this.delegate.getText(o)).orElse(objectId);
                    break;
                }
                case LINK_TYPE: {
                    result = diff.getLinkDescriptor().getTypeDescriptor().getName();
                    break;
                }
                case ARTIFACT: {
                    result = this.traceabilityStrategy.findTraceability().map(t -> t.eResource().getEObject(diff.getLinkDescriptor().getArtifactURL())).map(o -> this.delegate.getText(o)).orElse(this.getText(action.getArtifactDescriptor()));
                    break;
                }
                case KIND: {
                    result = diff.getKind().toString();
                    break;
                }
                case ACTION: {
                    result = action.getAction().toString();
                }
            }
        } else if (element instanceof IArtifactDescriptor) {
            switch (this.field) {
                case ARTIFACT: {
                    IArtifactDescriptor desc = (IArtifactDescriptor)element;
                    if (desc.getId() != null) {
                        if (desc.getTitle() != null) {
                            result = String.format("%s - %s", desc.getId(), desc.getTitle());
                            break;
                        }
                        result = desc.getId();
                        break;
                    }
                    result = desc.getTitle() != null ? desc.getTitle() : desc.getArtifactURL();
                }
            }
        }
        return result;
    }

    public String getToolTipText(Object element) {
        String result = "";
        if (element instanceof IArtifactRepositoryChangeSet) {
            switch (this.field) {
                case MODEL_OBJECT: {
                    String url = ((IArtifactRepositoryChangeSet)element).getRepositoryUrl();
                    result = this.traceabilityStrategy.getRepositoryStrategy(url).findArtifactRepository().map(repo -> url).orElse("This repository does not exist in the Traceability model, it will be created. Please configure it properly to support drag and drop.");
                }
            }
        }
        return result;
    }

    public Image getImage(Object element) {
        Image result = null;
        if (element instanceof IArtifactRepositoryChangeSet) {
            switch (this.field) {
                case MODEL_OBJECT: {
                    String url = ((IArtifactRepositoryChangeSet)element).getRepositoryUrl();
                    result = this.traceabilityStrategy.getRepositoryStrategy(url).findArtifactRepository().map(repo -> this.delegate.getImage(repo)).orElseGet(() -> ExtendedImageRegistry.getInstance().getImage(PerseusClientUIPlugin.getPlugin().getImage("warning.gif")));
                }
            }
        } else if (element instanceof ISnapshotDiffAction) {
            ISnapshotDiffAction action = (ISnapshotDiffAction)element;
            ISnapshotDifference diff = action.getDifference();
            switch (this.field) {
                case MODEL_OBJECT: {
                    String objectId = diff.getLinkDescriptor().getModelObjectId();
                    result = this.modelDataProvider.findSemanticObjectById(objectId).map(o -> this.delegate.getImage(o)).orElse(null);
                    break;
                }
                case ARTIFACT: {
                    result = this.traceabilityStrategy.findTraceability().map(t -> t.eResource().getEObject(diff.getLinkDescriptor().getArtifactURL())).map(o -> this.delegate.getImage(o)).orElse(null);
                    break;
                }
                case ACTION: {
                    result = action.getAction() == ISnapshotDiffAction.DiffAction.REJECT ? ExtendedImageRegistry.getInstance().getImage(PerseusClientUIPlugin.getPlugin().getImage("reject.png")) : ExtendedImageRegistry.getInstance().getImage(PerseusClientUIPlugin.getPlugin().getImage("accept.png"));
                }
            }
        }
        return result;
    }

    public static enum LinkDiffField {
        MODEL_OBJECT,
        LINK_TYPE,
        ARTIFACT,
        KIND,
        ACTION;

    }
}

