/*
 * Decompiled with CFR 0.152.
 */
package fr.obeo.perseus.client.ui.labels;

import fr.obeo.perseus.client.dto.model.ModelDTO;
import java.util.Objects;
import org.eclipse.jface.viewers.ColumnLabelProvider;

public class ModelLabelProvider
extends ColumnLabelProvider {
    private final ModelField field;

    public ModelLabelProvider(ModelField field) {
        this.field = Objects.requireNonNull(field);
    }

    public String getText(Object element) {
        String result = "";
        if (element instanceof ModelDTO) {
            ModelDTO dto = (ModelDTO)element;
            switch (this.field) {
                case DESCRIPTION: {
                    result = dto.getDescription() == null ? "" : dto.getDescription();
                    break;
                }
                case ID: {
                    result = Long.toString(dto.getId());
                    break;
                }
                default: {
                    result = dto.getName() == null ? "" : dto.getName();
                }
            }
        }
        return result;
    }

    public static enum ModelField {
        NAME,
        DESCRIPTION,
        ID,
        CREATION_DATE,
        LAST_UPDATE;

    }
}

