/*
 * Decompiled with CFR 0.152.
 */
package fr.obeo.perseus.client.ui.labels;

import fr.obeo.perseus.client.dto.ProjectRefDTO;
import java.util.Objects;
import org.eclipse.jface.viewers.ColumnLabelProvider;

public class ProjectLabelProvider
extends ColumnLabelProvider {
    private final ProjectField field;

    public ProjectLabelProvider(ProjectField field) {
        this.field = Objects.requireNonNull(field);
    }

    public String getText(Object element) {
        String result = "";
        if (element instanceof ProjectRefDTO) {
            ProjectRefDTO entry = (ProjectRefDTO)element;
            switch (this.field) {
                case ID: {
                    result = String.valueOf(entry.getId());
                    break;
                }
                case VISIBILITY: {
                    result = entry.getIsPrivate() ? "PRIVATE" : "PUBLIC";
                    break;
                }
                default: {
                    result = String.valueOf(entry.getName());
                }
            }
        }
        return result;
    }

    public static enum ProjectField {
        NAME,
        ID,
        VISIBILITY;

    }
}

