/*
 * Decompiled with CFR 0.152.
 */
package fr.obeo.perseus.client.ui.oauth;

import fr.obeo.perseus.client.PerseusClientPlugin;
import fr.obeo.perseus.client.impl.oauth.PerseusAccessTokenException;
import fr.obeo.perseus.client.ui.PerseusClientUIPlugin;
import fr.obeo.perseus.client.util.PerseusProperties;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class LoginAuthServlet
extends HttpServlet {
    private static final String ERROR_BODY = "<html><body><p>Authentication initiated from %4$s failed.<table><tbody><tr><td>Error:</td><td>%1$s</td></tr><tr><td>Error Description:</td><td>%2$s</td></tr><tr><td>More Info:</td><td><a href=\"%3$s\" target=\"_blank\">%3$s</a></td></tr></tbody></table></p><p>You can close this browser tab and return to %4$s.</p></body></html>";
    private static final long serialVersionUID = 1L;

    protected void service(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        block31: {
            String state = req.getParameter("state");
            String code = req.getParameter("code");
            if (PerseusProperties.isDebug()) {
                PerseusClientUIPlugin.getPlugin().getLog().log((IStatus)new Status(1, "fr.obeo.perseus.client.ui", String.format("login received with code: '%s', state: '%s'", code, state)));
            }
            if (code == null) {
                String error = req.getParameter("error");
                String errorDescription = req.getParameter("error_description");
                String errorUri = req.getParameter("error_uri");
                PerseusClientUIPlugin.getPlugin().logError(errorDescription);
                Throwable throwable = null;
                Object var9_21 = null;
                try (OutputStreamWriter w = new OutputStreamWriter((OutputStream)resp.getOutputStream());){
                    w.write(String.format(ERROR_BODY, error, errorDescription, errorUri, errorUri));
                    break block31;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            try {
                PerseusClientPlugin.getPlugin().getPerseusServerCredentialProvider().tradeAuthorizationCodeForAccessToken(state, code);
                Throwable error = null;
                Object var6_10 = null;
                try (OutputStreamWriter w = new OutputStreamWriter((OutputStream)resp.getOutputStream());){
                    w.write(String.format("<html><body><p>Authentication initiated from %1$s successful.</p><p>You can close this browser tab and return to %1$s.</p></body></html>", System.getProperty("eclipse.launcher.name")));
                }
                catch (Throwable throwable) {
                    if (error == null) {
                        error = throwable;
                    } else if (error != throwable) {
                        error.addSuppressed(throwable);
                    }
                    throw error;
                }
            }
            catch (PerseusAccessTokenException e) {
                Throwable throwable = null;
                Object var7_16 = null;
                try (OutputStreamWriter w = new OutputStreamWriter((OutputStream)resp.getOutputStream());){
                    w.write(String.format(ERROR_BODY, e.getTokenError().getError(), e.getTokenError().getErrorDescription(), e.getTokenError().getErrorUri(), System.getProperty("eclipse.launcher.name")));
                }
                catch (Throwable throwable3) {
                    if (throwable == null) {
                        throwable = throwable3;
                    } else if (throwable != throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    throw throwable;
                }
            }
        }
    }
}

