/*
 * Decompiled with CFR 0.152.
 */
package fr.obeo.perseus.client.ui.oauth;

import fr.obeo.perseus.client.ui.PerseusClientUIPlugin;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.eclipse.jetty.util.IO;
import org.eclipse.jetty.util.resource.Resource;

public class OAuthLoopbackServerDefaultHandler
extends AbstractHandler {
    final long faviconModified = System.currentTimeMillis() / 1000L * 1000L;
    final byte[] favicon;

    public OAuthLoopbackServerDefaultHandler() {
        byte[] favbytes = null;
        try {
            try {
                URL fav = ((Object)((Object)this)).getClass().getClassLoader().getResource("fr/obeo/perseus/client/ui/oauth/favicon.ico");
                if (fav != null) {
                    Resource r = Resource.newResource((URL)fav);
                    favbytes = IO.readBytes((InputStream)r.getInputStream());
                }
            }
            catch (Exception e) {
                PerseusClientUIPlugin.getPlugin().logError("Could not load favicon", e);
                this.favicon = favbytes;
            }
        }
        finally {
            this.favicon = favbytes;
        }
    }

    public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        if (!response.isCommitted() && !baseRequest.isHandled()) {
            baseRequest.setHandled(true);
            String method = request.getMethod();
            if (this.favicon != null && "GET".equals(method) && target.equals("/favicon.ico")) {
                if (request.getDateHeader("If-Modified-Since") == this.faviconModified) {
                    response.setStatus(304);
                } else {
                    response.setStatus(200);
                    response.setContentType("image/x-icon");
                    response.setContentLength(this.favicon.length);
                    response.setDateHeader("Last-Modified", this.faviconModified);
                    response.setHeader("Cache-Control", "max-age=360000,public");
                    response.getOutputStream().write(this.favicon);
                }
            } else {
                response.sendError(404);
            }
        }
    }
}

