/*
 * Decompiled with CFR 0.152.
 */
package fr.obeo.perseus.client.ui.oauth;

import fr.obeo.perseus.client.api.IOAuth2Settings;
import fr.obeo.perseus.client.api.IPerseusServerConfig;
import fr.obeo.perseus.client.api.IPerseusServerCredentialProvider;
import fr.obeo.perseus.client.impl.oauth.AccessTokenError;
import fr.obeo.perseus.client.impl.oauth.IAccessTokenResponse;
import fr.obeo.perseus.client.impl.oauth.OAuthCredentials;
import fr.obeo.perseus.client.impl.oauth.PerseusAccessTokenException;
import fr.obeo.perseus.client.impl.oauth.TokenResponse;
import fr.obeo.perseus.client.ui.PerseusClientUIPlugin;
import fr.obeo.perseus.client.ui.util.AuthenticationUtil;
import fr.obeo.perseus.client.util.PerseusHttpSupport;
import fr.obeo.perseus.client.util.PerseusProperties;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.time.Clock;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Supplier;
import org.apache.http.client.utils.URIBuilder;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jetty.server.Server;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.browser.IWebBrowser;

public class PerseusServerCredentialProvider
implements IPerseusServerCredentialProvider {
    private static final String KEY_CLIENT_ID = "client_id";
    private static final String KEY_CODE = "code";
    private static final String KEY_CODE_CHALLENGE = "code_challenge";
    private static final String KEY_CODE_CHALLENGE_METHOD = "code_challenge_method";
    private static final String KEY_CODE_VERIFIER = "code_verifier";
    private static final String KEY_GRANT_TYPE = "grant_type";
    private static final String KEY_REFRESH_TOKEN = "refresh_token";
    private static final String KEY_RESPONSE_TYPE = "response_type";
    private static final String KEY_REDIRECT_URI = "redirect_uri";
    private static final String KEY_SCOPE = "scope";
    private static final String KEY_STATE = "state";
    private static final String CHALLENGE_METHOD_SHA_256 = "S256";
    private static final String RESPONSE_TYPE_CODE = "code";
    private static final String GRANT_TYPE_AUTHORIZATION_CODE = "authorization_code";
    private static final String GRANT_TYPE_REFRESH_TOKEN = "refresh_token";
    private static final String LOGIN_AUTH_SERVLET = "/login/auth";
    private static final byte[] PKCE_CHARS = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789-._~".getBytes();
    private final SecureRandom secureRandom = new SecureRandom();
    private final PerseusHttpSupport.Factory httpSupportFactory;
    private final Map<String, AuthorizationCodeRequest> oauthRequestByStates = new HashMap<String, AuthorizationCodeRequest>();
    private final Map<String, OAuthCredentials> credentialsByAuthUrl;
    private final Clock clock;
    private final Supplier<IWebBrowser> webBrowserSupplier;

    public PerseusServerCredentialProvider(PerseusHttpSupport.Factory httpSupportFactory) {
        this(httpSupportFactory, () -> {
            try {
                return PlatformUI.getWorkbench().getBrowserSupport().getExternalBrowser();
            }
            catch (Exception e) {
                return null;
            }
        });
    }

    public PerseusServerCredentialProvider(PerseusHttpSupport.Factory httpSupportFactory, Supplier<IWebBrowser> webBrowserSupplier) {
        this.httpSupportFactory = Objects.requireNonNull(httpSupportFactory);
        this.credentialsByAuthUrl = Collections.synchronizedMap(new HashMap());
        this.clock = Clock.systemUTC();
        this.webBrowserSupplier = Objects.requireNonNull(webBrowserSupplier);
    }

    public synchronized boolean hasValidCredentials(IPerseusServerConfig config) {
        IOAuth2Settings oauth2Settings = (IOAuth2Settings)config.getOAuth2Settings().get();
        String authUrl = oauth2Settings.getAuthorizationServerUrl();
        OAuthCredentials credentials = this.credentialsByAuthUrl.get(authUrl);
        return credentials != null && !credentials.isExpired(this.clock);
    }

    public synchronized OAuthCredentials getCredentials(IPerseusServerConfig config, IProgressMonitor monitor) throws IOException, OperationCanceledException {
        IOAuth2Settings oauth2Settings = (IOAuth2Settings)config.getOAuth2Settings().get();
        String authUrl = oauth2Settings.getAuthorizationServerUrl();
        OAuthCredentials credentials = this.credentialsByAuthUrl.get(authUrl);
        if (credentials == null) {
            credentials = this.triggerLogin(oauth2Settings, monitor);
        } else if (credentials.isExpired(this.clock)) {
            this.credentialsByAuthUrl.remove(authUrl);
            if (credentials.getAccessTokenData().getRefreshToken() != null) {
                try {
                    String refreshToken = credentials.getAccessTokenData().getRefreshToken();
                    credentials = this.refreshAccessToken(oauth2Settings.getClientId(), refreshToken, URI.create(oauth2Settings.getTokenServerUrl()));
                    if (credentials.getAccessTokenData().getRefreshToken() == null) {
                        credentials.getAccessTokenData().setRefreshToken(refreshToken);
                    }
                    this.credentialsByAuthUrl.put(authUrl, credentials);
                }
                catch (PerseusAccessTokenException | IOException e) {
                    PerseusClientUIPlugin.getPlugin().getLog().log((IStatus)new Status(2, "fr.obeo.perseus.client.ui", "OIDC - Refresh of access token failed, will trigger user login.", e));
                    credentials = this.triggerLogin(oauth2Settings, monitor);
                }
            } else {
                credentials = this.triggerLogin(oauth2Settings, monitor);
            }
        }
        return credentials;
    }

    private OAuthCredentials triggerLogin(IOAuth2Settings oauth2Settings, IProgressMonitor monitor) throws IOException, OperationCanceledException {
        Server server = PerseusClientUIPlugin.getPlugin().getOAuth2LoginLoopbackServer();
        if (server == null) {
            throw new IOException("Unable to start server on the loopback interface (localhost)");
        }
        String state = UUID.randomUUID().toString();
        byte[] codeVerifier = this.pkceCodeVerifier();
        URI redirectUri = server.getURI().resolve(LOGIN_AUTH_SERVLET);
        AuthorizationCodeRequest authorizationCodeRequest = new AuthorizationCodeRequest(oauth2Settings.getAuthorizationServerUrl(), codeVerifier, redirectUri.toString(), URI.create(oauth2Settings.getTokenServerUrl()), oauth2Settings.getClientId());
        if (this.oauthRequestByStates.put(state, authorizationCodeRequest) != null) {
            throw new IllegalStateException();
        }
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
            messageDigest.update(codeVerifier);
            byte[] digest = messageDigest.digest();
            String codeChallenge = AuthenticationUtil.base64UrlEncodeForOAuth2(digest);
            URIBuilder b = new URIBuilder(oauth2Settings.getAuthorizationServerUrl());
            b.addParameter(KEY_CLIENT_ID, oauth2Settings.getClientId());
            b.addParameter(KEY_RESPONSE_TYPE, "code");
            b.addParameter(KEY_CODE_CHALLENGE, codeChallenge);
            b.addParameter(KEY_CODE_CHALLENGE_METHOD, CHALLENGE_METHOD_SHA_256);
            b.addParameter(KEY_STATE, state);
            b.addParameter(KEY_REDIRECT_URI, redirectUri.toString());
            b.addParameter(KEY_SCOPE, oauth2Settings.getScope());
            URL url = b.build().toURL();
            IWebBrowser webBrowser = this.webBrowserSupplier.get();
            if (webBrowser == null) {
                throw new IOException("Could not open your web browser. Please open it manually and navigate to the following page to authenticate with your Publication Server: " + url);
            }
            try {
                webBrowser.openURL(url);
            }
            catch (PartInitException e) {
                throw new IOException("Could not open your web browser. Please open it manually and navigate to the following page to authenticate with your Publication Server: " + url);
            }
            int counter = 0;
            int max = PerseusProperties.getOAuth2LoginTimeoutMs() / 10;
            SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)max);
            while (!authorizationCodeRequest.isSet() && counter++ < max) {
                if (progress.isCanceled()) {
                    throw new OperationCanceledException();
                }
                progress.worked(1);
                Thread.sleep(10L);
            }
            if (authorizationCodeRequest.isSet()) {
                return authorizationCodeRequest.getCredentials();
            }
            throw new IOException("Timeout while trying to login to Publication server. Please retry the operation.");
        }
        catch (NoSuchAlgorithmException e) {
            throw new IOException(e);
        }
        catch (URISyntaxException e) {
            String msg = String.format("Invalid authorization URL in given configuration: %s. Please fix your preferences.", oauth2Settings.getAuthorizationServerUrl());
            PerseusClientUIPlugin.getPlugin().logError(msg);
            throw new IOException(msg, e);
        }
        catch (InterruptedException e) {
            throw new OperationCanceledException(e.getMessage());
        }
    }

    private byte[] pkceCodeVerifier() {
        byte[] result = new byte[64];
        int i = 0;
        while (i < 64) {
            result[i] = PKCE_CHARS[this.secureRandom.nextInt(66)];
            ++i;
        }
        return result;
    }

    public void tradeAuthorizationCodeForAccessToken(String state, String authorizationCode) throws PerseusAccessTokenException, IOException {
        AuthorizationCodeRequest request = this.oauthRequestByStates.remove(state);
        if (request != null) {
            Optional<OAuthCredentials> optCredentials;
            String verifier = new String(request.getCodeVerifier());
            Server server = PerseusClientUIPlugin.getPlugin().getOAuth2LoginLoopbackServer();
            if (server == null) {
                throw new IllegalStateException("OIDC - Cannot proceed with login to Publication server, required localhost server could not start.");
            }
            TokenResponse tokenResponse = this.postTokenRequest(request, authorizationCode, verifier);
            if (tokenResponse.isSuccess() && (optCredentials = this.extractCredentials((IAccessTokenResponse)tokenResponse)).isPresent()) {
                OAuthCredentials credentials = optCredentials.get();
                this.credentialsByAuthUrl.put(request.getServerAuthUri(), credentials);
                request.setCredentials(credentials);
                return;
            }
            PerseusClientUIPlugin.getPlugin().logError(String.format("OIDC - Failed to trade authorization code for access token. Status = %d; Reason = %s", tokenResponse.getStatus(), tokenResponse.getBody()));
            request.setCredentials(null);
            Optional optTokenError = tokenResponse.getError();
            if (optTokenError.isPresent()) {
                throw new PerseusAccessTokenException((AccessTokenError)optTokenError.get());
            }
            throw new IOException(tokenResponse.getBody());
        }
        PerseusClientUIPlugin.getPlugin().logError("OIDC - Received request to trade an authorization code with an unknown state " + state);
    }

    public OAuthCredentials refreshAccessToken(String clientId, String refreshToken, URI serverTokenUri) throws IOException, PerseusAccessTokenException {
        Optional<OAuthCredentials> optCredentials;
        TokenResponse tokenResponse = this.postRefreshTokenRequest(clientId, serverTokenUri, refreshToken);
        if (tokenResponse.isSuccess() && (optCredentials = this.extractCredentials((IAccessTokenResponse)tokenResponse)).isPresent()) {
            return optCredentials.get();
        }
        PerseusClientUIPlugin.getPlugin().logError(String.format("OIDC - Failed to refresh access token. Status = %d; Reason = %s", tokenResponse.getStatus(), tokenResponse.getBody()));
        Optional optTokenError = tokenResponse.getError();
        if (optTokenError.isPresent()) {
            throw new PerseusAccessTokenException((AccessTokenError)optTokenError.get());
        }
        throw new IOException(tokenResponse.getBody());
    }

    /*
     * Exception decompiling
     */
    private TokenResponse postTokenRequest(AuthorizationCodeRequest request, String authorizationCode, String codeVerifier) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private Optional<OAuthCredentials> extractCredentials(IAccessTokenResponse tokenResponse) {
        return tokenResponse.getAccessTokenData().map(OAuthCredentials::new);
    }

    /*
     * Exception decompiling
     */
    private TokenResponse postRefreshTokenRequest(String clientId, URI uri, String refreshToken) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static class AuthorizationCodeRequest {
        private final String serverAuthUri;
        private final byte[] codeVerifier;
        private final String redirectUri;
        private final URI serverTokenUri;
        private final String clientId;
        private volatile boolean set;
        private volatile OAuthCredentials credentials;

        AuthorizationCodeRequest(String serverAuthURI, byte[] codeVerifier, String redirectUri, URI serverTokenUri, String clientId) {
            this.codeVerifier = Objects.requireNonNull(codeVerifier);
            this.redirectUri = Objects.requireNonNull(redirectUri);
            this.serverAuthUri = serverAuthURI;
            this.serverTokenUri = serverTokenUri;
            this.clientId = clientId;
        }

        public String getServerAuthUri() {
            return this.serverAuthUri;
        }

        public URI getServerTokenUri() {
            return this.serverTokenUri;
        }

        public String getRedirectUri() {
            return this.redirectUri;
        }

        public byte[] getCodeVerifier() {
            return this.codeVerifier;
        }

        public String getClientId() {
            return this.clientId;
        }

        public synchronized boolean isSet() {
            return this.set;
        }

        public synchronized OAuthCredentials getCredentials() {
            return this.credentials;
        }

        public synchronized void setCredentials(OAuthCredentials credentials) {
            this.credentials = credentials;
            this.set = true;
        }
    }
}

