/*
 * Decompiled with CFR 0.152.
 */
package fr.obeo.perseus.client.ui.preferences;

import fr.obeo.perseus.client.api.IPerseusServerConfig;
import fr.obeo.perseus.client.ui.Messages;
import fr.obeo.perseus.client.ui.preferences.PerseusServerConfig;
import fr.obeo.perseus.client.ui.preferences.UriConverter;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.URI;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.core.databinding.Binding;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.ValidationStatusProvider;
import org.eclipse.core.databinding.beans.IBeanValueProperty;
import org.eclipse.core.databinding.beans.typed.BeanProperties;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.databinding.fieldassist.ControlDecorationSupport;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.typed.WidgetProperties;
import org.eclipse.jface.databinding.viewers.IViewerObservableValue;
import org.eclipse.jface.databinding.viewers.typed.ViewerProperties;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class AddPerseusServerDialog
extends TitleAreaDialog
implements PropertyChangeListener {
    private DataBindingContext bindingContext;
    private final PerseusServerConfig config;
    private List<PerseusServerConfig> existingConfigs;
    private Composite container;
    private Text txtUrl;
    private ComboViewer authModeCombo;
    private Composite loginGroup;
    private Composite oauth2Group;
    private Text txtUsername;
    private Text txtPassword;
    private Text txtServerAuthorizationUrl;
    private Text txtServerTokenUrl;
    private Text txtOAuth2ClientId;
    private Text txtOAuth2Scope;
    private Button okButton;

    public AddPerseusServerDialog(Shell parentShell, PerseusServerConfig config, List<PerseusServerConfig> existingConfigs) {
        super(parentShell);
        this.setHelpAvailable(false);
        this.setShellStyle(67696);
        this.config = Objects.requireNonNull(config);
        this.existingConfigs = existingConfigs;
        config.addPropertyChangeListener(this);
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitle(Messages.AddPerseusServerDialog_Title);
        Composite area = (Composite)super.createDialogArea(parent);
        this.container = new Composite(area, 0);
        GridLayout glContainer = new GridLayout(2, false);
        glContainer.horizontalSpacing = 10;
        this.container.setLayout((Layout)glContainer);
        this.container.setLayoutData((Object)new GridData(4, 1024, true, false, 1, 1));
        Label lblUrl = new Label(this.container, 0);
        lblUrl.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblUrl.setText(Messages.AddPerseusServerDialog_LblURL);
        this.txtUrl = new Text(this.container, 2048);
        this.txtUrl.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.txtUrl.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AddPerseusServerDialog.this.validateForm();
            }
        });
        Label authModeLbl = new Label(this.container, 0);
        authModeLbl.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        authModeLbl.setText(Messages.LblAuthMode);
        this.authModeCombo = new ComboViewer(this.container);
        this.authModeCombo.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.authModeCombo.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                String result = null;
                switch ((IPerseusServerConfig.AuthMode)element) {
                    case LOGIN: {
                        result = Messages.LblBtnAuthModeLogin;
                        break;
                    }
                    case OAUTH2: {
                        result = Messages.LblBtnAuthModeOAuth2;
                    }
                }
                return result;
            }
        });
        this.authModeCombo.setInput((Object)IPerseusServerConfig.AuthMode.values());
        this.authModeCombo.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                AddPerseusServerDialog.this.validateForm();
            }
        });
        this.createLoginGroup();
        this.createOAuth2Group();
        return area;
    }

    private void createLoginGroup() {
        this.loginGroup = new Group(this.container, 0);
        this.loginGroup.setLayoutData((Object)new GridData(4, 128, true, true, 2, 1));
        GridLayout layout = new GridLayout(2, false);
        this.loginGroup.setLayout((Layout)layout);
        Label lblUserName = new Label(this.loginGroup, 0);
        lblUserName.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblUserName.setText(Messages.LblUserName);
        this.txtUsername = new Text(this.loginGroup, 2048);
        this.txtUsername.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        Label lblPassword = new Label(this.loginGroup, 0);
        lblPassword.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblPassword.setText(Messages.LblPassword);
        this.txtPassword = new Text(this.loginGroup, 0x400800);
        this.txtPassword.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
    }

    private void createOAuth2Group() {
        this.oauth2Group = new Group(this.container, 0);
        this.oauth2Group.setLayoutData((Object)new GridData(4, 128, true, true, 2, 1));
        GridLayout layout = new GridLayout(2, false);
        this.oauth2Group.setLayout((Layout)layout);
        Label lblServerAuthorizationUrl = new Label(this.oauth2Group, 0);
        lblServerAuthorizationUrl.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblServerAuthorizationUrl.setText(Messages.LblAuthorizationUrl);
        this.txtServerAuthorizationUrl = new Text(this.oauth2Group, 2048);
        this.txtServerAuthorizationUrl.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.txtServerAuthorizationUrl.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AddPerseusServerDialog.this.validateForm();
            }
        });
        Label lblServerTokenUrl = new Label(this.oauth2Group, 0);
        lblServerTokenUrl.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblServerTokenUrl.setText(Messages.LblTokenUrl);
        this.txtServerTokenUrl = new Text(this.oauth2Group, 2048);
        this.txtServerTokenUrl.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.txtServerTokenUrl.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AddPerseusServerDialog.this.validateForm();
            }
        });
        Label lblOAuth2ClientId = new Label(this.oauth2Group, 0);
        lblOAuth2ClientId.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblOAuth2ClientId.setText(Messages.LblOAuth2ClientId);
        this.txtOAuth2ClientId = new Text(this.oauth2Group, 2048);
        this.txtOAuth2ClientId.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.txtOAuth2ClientId.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AddPerseusServerDialog.this.validateForm();
            }
        });
        Label lblOAuth2Scope = new Label(this.oauth2Group, 0);
        lblOAuth2Scope.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblOAuth2Scope.setText(Messages.LblOAuth2Scope);
        this.txtOAuth2Scope = new Text(this.oauth2Group, 2048);
        this.txtOAuth2Scope.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.txtOAuth2Scope.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AddPerseusServerDialog.this.validateForm();
            }
        });
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.okButton = this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.okButton.setEnabled(false);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
        this.refreshAuthGroups();
        this.initDataBindings();
    }

    protected Point getInitialSize() {
        return new Point(684, 410);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("authMode".equals(evt.getPropertyName())) {
            this.refreshAuthGroups();
        }
    }

    public boolean close() {
        if (this.config != null) {
            this.config.removePropertyChangeListener(this);
        }
        return super.close();
    }

    private void refreshAuthGroups() {
        IPerseusServerConfig.AuthMode currentMode = this.config != null ? this.config.getAuthMode() : IPerseusServerConfig.AuthMode.LOGIN;
        this.loginGroup.setVisible(currentMode == IPerseusServerConfig.AuthMode.LOGIN);
        ((GridData)this.loginGroup.getLayoutData()).exclude = currentMode != IPerseusServerConfig.AuthMode.LOGIN;
        this.oauth2Group.setVisible(currentMode == IPerseusServerConfig.AuthMode.OAUTH2);
        ((GridData)this.oauth2Group.getLayoutData()).exclude = currentMode != IPerseusServerConfig.AuthMode.OAUTH2;
        this.oauth2Group.requestLayout();
        this.loginGroup.requestLayout();
        this.container.layout();
    }

    protected void initDataBindings() {
        this.bindingContext = new DataBindingContext();
        ISWTObservableValue observeTextTxtUrlObserveWidget = WidgetProperties.text((int)24).observe((Widget)this.txtUrl);
        IObservableValue uriConfigObserveValue = BeanProperties.value((String)"uri").observe((Object)this.config);
        Binding urlBinding = this.bindingContext.bindValue((IObservableValue)observeTextTxtUrlObserveWidget, uriConfigObserveValue, UpdateValueStrategy.create((IConverter)new UriConverter()).setAfterConvertValidator(value -> {
            this.validateForm();
            return this.validateServerUri((URI)value);
        }), null);
        ControlDecorationSupport.create((ValidationStatusProvider)urlBinding, (int)16512);
        this.configureAuthBindings();
    }

    private void configureAuthBindings() {
        IBeanValueProperty authModeValue = BeanProperties.value((String)"authMode");
        IObservableValue selectionAuthModeObserveValue = authModeValue.observe((Object)this.config);
        IViewerObservableValue authModeSelection = ViewerProperties.singleSelection(IPerseusServerConfig.AuthMode.class).observe((Viewer)this.authModeCombo);
        this.bindingContext.bindValue((IObservableValue)authModeSelection, selectionAuthModeObserveValue, new UpdateValueStrategy().setAfterConvertValidator(value -> ValidationStatus.ok()), null);
        ISWTObservableValue observeTextUsernameObserveWidget = WidgetProperties.text((int)24).observe((Widget)this.txtUsername);
        IObservableValue selectionUsernameObserveValue = BeanProperties.value((String)"username").observe((Object)this.config);
        this.bindingContext.bindValue((IObservableValue)observeTextUsernameObserveWidget, selectionUsernameObserveValue);
        ISWTObservableValue observeTextPasswordObserveWidget = WidgetProperties.text((int)24).observe((Widget)this.txtPassword);
        IObservableValue selectionPasswordObserveValue = BeanProperties.value((String)"password").observe((Object)this.config);
        this.bindingContext.bindValue((IObservableValue)observeTextPasswordObserveWidget, selectionPasswordObserveValue);
        ISWTObservableValue observeTextAuthorizationUrlObserveWidget = WidgetProperties.text((int)24).observe((Widget)this.txtServerAuthorizationUrl);
        IObservableValue selectionAuthorizationUrlConfigObserveValue = BeanProperties.value((String)"authorizationServerUrl").observe((Object)this.config);
        Binding authUrlBinding = this.bindingContext.bindValue((IObservableValue)observeTextAuthorizationUrlObserveWidget, selectionAuthorizationUrlConfigObserveValue, new UpdateValueStrategy().setAfterConvertValidator(value -> this.validateUrl((String)value, Messages.MsgInvalidAuthServerURL)), null);
        ControlDecorationSupport.create((ValidationStatusProvider)authUrlBinding, (int)16512);
        ISWTObservableValue observeTextTokenUrlObserveWidget = WidgetProperties.text((int)24).observe((Widget)this.txtServerTokenUrl);
        IObservableValue selectionTokenUrlConfigObserveValue = BeanProperties.value((String)"tokenServerUrl").observe((Object)this.config);
        Binding tokenUrlBinding = this.bindingContext.bindValue((IObservableValue)observeTextTokenUrlObserveWidget, selectionTokenUrlConfigObserveValue, new UpdateValueStrategy().setAfterConvertValidator(value -> this.validateUrl((String)value, Messages.MsgInvalidTokenServerURL)), null);
        ControlDecorationSupport.create((ValidationStatusProvider)tokenUrlBinding, (int)16512);
        ISWTObservableValue observeTextClientIdObserveWidget = WidgetProperties.text((int)24).observe((Widget)this.txtOAuth2ClientId);
        IObservableValue selectionClientIdConfigObserveValue = BeanProperties.value((String)"clientId").observe((Object)this.config);
        Binding clientIdBinding = this.bindingContext.bindValue((IObservableValue)observeTextClientIdObserveWidget, selectionClientIdConfigObserveValue, new UpdateValueStrategy().setAfterConvertValidator(value -> this.validateMandatoryValue((String)value, Messages.MsgInvalidClientId)), null);
        ControlDecorationSupport.create((ValidationStatusProvider)clientIdBinding, (int)16512);
        ISWTObservableValue observeTextScopeObserveWidget = WidgetProperties.text((int)24).observe((Widget)this.txtOAuth2Scope);
        IObservableValue selectionScopeConfigObserveValue = BeanProperties.value((String)"scope").observe((Object)this.config);
        Binding scopeBinding = this.bindingContext.bindValue((IObservableValue)observeTextScopeObserveWidget, selectionScopeConfigObserveValue, new UpdateValueStrategy().setAfterConvertValidator(value -> this.validateScopeValue((String)value, Messages.MsgInvalidScope)), null);
        ControlDecorationSupport.create((ValidationStatusProvider)scopeBinding, (int)16512);
    }

    private void validateForm() {
        IStatus status = ValidationStatus.ok();
        try {
            URI serverUri = URI.create(this.txtUrl.getText());
            status = this.validateServerUri(serverUri);
            if (status.isOK() && this.authModeCombo.getStructuredSelection().getFirstElement() == IPerseusServerConfig.AuthMode.OAUTH2) {
                status = this.validateUrl(this.txtServerAuthorizationUrl.getText(), Messages.MsgInvalidAuthServerURL);
                if (status.isOK()) {
                    status = this.validateUrl(this.txtServerTokenUrl.getText(), Messages.MsgInvalidTokenServerURL);
                }
                if (status.isOK()) {
                    status = this.validateMandatoryValue(this.txtOAuth2ClientId.getText(), Messages.MsgInvalidClientId);
                }
                if (status.isOK()) {
                    status = this.validateScopeValue(this.txtOAuth2Scope.getText(), Messages.MsgInvalidScope);
                }
            }
        }
        catch (Exception e) {
            status = ValidationStatus.error((String)Messages.MsgInvalidURL);
        }
        if (!status.isOK()) {
            this.setErrorMessage(status.getMessage());
            Optional.ofNullable(this.okButton).ifPresent(button -> button.setEnabled(false));
        } else {
            this.setErrorMessage(null);
            Optional.ofNullable(this.okButton).ifPresent(button -> button.setEnabled(true));
        }
    }

    private IStatus validateMandatoryValue(String value, String message) {
        IStatus status = ValidationStatus.ok();
        if (value == null || value.isEmpty() || value.indexOf(" ") >= 0) {
            status = ValidationStatus.error((String)message);
        }
        return status;
    }

    private IStatus validateScopeValue(String value, String message) {
        IStatus status = ValidationStatus.ok();
        if (value == null || value.isEmpty()) {
            status = ValidationStatus.error((String)message);
        }
        return status;
    }

    private IStatus validateUrl(String value, String message) {
        IStatus status = ValidationStatus.ok();
        if (value == null) {
            status = ValidationStatus.error((String)message);
        } else {
            try {
                URI uri = URI.create(value);
                if (!PerseusServerConfig.isValidForServer(uri)) {
                    status = ValidationStatus.error((String)message);
                }
            }
            catch (Exception e) {
                status = ValidationStatus.error((String)message);
            }
        }
        return status;
    }

    private IStatus validateServerUri(URI uri) {
        IStatus status = ValidationStatus.ok();
        if (PerseusServerConfig.isValidForServer(uri)) {
            for (PerseusServerConfig existingConfig : this.existingConfigs) {
                if (!uri.equals(existingConfig.getUri())) continue;
                status = ValidationStatus.error((String)String.format(Messages.AlreadyRegisteredURL, uri));
                break;
            }
        } else {
            status = ValidationStatus.error((String)Messages.MsgInvalidURL);
        }
        return status;
    }
}

