/*
 * Decompiled with CFR 0.152.
 */
package fr.obeo.perseus.client.ui.preferences;

import fr.obeo.perseus.client.ui.preferences.PerseusServerConfig;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class PerseusConfiguration {
    public static final String PROP_CONFIGS = "serverConfigs";
    private final List<PerseusServerConfig> serverConfigs;
    private final PropertyChangeSupport pcs = new PropertyChangeSupport(this);

    public PerseusConfiguration(List<PerseusServerConfig> serverConfigs) {
        this.serverConfigs = Objects.requireNonNull(serverConfigs);
    }

    public List<PerseusServerConfig> getServerConfigsView() {
        return Collections.unmodifiableList(this.serverConfigs);
    }

    public void addServerConfig(PerseusServerConfig config) {
        this.serverConfigs.add(config);
        this.pcs.fireIndexedPropertyChange(PROP_CONFIGS, this.serverConfigs.size() - 1, null, config);
    }

    public void removeServerConfig(PerseusServerConfig config) {
        int index = this.serverConfigs.indexOf(config);
        if (index >= 0) {
            this.serverConfigs.remove(index);
            this.pcs.fireIndexedPropertyChange(PROP_CONFIGS, index, config, null);
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(listener);
    }
}

