/*
 * Decompiled with CFR 0.152.
 */
package fr.obeo.perseus.client.ui.preferences;

import fr.obeo.perseus.client.api.IPerseusServerConfig;
import fr.obeo.perseus.client.ui.Messages;
import fr.obeo.perseus.client.ui.PerseusClientUIPlugin;
import fr.obeo.perseus.client.ui.labels.ServerUrlLabelProvider;
import fr.obeo.perseus.client.ui.preferences.AddPerseusServerDialog;
import fr.obeo.perseus.client.ui.preferences.PerseusConfiguration;
import fr.obeo.perseus.client.ui.preferences.PerseusPreferences;
import fr.obeo.perseus.client.ui.preferences.PerseusServerConfig;
import fr.obeo.perseus.client.ui.preferences.UriConverter;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.URI;
import org.eclipse.core.databinding.Binding;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.ValidationStatusProvider;
import org.eclipse.core.databinding.beans.IBeanValueProperty;
import org.eclipse.core.databinding.beans.typed.BeanProperties;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.IValueChangeListener;
import org.eclipse.core.databinding.observable.value.ValueChangeEvent;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.databinding.fieldassist.ControlDecorationSupport;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.typed.WidgetProperties;
import org.eclipse.jface.databinding.viewers.IViewerObservableValue;
import org.eclipse.jface.databinding.viewers.typed.ViewerProperties;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class PerseusPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage,
ISelectionChangedListener,
PropertyChangeListener {
    private final PerseusPreferences prefs;
    private PerseusConfiguration perseusConfig;
    private PerseusServerConfig selectedConfig;
    private SelectionListener removeListener;
    private DataBindingContext bindingContext;
    private Table table;
    private TableViewer tableViewer;
    private TableViewerColumn tvColUrl;
    private ColumnLabelProvider urlLabelProvider = new ServerUrlLabelProvider();
    private Button btnAdd;
    private Button btnRemove;
    private Group configGroup;
    private Text txtUrl;
    private ComboViewer authModeCombo;
    private Composite loginGroup;
    private Composite oauth2Group;
    private Text txtUsername;
    private Text txtPassword;
    private Text txtServerAuthorizationUrl;
    private Text txtServerTokenUrl;
    private Text txtOAuth2ClientId;
    private Text txtOAuth2Scope;

    public PerseusPreferencePage() {
        this.setPreferenceStore(PerseusClientUIPlugin.getPlugin().getPreferenceStore());
        this.prefs = new PerseusPreferences();
    }

    public void init(IWorkbench workbench) {
        this.perseusConfig = this.loadCurrentConfig();
    }

    public Control createContents(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout glContainer = new GridLayout(1, false);
        container.setLayout((Layout)glContainer);
        this.createMasterGroup(container);
        this.createConfigGroup(container);
        this.createLoginGroup();
        this.createOAuth2Group();
        this.tableViewer.setInput((Object)this.perseusConfig);
        this.initDataBindings();
        if (this.perseusConfig.getServerConfigsView().size() > 0) {
            this.tableViewer.setSelection((ISelection)new StructuredSelection((Object)this.perseusConfig.getServerConfigsView().get(0)));
        }
        this.perseusConfig.addPropertyChangeListener(this);
        return container;
    }

    private void createMasterGroup(Composite container) {
        Group grpMaster = new Group(container, 0);
        grpMaster.setText(Messages.PerseusPreferencePage_LblRegisteredSvr);
        grpMaster.setLayout((Layout)new GridLayout(2, false));
        grpMaster.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.tableViewer = new TableViewer((Composite)grpMaster, 67584);
        this.tableViewer.setContentProvider((IContentProvider)new PerseusConfigContentProvider());
        this.tableViewer.addSelectionChangedListener((ISelectionChangedListener)this);
        this.table = this.tableViewer.getTable();
        this.table.setHeaderVisible(true);
        this.table.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.tvColUrl = new TableViewerColumn(this.tableViewer, 0);
        this.tvColUrl.setLabelProvider((CellLabelProvider)this.urlLabelProvider);
        TableColumn colUrl = this.tvColUrl.getColumn();
        colUrl.setWidth(225);
        colUrl.setText(Messages.PerseusPreferencePage_LblColURL);
        Composite btContainer = new Composite((Composite)grpMaster, 0);
        btContainer.setLayout((Layout)new GridLayout(1, false));
        GridData gdBtContainer = new GridData(16384, 128, false, false, 1, 1);
        gdBtContainer.widthHint = 80;
        gdBtContainer.minimumWidth = 50;
        btContainer.setLayoutData((Object)gdBtContainer);
        this.btnAdd = new Button(btContainer, 0);
        this.btnAdd.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.btnAdd.setText(Messages.PerseusPreferencePage_LblBtnAdd);
        this.btnAdd.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PerseusServerConfig newConfig = new PerseusServerConfig();
                AddPerseusServerDialog dialog = new AddPerseusServerDialog(PerseusPreferencePage.this.getShell(), newConfig, PerseusPreferencePage.this.prefs.getServerConfigs());
                if (dialog.open() == 0) {
                    PerseusPreferencePage.this.perseusConfig.addServerConfig(newConfig);
                    PerseusPreferencePage.this.tableViewer.setSelection((ISelection)new StructuredSelection((Object)newConfig), true);
                }
            }
        });
        this.btnRemove = new Button(btContainer, 0);
        this.btnRemove.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.btnRemove.setText(Messages.PerseusPreferencePage_LblBtnRemove);
        this.removeListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PerseusServerConfig config = (PerseusServerConfig)PerseusPreferencePage.this.tableViewer.getStructuredSelection().getFirstElement();
                if (config != null) {
                    PerseusPreferencePage.this.removeConfiguration(config);
                }
            }
        };
        this.btnRemove.addSelectionListener(this.removeListener);
    }

    private void createConfigGroup(Composite container) {
        this.configGroup = new Group(container, 0);
        this.configGroup.setText(Messages.PerseusPreferencePage_LblSelected);
        this.configGroup.setLayout((Layout)new GridLayout(2, false));
        this.configGroup.setLayoutData((Object)new GridData(4, 1024, true, false, 1, 1));
        Label lblUrl = new Label((Composite)this.configGroup, 0);
        lblUrl.setEnabled(false);
        lblUrl.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblUrl.setText(Messages.PerseusPreferencePage_LblServerURL);
        this.txtUrl = new Text((Composite)this.configGroup, 2048);
        this.txtUrl.setEnabled(false);
        this.txtUrl.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.txtUrl.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                PerseusPreferencePage.this.validateForm();
            }
        });
        Label authModeLbl = new Label((Composite)this.configGroup, 0);
        authModeLbl.setEnabled(false);
        authModeLbl.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        authModeLbl.setText(Messages.LblAuthMode);
        this.authModeCombo = new ComboViewer((Composite)this.configGroup);
        this.authModeCombo.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.authModeCombo.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                String result = null;
                switch ((IPerseusServerConfig.AuthMode)element) {
                    case LOGIN: {
                        result = Messages.LblBtnAuthModeLogin;
                        break;
                    }
                    case OAUTH2: {
                        result = Messages.LblBtnAuthModeOAuth2;
                    }
                }
                return result;
            }
        });
        this.authModeCombo.setInput((Object)IPerseusServerConfig.AuthMode.values());
        this.authModeCombo.getCombo().setEnabled(false);
        this.authModeCombo.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                PerseusPreferencePage.this.validateForm();
            }
        });
    }

    private void createLoginGroup() {
        this.loginGroup = new Group((Composite)this.configGroup, 0);
        this.loginGroup.setLayoutData((Object)new GridData(4, 128, true, true, 2, 1));
        GridLayout layout = new GridLayout(2, false);
        this.loginGroup.setLayout((Layout)layout);
        Label lblUserName = new Label(this.loginGroup, 0);
        lblUserName.setEnabled(false);
        lblUserName.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblUserName.setText(Messages.LblUserName);
        this.txtUsername = new Text(this.loginGroup, 2048);
        this.txtUsername.setEnabled(false);
        this.txtUsername.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        Label lblPassword = new Label(this.loginGroup, 0);
        lblPassword.setEnabled(false);
        lblPassword.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblPassword.setText(Messages.LblPassword);
        this.txtPassword = new Text(this.loginGroup, 0x400800);
        this.txtPassword.setEnabled(false);
        this.txtPassword.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
    }

    private void createOAuth2Group() {
        this.oauth2Group = new Group((Composite)this.configGroup, 0);
        this.oauth2Group.setLayoutData((Object)new GridData(4, 128, true, true, 2, 1));
        GridLayout layout = new GridLayout(2, false);
        this.oauth2Group.setLayout((Layout)layout);
        Label lblServerAuthorizationUrl = new Label(this.oauth2Group, 0);
        lblServerAuthorizationUrl.setEnabled(false);
        lblServerAuthorizationUrl.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblServerAuthorizationUrl.setText(Messages.LblAuthorizationUrl);
        this.txtServerAuthorizationUrl = new Text(this.oauth2Group, 2048);
        this.txtServerAuthorizationUrl.setEnabled(false);
        this.txtServerAuthorizationUrl.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.txtServerAuthorizationUrl.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                PerseusPreferencePage.this.validateForm();
            }
        });
        Label lblServerTokenUrl = new Label(this.oauth2Group, 0);
        lblServerTokenUrl.setEnabled(false);
        lblServerTokenUrl.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblServerTokenUrl.setText(Messages.LblTokenUrl);
        this.txtServerTokenUrl = new Text(this.oauth2Group, 2048);
        this.txtServerTokenUrl.setEnabled(false);
        this.txtServerTokenUrl.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.txtServerTokenUrl.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                PerseusPreferencePage.this.validateForm();
            }
        });
        Label lblOAuth2ClientId = new Label(this.oauth2Group, 0);
        lblOAuth2ClientId.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblOAuth2ClientId.setText(Messages.LblOAuth2ClientId);
        this.txtOAuth2ClientId = new Text(this.oauth2Group, 2048);
        this.txtOAuth2ClientId.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.txtOAuth2ClientId.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                PerseusPreferencePage.this.validateForm();
            }
        });
        Label lblOAuth2Scope = new Label(this.oauth2Group, 0);
        lblOAuth2Scope.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblOAuth2Scope.setText(Messages.LblOAuth2Scope);
        this.txtOAuth2Scope = new Text(this.oauth2Group, 2048);
        this.txtOAuth2Scope.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.txtOAuth2Scope.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                PerseusPreferencePage.this.validateForm();
            }
        });
    }

    public void selectionChanged(SelectionChangedEvent event) {
        if (event.getSource() == this.tableViewer) {
            PerseusServerConfig config = (PerseusServerConfig)event.getStructuredSelection().getFirstElement();
            this.setCurrentConfig(config);
        }
    }

    private PerseusConfiguration loadCurrentConfig() {
        return new PerseusConfiguration(this.prefs.getServerConfigs());
    }

    private void removeConfiguration(PerseusServerConfig config) {
        this.perseusConfig.removeServerConfig(config);
    }

    private void setCurrentConfig(PerseusServerConfig config) {
        if (this.selectedConfig != null) {
            this.selectedConfig.removePropertyChangeListener(this);
        }
        this.selectedConfig = config;
        if (this.selectedConfig != null) {
            this.selectedConfig.addPropertyChangeListener(this);
        }
    }

    public boolean performOk() {
        this.prefs.setPerseusServers(this.perseusConfig.getServerConfigsView());
        return super.performOk();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.tableViewer.refresh();
        if ("authMode".equals(evt.getPropertyName())) {
            this.refreshAuthGroups();
        }
    }

    private void refreshAuthGroups() {
        IPerseusServerConfig.AuthMode currentMode = this.selectedConfig != null ? this.selectedConfig.getAuthMode() : IPerseusServerConfig.AuthMode.LOGIN;
        this.loginGroup.setVisible(currentMode == IPerseusServerConfig.AuthMode.LOGIN);
        ((GridData)this.loginGroup.getLayoutData()).exclude = currentMode != IPerseusServerConfig.AuthMode.LOGIN;
        this.oauth2Group.setVisible(currentMode == IPerseusServerConfig.AuthMode.OAUTH2);
        ((GridData)this.oauth2Group.getLayoutData()).exclude = currentMode != IPerseusServerConfig.AuthMode.OAUTH2;
        this.oauth2Group.requestLayout();
        this.loginGroup.requestLayout();
        this.configGroup.layout();
    }

    public void dispose() {
        if (this.perseusConfig != null) {
            this.perseusConfig.removePropertyChangeListener(this);
        }
        if (this.selectedConfig != null) {
            this.selectedConfig.removePropertyChangeListener(this);
        }
        super.dispose();
    }

    protected void initDataBindings() {
        this.bindingContext = new DataBindingContext();
        IViewerObservableValue selection = ViewerProperties.singleSelection(PerseusServerConfig.class).observe((Viewer)this.tableViewer);
        selection.addValueChangeListener((IValueChangeListener)new IValueChangeListener<PerseusServerConfig>(){

            public void handleValueChange(ValueChangeEvent<? extends PerseusServerConfig> event) {
                Control ctl;
                boolean enabled = !PerseusPreferencePage.this.tableViewer.getStructuredSelection().isEmpty();
                Control[] controlArray = PerseusPreferencePage.this.configGroup.getChildren();
                int n = controlArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ctl = controlArray[n2];
                    ctl.setEnabled(enabled);
                    ++n2;
                }
                controlArray = PerseusPreferencePage.this.loginGroup.getChildren();
                n = controlArray.length;
                n2 = 0;
                while (n2 < n) {
                    ctl = controlArray[n2];
                    ctl.setEnabled(enabled);
                    ++n2;
                }
                controlArray = PerseusPreferencePage.this.oauth2Group.getChildren();
                n = controlArray.length;
                n2 = 0;
                while (n2 < n) {
                    ctl = controlArray[n2];
                    ctl.setEnabled(enabled);
                    ++n2;
                }
                PerseusPreferencePage.this.refreshAuthGroups();
            }
        });
        ISWTObservableValue observeTextTxtUrlObserveWidget = WidgetProperties.text((int)24).observe((Widget)this.txtUrl);
        IObservableValue uriConfigObserveValue = BeanProperties.value((String)"uri").observeDetail((IObservableValue)selection);
        Binding urlBinding = this.bindingContext.bindValue((IObservableValue)observeTextTxtUrlObserveWidget, uriConfigObserveValue, UpdateValueStrategy.create((IConverter)new UriConverter()).setAfterConvertValidator(value -> {
            this.validateForm();
            return this.validateServerUri((URI)value);
        }), null);
        ControlDecorationSupport.create((ValidationStatusProvider)urlBinding, (int)16512);
        this.configureAuthBindings((IObservableValue<PerseusServerConfig>)selection);
    }

    private void configureAuthBindings(IObservableValue<PerseusServerConfig> selection) {
        IBeanValueProperty authModeValue = BeanProperties.value((String)"authMode");
        IObservableValue selectionAuthModeObserveValue = authModeValue.observeDetail(selection);
        IViewerObservableValue authModeSelection = ViewerProperties.singleSelection(IPerseusServerConfig.AuthMode.class).observe((Viewer)this.authModeCombo);
        this.bindingContext.bindValue((IObservableValue)authModeSelection, selectionAuthModeObserveValue, new UpdateValueStrategy().setAfterConvertValidator(value -> ValidationStatus.ok()), null);
        ISWTObservableValue observeTextUsernameObserveWidget = WidgetProperties.text((int)24).observe((Widget)this.txtUsername);
        IObservableValue selectionUsernameObserveValue = BeanProperties.value((String)"username").observeDetail(selection);
        this.bindingContext.bindValue((IObservableValue)observeTextUsernameObserveWidget, selectionUsernameObserveValue);
        ISWTObservableValue observeTextPasswordObserveWidget = WidgetProperties.text((int)24).observe((Widget)this.txtPassword);
        IObservableValue selectionPasswordObserveValue = BeanProperties.value((String)"password").observeDetail(selection);
        this.bindingContext.bindValue((IObservableValue)observeTextPasswordObserveWidget, selectionPasswordObserveValue);
        ISWTObservableValue observeTextAuthorizationUrlObserveWidget = WidgetProperties.text((int)24).observe((Widget)this.txtServerAuthorizationUrl);
        IObservableValue selectionAuthorizationUrlConfigObserveValue = BeanProperties.value((String)"authorizationServerUrl").observeDetail(selection);
        Binding authUrlBinding = this.bindingContext.bindValue((IObservableValue)observeTextAuthorizationUrlObserveWidget, selectionAuthorizationUrlConfigObserveValue, new UpdateValueStrategy().setAfterConvertValidator(value -> this.validateUrl((String)value, Messages.MsgInvalidAuthServerURL)), null);
        ControlDecorationSupport.create((ValidationStatusProvider)authUrlBinding, (int)16512);
        ISWTObservableValue observeTextTokenUrlObserveWidget = WidgetProperties.text((int)24).observe((Widget)this.txtServerTokenUrl);
        IObservableValue selectionTokenUrlConfigObserveValue = BeanProperties.value((String)"tokenServerUrl").observeDetail(selection);
        Binding tokenUrlBinding = this.bindingContext.bindValue((IObservableValue)observeTextTokenUrlObserveWidget, selectionTokenUrlConfigObserveValue, new UpdateValueStrategy().setAfterConvertValidator(value -> this.validateUrl((String)value, Messages.MsgInvalidTokenServerURL)), null);
        ControlDecorationSupport.create((ValidationStatusProvider)tokenUrlBinding, (int)16512);
        ISWTObservableValue observeTextClientIdObserveWidget = WidgetProperties.text((int)24).observe((Widget)this.txtOAuth2ClientId);
        IObservableValue selectionClientIdConfigObserveValue = BeanProperties.value((String)"clientId").observeDetail(selection);
        Binding clientIdBinding = this.bindingContext.bindValue((IObservableValue)observeTextClientIdObserveWidget, selectionClientIdConfigObserveValue, new UpdateValueStrategy().setAfterConvertValidator(value -> this.validateMandatoryValue((String)value, Messages.MsgInvalidClientId)), null);
        ControlDecorationSupport.create((ValidationStatusProvider)clientIdBinding, (int)16512);
        ISWTObservableValue observeTextScopeObserveWidget = WidgetProperties.text((int)24).observe((Widget)this.txtOAuth2Scope);
        IObservableValue selectionScopeConfigObserveValue = BeanProperties.value((String)"scope").observeDetail(selection);
        Binding scopeBinding = this.bindingContext.bindValue((IObservableValue)observeTextScopeObserveWidget, selectionScopeConfigObserveValue, new UpdateValueStrategy().setAfterConvertValidator(value -> this.validateScopeValue((String)value, Messages.MsgInvalidScope)), null);
        ControlDecorationSupport.create((ValidationStatusProvider)scopeBinding, (int)16512);
    }

    private void validateForm() {
        if (!this.tableViewer.getSelection().isEmpty()) {
            IStatus status = ValidationStatus.ok();
            try {
                URI serverUri = URI.create(this.txtUrl.getText());
                status = this.validateServerUri(serverUri);
                if (status.isOK() && this.authModeCombo.getStructuredSelection().getFirstElement() == IPerseusServerConfig.AuthMode.OAUTH2) {
                    status = this.validateUrl(this.txtServerAuthorizationUrl.getText(), Messages.MsgInvalidAuthServerURL);
                    if (status.isOK()) {
                        status = this.validateUrl(this.txtServerTokenUrl.getText(), Messages.MsgInvalidTokenServerURL);
                    }
                    if (status.isOK()) {
                        status = this.validateMandatoryValue(this.txtOAuth2ClientId.getText(), Messages.MsgInvalidClientId);
                    }
                    if (status.isOK()) {
                        status = this.validateScopeValue(this.txtOAuth2Scope.getText(), Messages.MsgInvalidScope);
                    }
                }
            }
            catch (Exception e) {
                status = ValidationStatus.error((String)Messages.MsgInvalidURL);
            }
            if (!status.isOK()) {
                this.setErrorMessage(status.getMessage());
                this.setValid(false);
            } else {
                this.setErrorMessage(null);
                this.setValid(true);
            }
        } else {
            this.setErrorMessage(null);
            this.setValid(true);
        }
    }

    private IStatus validateMandatoryValue(String value, String message) {
        IStatus status = ValidationStatus.ok();
        if (value == null || value.isEmpty() || value.indexOf(" ") >= 0) {
            status = ValidationStatus.error((String)message);
        }
        return status;
    }

    private IStatus validateScopeValue(String value, String message) {
        IStatus status = ValidationStatus.ok();
        if (value == null || value.isEmpty()) {
            status = ValidationStatus.error((String)message);
        }
        return status;
    }

    private IStatus validateUrl(String value, String message) {
        IStatus status = ValidationStatus.ok();
        if (value == null) {
            status = ValidationStatus.error((String)message);
        } else {
            try {
                URI uri = URI.create(value);
                if (!PerseusServerConfig.isValidForServer(uri)) {
                    status = ValidationStatus.error((String)message);
                }
            }
            catch (Exception e) {
                status = ValidationStatus.error((String)message);
            }
        }
        return status;
    }

    private IStatus validateServerUri(URI uri) {
        IStatus status = ValidationStatus.ok();
        if (!PerseusServerConfig.isValidForServer(uri)) {
            status = ValidationStatus.error((String)Messages.MsgInvalidURL);
        } else {
            for (PerseusServerConfig existingConfig : this.perseusConfig.getServerConfigsView()) {
                if (this.selectedConfig.equals(existingConfig) || !uri.equals(existingConfig.getUri())) continue;
                status = ValidationStatus.error((String)String.format(Messages.AlreadyRegisteredURL, uri));
                break;
            }
        }
        return status;
    }

    private static class PerseusConfigContentProvider
    implements IStructuredContentProvider {
        private PerseusConfigContentProvider() {
        }

        public Object[] getElements(Object input) {
            if (input instanceof PerseusConfiguration) {
                PerseusConfiguration config = (PerseusConfiguration)input;
                return config.getServerConfigsView().toArray();
            }
            return null;
        }
    }
}

