/*
 * Decompiled with CFR 0.152.
 */
package fr.obeo.perseus.client.ui.preferences;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.MappingIterator;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.ObjectWriter;
import fr.obeo.perseus.client.ui.PerseusClientUIPlugin;
import fr.obeo.perseus.client.ui.preferences.PerseusServerConfig;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.ConfigurationScope;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.equinox.security.storage.ISecurePreferences;
import org.eclipse.equinox.security.storage.SecurePreferencesFactory;
import org.eclipse.equinox.security.storage.StorageException;
import org.osgi.service.prefs.Preferences;

public final class PerseusPreferences {
    public static final String PREF_KEY_PERSEUS_SERVERS = "perseus.servers";
    private static final String SECURE_STORAGE_KEY = "fr.obeo.perseus.client.ui.credentials";
    private static final String USER = "user";
    private static final String PASSWORD = "password";
    private final IPreferencesService preferencesService;
    private final ISecurePreferences securePrefs;

    public PerseusPreferences(IPreferencesService preferenceService, ISecurePreferences securePrefs) {
        this.preferencesService = Objects.requireNonNull(preferenceService);
        this.securePrefs = Objects.requireNonNull(securePrefs);
    }

    public PerseusPreferences() {
        this(Platform.getPreferencesService(), SecurePreferencesFactory.getDefault());
    }

    public void addServer(PerseusServerConfig serverConfig) {
        if (serverConfig != null) {
            List<PerseusServerConfig> servers = this.getServerConfigs();
            servers.add(serverConfig);
            this.setPerseusServers(servers);
        }
    }

    public void setPerseusServers(List<PerseusServerConfig> servers) {
        ObjectMapper om = new ObjectMapper();
        ObjectWriter writer = om.writer();
        try {
            InstanceScope.INSTANCE.getNode("fr.obeo.perseus.client.ui").put(PREF_KEY_PERSEUS_SERVERS, writer.writeValueAsString(servers));
            servers.stream().forEach(config -> this.storeCredentials((PerseusServerConfig)config));
            this.cleanCredentialsExceptFor(servers.stream().map(config -> config.getUri()).collect(Collectors.toList()));
        }
        catch (JsonProcessingException e) {
            PerseusClientUIPlugin.getPlugin().logError(e.getMessage(), e);
        }
    }

    public List<PerseusServerConfig> getServerConfigs() {
        String json = this.preferencesService.get(PREF_KEY_PERSEUS_SERVERS, null, (Preferences[])this.getPreferenceNodes());
        ArrayList<PerseusServerConfig> result = new ArrayList<PerseusServerConfig>();
        if (json == null || json.isEmpty()) {
            return result;
        }
        ObjectMapper om = new ObjectMapper();
        ObjectReader reader = om.readerFor(PerseusServerConfig.class);
        try {
            Throwable throwable = null;
            Object var6_8 = null;
            try (MappingIterator values = reader.readValues(json);){
                while (values.hasNext()) {
                    PerseusServerConfig next = (PerseusServerConfig)values.next();
                    result.add(next);
                    this.loadCredentialsTo(next);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            PerseusClientUIPlugin.getPlugin().logError(e.getMessage(), e);
        }
        return result;
    }

    public Optional<PerseusServerConfig> getServerConfig(URI uri) {
        if (uri == null) {
            return Optional.empty();
        }
        List<PerseusServerConfig> registeredservers = this.getServerConfigs();
        return registeredservers.stream().filter(server -> uri.equals(server.getUri())).findFirst();
    }

    private IEclipsePreferences[] getPreferenceNodes() {
        return new IEclipsePreferences[]{InstanceScope.INSTANCE.getNode("fr.obeo.perseus.client.ui"), ConfigurationScope.INSTANCE.getNode("fr.obeo.perseus.client.ui"), DefaultScope.INSTANCE.getNode("fr.obeo.perseus.client.ui")};
    }

    private void loadCredentialsTo(PerseusServerConfig config) {
        if (this.securePrefs.nodeExists(SECURE_STORAGE_KEY)) {
            ISecurePreferences node = this.securePrefs.node(SECURE_STORAGE_KEY);
            try {
                config.setUsername(node.get(this.userKey(config), null));
                config.setPassword(node.get(this.passwordKey(config), null));
            }
            catch (StorageException e) {
                PerseusClientUIPlugin.getPlugin().log(new Status(4, "fr.obeo.perseus.client.ui", e.getMessage(), (Throwable)e));
            }
        }
    }

    private void storeCredentials(PerseusServerConfig config) {
        ISecurePreferences node = this.securePrefs.node(SECURE_STORAGE_KEY);
        try {
            node.put(this.userKey(config), config.getUsername(), false);
            node.put(this.passwordKey(config), config.getPassword(), true);
        }
        catch (StorageException e) {
            PerseusClientUIPlugin.getPlugin().log(new Status(4, "fr.obeo.perseus.client.ui", e.getMessage(), (Throwable)e));
        }
    }

    private void cleanCredentialsExceptFor(List<URI> serverURIs) {
        LinkedHashSet toKeep = new LinkedHashSet();
        serverURIs.stream().forEach(uri -> {
            toKeep.add(uri.resolve(USER).toString());
            toKeep.add(uri.resolve(PASSWORD).toString());
        });
        if (this.securePrefs.nodeExists(SECURE_STORAGE_KEY)) {
            ISecurePreferences secureStorageNode = this.securePrefs.node(SECURE_STORAGE_KEY);
            LinkedHashSet<String> memorizedKeys = new LinkedHashSet<String>(Arrays.asList(secureStorageNode.keys()));
            memorizedKeys.removeAll(toKeep);
            for (String key : memorizedKeys) {
                secureStorageNode.remove(key);
            }
        }
    }

    private String passwordKey(PerseusServerConfig config) {
        return config.getUri().resolve(PASSWORD).toString();
    }

    private String userKey(PerseusServerConfig config) {
        return config.getUri().resolve(USER).toString();
    }
}

