/*
 * Decompiled with CFR 0.152.
 */
package fr.obeo.perseus.client.ui.preferences;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import fr.obeo.perseus.client.api.IOAuth2Settings;
import fr.obeo.perseus.client.api.IPerseusServerConfig;
import fr.obeo.perseus.client.api.PerseusCredentialsException;
import fr.obeo.perseus.client.ui.Messages;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.net.URI;
import java.util.Objects;
import java.util.Optional;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.impl.client.BasicCredentialsProvider;

@JsonIgnoreProperties(ignoreUnknown=true)
public class PerseusServerConfig
implements IPerseusServerConfig,
IOAuth2Settings {
    @JsonIgnore
    public static final String PROP_URI = "uri";
    @JsonIgnore
    public static final String PROP_AUTH_MODE = "authMode";
    @JsonIgnore
    public static final String PROP_USERNAME = "username";
    @JsonIgnore
    public static final String PROP_PASSWORD = "password";
    @JsonIgnore
    public static final String PROP_AUTHORIZATION_SERVER_URL = "authorizationServerUrl";
    @JsonIgnore
    public static final String PROP_TOKEN_SERVER_URL = "tokenServerUrl";
    @JsonIgnore
    public static final String PROP_CLIENT_ID = "clientId";
    @JsonIgnore
    public static final String PROP_SCOPE = "scope";
    private URI uri;
    private IPerseusServerConfig.AuthMode authMode = IPerseusServerConfig.AuthMode.LOGIN;
    @JsonIgnore
    private String username;
    @JsonIgnore
    private String password;
    private String authorizationServerUrl;
    private String tokenServerUrl;
    private String clientId;
    private String scope;
    @JsonIgnore
    private final transient PropertyChangeSupport pcs = new PropertyChangeSupport(this);

    public static boolean isValidForServer(URI uri) {
        boolean result = true;
        if (uri == null || !uri.isAbsolute() || uri.isOpaque()) {
            result = false;
        } else if (uri.getAuthority() == null || !"http".equals(uri.getScheme()) && !"https".equals(uri.getScheme())) {
            result = false;
        }
        return result;
    }

    public URI getUri() {
        return this.uri;
    }

    public void setUri(URI uri) {
        URI oldUri = this.uri;
        this.uri = Objects.requireNonNull(uri);
        this.pcs.firePropertyChange(PROP_URI, oldUri, uri);
    }

    public IPerseusServerConfig.AuthMode getAuthMode() {
        return this.authMode;
    }

    public void setAuthMode(IPerseusServerConfig.AuthMode authMode) {
        IPerseusServerConfig.AuthMode oldMode = this.authMode;
        this.authMode = authMode;
        this.pcs.firePropertyChange(PROP_AUTH_MODE, oldMode, authMode);
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        String oldName = this.username;
        this.username = username;
        this.pcs.firePropertyChange(PROP_USERNAME, oldName, username);
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        String oldPassword = this.password;
        this.password = password;
        this.pcs.firePropertyChange(PROP_PASSWORD, oldPassword, password);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(listener);
    }

    @JsonIgnore
    public URI getApiURI() {
        return this.getUri().resolve("/api/");
    }

    @JsonIgnore
    public URI getJobsURI() {
        return this.getUri().resolve("/jobs");
    }

    @JsonIgnore
    public Optional<IOAuth2Settings> getOAuth2Settings() {
        if (this.authMode == IPerseusServerConfig.AuthMode.OAUTH2) {
            return Optional.of(this);
        }
        return Optional.empty();
    }

    @JsonIgnore
    public CredentialsProvider getCredentialsProvider() throws PerseusCredentialsException {
        if (this.authMode != IPerseusServerConfig.AuthMode.LOGIN) {
            throw new IllegalArgumentException();
        }
        if (this.username == null || this.username.isEmpty() || this.password == null || this.password.isEmpty()) {
            throw new PerseusCredentialsException(Messages.PerseusServerConfig_CredentialsNotFound, (IPerseusServerConfig)this);
        }
        BasicCredentialsProvider result = new BasicCredentialsProvider();
        if (this.uri.getPort() >= 0) {
            result.setCredentials(new AuthScope(this.uri.getHost(), this.uri.getPort(), "Perseus API"), (Credentials)new UsernamePasswordCredentials(this.username, this.password));
        } else {
            result.setCredentials(new AuthScope(this.uri.getHost(), 443, "Perseus API"), (Credentials)new UsernamePasswordCredentials(this.username, this.password));
        }
        return result;
    }

    public String getAuthorizationServerUrl() {
        return this.authorizationServerUrl;
    }

    public String getTokenServerUrl() {
        return this.tokenServerUrl;
    }

    public String getClientId() {
        return this.clientId;
    }

    public String getScope() {
        return this.scope;
    }

    public final void setAuthorizationServerUrl(String authorizationServerUrl) {
        String oldValue = this.authorizationServerUrl;
        this.authorizationServerUrl = authorizationServerUrl;
        this.pcs.firePropertyChange(PROP_AUTHORIZATION_SERVER_URL, oldValue, authorizationServerUrl);
    }

    public final void setTokenServerUrl(String tokenServerUrl) {
        String oldValue = this.tokenServerUrl;
        this.tokenServerUrl = tokenServerUrl;
        this.pcs.firePropertyChange(PROP_TOKEN_SERVER_URL, oldValue, tokenServerUrl);
    }

    public final void setClientId(String clientId) {
        String oldValue = this.clientId;
        this.clientId = clientId;
        this.pcs.firePropertyChange(PROP_CLIENT_ID, oldValue, clientId);
    }

    public final void setScope(String scope) {
        String oldValue = this.scope;
        this.scope = scope;
        this.pcs.firePropertyChange(PROP_SCOPE, oldValue, scope);
    }
}

