/*
 * Decompiled with CFR 0.152.
 */
package fr.obeo.perseus.client.ui.propertytesters;

import fr.obeo.perseus.client.api.IModelTranslationScope;
import fr.obeo.perseus.client.api.ISessionSupport;
import fr.obeo.perseus.client.impl.SessionModelDataProvider;
import fr.obeo.perseus.client.impl.SessionModelTranslationScope;
import fr.obeo.perseus.client.util.PerseusSessionUtil;
import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.core.resources.IFile;
import org.eclipse.sirius.business.api.session.Session;

public class IsConnectedPropertyTester
extends PropertyTester {
    private static final String PROP_IS_CONNECTED = "isConnected";
    private final ISessionSupport sessionSupport;

    public IsConnectedPropertyTester() {
        this.sessionSupport = new PerseusSessionUtil();
    }

    public IsConnectedPropertyTester(ISessionSupport sessionSupport) {
        this.sessionSupport = sessionSupport;
    }

    public boolean test(Object receiver, String property, Object[] args, Object expectedValue) {
        boolean result = false;
        if (receiver instanceof IFile && PROP_IS_CONNECTED.equals(property)) {
            IFile iFile = (IFile)receiver;
            result = this.sessionSupport.findOpenSession(iFile).flatMap(s -> this.getModelDataProvider((Session)s).getPerseusModelURI()).isPresent();
            if (expectedValue instanceof Boolean) {
                Boolean exp = (Boolean)expectedValue;
                result = result == exp;
            }
        }
        return result;
    }

    private SessionModelDataProvider getModelDataProvider(Session s) {
        return new SessionModelDataProvider(s, (IModelTranslationScope)new SessionModelTranslationScope(s));
    }
}

