/*
 * Decompiled with CFR 0.152.
 */
package fr.obeo.perseus.client.ui.propertytesters;

import fr.obeo.dsl.traceability.Publication;
import fr.obeo.dsl.traceability.Traceability;
import fr.obeo.dsl.traceability.api.ITraceabilityStrategy;
import fr.obeo.perseus.client.PerseusClientPlugin;
import fr.obeo.perseus.client.api.IPublicationResultJobRegistry;
import fr.obeo.perseus.client.api.ISessionSupport;
import fr.obeo.perseus.client.util.PerseusSessionUtil;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.Adapters;
import org.eclipse.sirius.business.api.session.Session;

public class IsPublishingPropertyTester
extends PropertyTester {
    private static final String PROP_IS_PUBLISHING = "isPublishing";
    private static final String PROP_IS_JOB_RUNNING = "isPublishJobRunning";
    private final ISessionSupport sessionSupport;
    private final IPublicationResultJobRegistry publicationResultJobRegistry;

    public IsPublishingPropertyTester() {
        this((ISessionSupport)new PerseusSessionUtil(), PerseusClientPlugin.getPlugin().getPublicationJobRegistry());
    }

    public IsPublishingPropertyTester(ISessionSupport sessionSupport, IPublicationResultJobRegistry publicationResultJobRegistry) {
        this.sessionSupport = Objects.requireNonNull(sessionSupport);
        this.publicationResultJobRegistry = Objects.requireNonNull(publicationResultJobRegistry);
    }

    public boolean test(Object receiver, String property, Object[] args, Object expectedValue) {
        boolean test = false;
        if (receiver instanceof IFile) {
            IFile iFile = (IFile)receiver;
            if (PROP_IS_PUBLISHING.equals(property)) {
                test = this.sessionSupport.findOpenSession(iFile).flatMap(this::findTraceability).map(Traceability::getPendingPublication).isPresent();
            } else if (PROP_IS_JOB_RUNNING.equals(property)) {
                test = this.sessionSupport.findOpenSession(iFile).flatMap(this::findTraceability).map(Traceability::getPendingPublication).map(Publication::getJobId).map(arg_0 -> ((IPublicationResultJobRegistry)this.publicationResultJobRegistry).hasPublicationResultJob(arg_0)).orElse(false);
            }
            if (expectedValue instanceof Boolean) {
                Boolean exp = (Boolean)expectedValue;
                test = test == exp;
            }
        }
        return test;
    }

    protected Optional<Traceability> findTraceability(Session s) {
        return ((ITraceabilityStrategy)Adapters.adapt((Object)s, ITraceabilityStrategy.class)).findTraceability();
    }
}

