/*
 * Decompiled with CFR 0.152.
 */
package fr.obeo.perseus.client.ui.propertytesters;

import fr.obeo.perseus.client.api.ISessionSupport;
import fr.obeo.perseus.client.util.PerseusSessionUtil;
import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.core.resources.IFile;

public class SessionOpenPropertyTester
extends PropertyTester {
    private static final String PROP_SESSION_OPEN = "sessionOpen";
    private final ISessionSupport sessionSupport;

    public SessionOpenPropertyTester() {
        this.sessionSupport = new PerseusSessionUtil();
    }

    public SessionOpenPropertyTester(ISessionSupport sessionSupport) {
        this.sessionSupport = sessionSupport;
    }

    public boolean test(Object receiver, String property, Object[] args, Object expectedValue) {
        boolean result = false;
        if (receiver instanceof IFile && PROP_SESSION_OPEN.equals(property)) {
            IFile iFile = (IFile)receiver;
            result = this.sessionSupport.isOpenSessionFile(iFile);
            if (expectedValue instanceof Boolean) {
                Boolean exp = (Boolean)expectedValue;
                result = result == exp;
            }
        }
        return result;
    }
}

