/*
 * Decompiled with CFR 0.152.
 */
package fr.obeo.perseus.client.ui.runnables;

import fr.obeo.dsl.traceability.IArtifact;
import fr.obeo.dsl.traceability.api.IArtifactDescriptor;
import fr.obeo.dsl.traceability.api.IArtifactRepositoryStrategy;
import fr.obeo.dsl.traceability.api.IArtifactRepositoryUpdater;
import fr.obeo.dsl.traceability.api.ITraceabilityStrategy;
import fr.obeo.perseus.client.PerseusClientPlugin;
import fr.obeo.perseus.client.api.IModelDataProvider;
import fr.obeo.perseus.client.api.IPerseusConfigSupport;
import fr.obeo.perseus.client.api.IPerseusServerConfig;
import fr.obeo.perseus.client.api.PerseusServerException;
import fr.obeo.perseus.client.impl.graphql.GQLOslcConfiguration;
import fr.obeo.perseus.client.impl.traceability.ArtifactDescriptor;
import fr.obeo.perseus.client.impl.traceability.TypeDescriptor;
import fr.obeo.perseus.client.ui.Messages;
import fr.obeo.perseus.client.util.ModelURI;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.sirius.business.api.session.Session;

public final class EnsureModelConfigurationUriRunnable
implements IRunnableWithProgress {
    private static final String OSLC_CONFIG_DOMAIN = "http://open-services.net/ns/config#";
    private static final String OSLC_CONFIG_TYPE_NAME = "Configuration";
    private final ModelURI modelURI;
    private final ITraceabilityStrategy traceabilityStrategy;
    private final IModelDataProvider modelDataProvider;
    private final IPerseusConfigSupport configSupport;
    private final Session session;

    public EnsureModelConfigurationUriRunnable(ModelURI modelURI, ITraceabilityStrategy traceabilityStrategy, IModelDataProvider modelDataProvider, IPerseusConfigSupport configSupport, Session session) {
        this.modelURI = Objects.requireNonNull(modelURI);
        this.traceabilityStrategy = Objects.requireNonNull(traceabilityStrategy);
        this.modelDataProvider = Objects.requireNonNull(modelDataProvider);
        this.configSupport = Objects.requireNonNull(configSupport);
        this.session = Objects.requireNonNull(session);
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        try {
            IPerseusServerConfig serverConfig = this.configSupport.getConfigFromModelURI(this.modelURI);
            Optional optOslcConfig = PerseusClientPlugin.getPlugin().getOslcDataFetcher().getModelAssignedGlobalConf(serverConfig, this.modelURI, (IProgressMonitor)progress.split(20));
            if (optOslcConfig.isPresent()) {
                GQLOslcConfiguration oslcConfig = (GQLOslcConfiguration)optOslcConfig.get();
                IArtifact oslcConfigArtifact = this.getOslcConfigArtifact(serverConfig, oslcConfig, ((ModelURI)this.modelDataProvider.getPerseusModelURI().get()).getProjectId());
                this.modelDataProvider.storePerseusModelConfigurationURI(oslcConfigArtifact);
            }
        }
        catch (OperationCanceledException e) {
            throw new InterruptedException();
        }
        catch (PerseusServerException | IOException e) {
            throw new InvocationTargetException(e);
        }
    }

    private IArtifact getOslcConfigArtifact(IPerseusServerConfig serverConfig, final GQLOslcConfiguration oslcConfig, String projectID) {
        final IArtifactRepositoryStrategy repositoryStrategy = this.traceabilityStrategy.getRepositoryStrategy(oslcConfig.getFriendUrl());
        this.traceabilityStrategy.findArtifactType("http://open-services.net/ns/config#Configuration").orElseThrow(() -> new IllegalStateException(Messages.FetchHandler_OslcConfigRequiredText));
        IArtifact oslcConfigArtifact = repositoryStrategy.findArtifact(oslcConfig.getUri()).orElseGet(() -> {
            this.session.getTransactionalEditingDomain().getCommandStack().execute((Command)new RecordingCommand(this.session.getTransactionalEditingDomain()){

                protected void doExecute() {
                    TypeDescriptor typeDescriptor = new TypeDescriptor(EnsureModelConfigurationUriRunnable.OSLC_CONFIG_DOMAIN, EnsureModelConfigurationUriRunnable.OSLC_CONFIG_TYPE_NAME);
                    ArtifactDescriptor artifactDescriptor = new ArtifactDescriptor();
                    artifactDescriptor.setTitle(oslcConfig.getTitle());
                    artifactDescriptor.setArtifactURL(oslcConfig.getUri());
                    artifactDescriptor.setTypeDescriptors(Collections.singletonList(typeDescriptor));
                    ((IArtifactRepositoryUpdater)repositoryStrategy.findArtifactRepositoryUpdater().orElseThrow(() -> new IllegalStateException(String.format(Messages.FetchHandler_MissingArtifactRepoText, oslcConfig.getFriendUrl())))).createArtifact((IArtifactDescriptor)artifactDescriptor);
                }
            });
            return (IArtifact)repositoryStrategy.findArtifact(oslcConfig.getUri()).get();
        });
        return oslcConfigArtifact;
    }
}

