/*
 * Decompiled with CFR 0.152.
 */
package fr.obeo.perseus.client.ui.runnables;

import fr.obeo.perseus.client.api.IOslcDataFetcher;
import fr.obeo.perseus.client.api.IPerseusConfigSupport;
import fr.obeo.perseus.client.api.IPerseusServerConfig;
import fr.obeo.perseus.client.api.PerseusServerException;
import fr.obeo.perseus.client.impl.graphql.GQLOAuthFriend;
import fr.obeo.perseus.client.util.ModelURI;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.Objects;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;

public final class QueryOAuthFriendRunnable
implements IRunnableWithProgress {
    private final ModelURI modelURI;
    private final IOslcDataFetcher oslcDataFetcher;
    private final IPerseusConfigSupport configSupport;
    private final String rootServicesURI;
    private GQLOAuthFriend oAuthFriend;

    public QueryOAuthFriendRunnable(ModelURI modelURI, IOslcDataFetcher oslcDataFetcher, IPerseusConfigSupport configSupport, String rootServicesURI) {
        this.modelURI = Objects.requireNonNull(modelURI);
        this.oslcDataFetcher = Objects.requireNonNull(oslcDataFetcher);
        this.configSupport = Objects.requireNonNull(configSupport);
        this.rootServicesURI = Objects.requireNonNull(rootServicesURI);
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)"Fetch friends from server", (int)100);
        try {
            IPerseusServerConfig serverConfig = this.configSupport.getConfigFromModelURI(this.modelURI);
            this.oAuthFriend = this.oslcDataFetcher.getOAuthFriend(serverConfig, this.rootServicesURI, (IProgressMonitor)progress);
        }
        catch (OperationCanceledException e) {
            throw new InterruptedException();
        }
        catch (PerseusServerException | IOException e) {
            throw new InvocationTargetException(e);
        }
    }

    public GQLOAuthFriend getOAuthFriend() {
        return this.oAuthFriend;
    }
}

