/*
 * Decompiled with CFR 0.152.
 */
package fr.obeo.perseus.client.ui.runnables;

import fr.obeo.perseus.client.api.IOslcDataFetcher;
import fr.obeo.perseus.client.api.IPerseusConfigSupport;
import fr.obeo.perseus.client.api.IPerseusServerConfig;
import fr.obeo.perseus.client.api.PerseusServerException;
import fr.obeo.perseus.client.impl.graphql.GQLOAuthFriend;
import fr.obeo.perseus.client.util.ModelURI;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;

public final class QueryOAuthFriendsRunnable
implements IRunnableWithProgress {
    private final ModelURI modelURI;
    private final IOslcDataFetcher oslcDataFetcher;
    private final IPerseusConfigSupport configSupport;
    private List<GQLOAuthFriend> oAuthFriends = new ArrayList<GQLOAuthFriend>();

    public QueryOAuthFriendsRunnable(ModelURI modelURI, IOslcDataFetcher oslcDataFetcher, IPerseusConfigSupport configSupport) {
        this.modelURI = Objects.requireNonNull(modelURI);
        this.oslcDataFetcher = Objects.requireNonNull(oslcDataFetcher);
        this.configSupport = Objects.requireNonNull(configSupport);
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)"Fetch friends from server", (int)100);
        try {
            IPerseusServerConfig serverConfig = this.configSupport.getConfigFromModelURI(this.modelURI);
            this.oAuthFriends = Optional.ofNullable(this.oslcDataFetcher.getOAuthFriends(serverConfig, (IProgressMonitor)progress.split(50))).orElse(Collections.emptyList());
            progress.setWorkRemaining(this.oAuthFriends.size());
        }
        catch (OperationCanceledException e) {
            throw new InterruptedException();
        }
        catch (PerseusServerException | IOException e) {
            throw new InvocationTargetException(e);
        }
    }

    public List<GQLOAuthFriend> getOAuthFriends() {
        return this.oAuthFriends;
    }
}

