/*
 * Decompiled with CFR 0.152.
 */
package fr.obeo.perseus.client.ui.runnables;

import fr.obeo.dsl.traceability.api.IArtifactRepositoryChangeSet;
import fr.obeo.dsl.traceability.api.IArtifactRepositoryStrategy;
import fr.obeo.dsl.traceability.api.ITraceabilityStrategy;
import fr.obeo.perseus.client.api.IOslcDataFetcher;
import fr.obeo.perseus.client.api.IPerseusConfigSupport;
import fr.obeo.perseus.client.api.IPerseusServerConfig;
import fr.obeo.perseus.client.api.PerseusServerException;
import fr.obeo.perseus.client.impl.graphql.GQLOslcLinkDescriptorsByFriend;
import fr.obeo.perseus.client.impl.traceability.ArtifactRepositoryChangeSet;
import fr.obeo.perseus.client.impl.traceability.ArtifactRepositoryChangeSetFactory;
import fr.obeo.perseus.client.impl.traceability.SessionTraceabilityStrategy;
import fr.obeo.perseus.client.ui.Messages;
import fr.obeo.perseus.client.ui.PerseusClientUIPlugin;
import fr.obeo.perseus.client.util.ModelURI;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.operation.IRunnableWithProgress;

public final class QueryOslcLinksRunnable
implements IRunnableWithProgress {
    private final ModelURI modelURI;
    private final ITraceabilityStrategy traceabilityStrategy;
    private final Function<String, Optional<EObject>> findSemanticObjectById;
    private final IOslcDataFetcher oslcDataFetcher;
    private final IPerseusConfigSupport configSupport;
    private List<ArtifactRepositoryChangeSet> artifactLinkChangesModels = new ArrayList<ArtifactRepositoryChangeSet>();
    private List<String> unavailableFriendURLs = Collections.emptyList();

    public QueryOslcLinksRunnable(ModelURI modelURI, ITraceabilityStrategy traceabilityStrategy, Function<String, Optional<EObject>> findSemanticObjectById, IOslcDataFetcher oslcDataFetcher, IPerseusConfigSupport configSupport) {
        this.modelURI = Objects.requireNonNull(modelURI);
        this.traceabilityStrategy = Objects.requireNonNull(traceabilityStrategy);
        this.findSemanticObjectById = Objects.requireNonNull(findSemanticObjectById);
        this.oslcDataFetcher = Objects.requireNonNull(oslcDataFetcher);
        this.configSupport = Objects.requireNonNull(configSupport);
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        try {
            String projectId = this.modelURI.getProjectId();
            IPerseusServerConfig serverConfig = this.configSupport.getConfigFromModelURI(this.modelURI);
            Collection linkDescriptorsByFriend = Optional.ofNullable(this.oslcDataFetcher.getOslcLinkDescriptors(serverConfig, projectId, Long.valueOf(this.modelURI.getModelId()), this.getFriendURLs(), (IProgressMonitor)progress.split(50))).orElse(Collections.emptyList());
            this.check(linkDescriptorsByFriend);
            progress.setWorkRemaining(linkDescriptorsByFriend.size());
            for (GQLOslcLinkDescriptorsByFriend linkDescriptors : linkDescriptorsByFriend) {
                if (progress.isCanceled()) {
                    throw new OperationCanceledException();
                }
                if (linkDescriptors.isAvailable()) {
                    IArtifactRepositoryStrategy repositoryStrategy = this.traceabilityStrategy.getRepositoryStrategy(linkDescriptors.getFriendURL());
                    ArtifactRepositoryChangeSetFactory builder = new ArtifactRepositoryChangeSetFactory(repositoryStrategy, this.findSemanticObjectById);
                    ArtifactRepositoryChangeSet repositoryLinksChangeModel = builder.create(linkDescriptors);
                    this.artifactLinkChangesModels.add(repositoryLinksChangeModel);
                }
                progress.worked(1);
            }
        }
        catch (CoreException e) {
            if (e.getStatus().matches(8)) {
                throw new InterruptedException();
            }
            throw new InvocationTargetException(e);
        }
        catch (OperationCanceledException e) {
            throw new InterruptedException();
        }
        catch (PerseusServerException | IOException e) {
            throw new InvocationTargetException(e);
        }
    }

    private void check(Collection<GQLOslcLinkDescriptorsByFriend> linkDescriptorsByFriend) {
        Set remoteRepositoryURLs = linkDescriptorsByFriend.stream().map(l -> l.getFriendURL()).collect(Collectors.toSet());
        if (remoteRepositoryURLs.size() != linkDescriptorsByFriend.size()) {
            PerseusClientUIPlugin.getPlugin().getLog().log((IStatus)new Status(4, "fr.obeo.perseus.client.ui", Messages.QueryOslcLinksRunnable_Error_InvalidServerData));
        }
        this.unavailableFriendURLs = linkDescriptorsByFriend.stream().filter(ldbf -> !ldbf.isAvailable()).map(ldbf -> ldbf.getFriendURL()).collect(Collectors.toList());
        if (!this.unavailableFriendURLs.isEmpty()) {
            PerseusClientUIPlugin.getPlugin().getLog().log((IStatus)new Status(2, "fr.obeo.perseus.client.ui", String.format(Messages.QueryOslcLinksRunnable_Warn_MissingFriends, linkDescriptorsByFriend.stream().filter(ldbf -> !ldbf.isAvailable()).map(GQLOslcLinkDescriptorsByFriend::getFriendURL).collect(Collectors.joining(", ")))));
        }
        Set localRepositoryURLs = this.traceabilityStrategy.findTraceability().map(t -> t.getRepositories().stream().filter(SessionTraceabilityStrategy::isValid).map(r -> r.getUrl().toString()).collect(Collectors.toSet())).orElse(Collections.emptySet());
        remoteRepositoryURLs.stream().filter(url -> !localRepositoryURLs.contains(url)).forEach(url -> PerseusClientUIPlugin.getPlugin().getLog().log((IStatus)new Status(1, "fr.obeo.perseus.client.ui", String.format(Messages.QueryOslcLinksRunnable_Info_LocalFriendCreated, url))));
    }

    public List<? extends IArtifactRepositoryChangeSet> getArtifactLinkChangesModels() {
        return this.artifactLinkChangesModels;
    }

    public List<String> getFriendURLs() {
        return this.traceabilityStrategy.findTraceability().map(t -> t.getRepositories().stream().map(r -> r.getUrl().toString()).collect(Collectors.toList())).orElse(Collections.emptyList());
    }

    public List<String> getUnavailableFriendURLs() {
        return this.unavailableFriendURLs;
    }
}

